/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.processdefinition;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.SvgIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import io.jmix.core.DataLoadContext;
import io.jmix.core.LoadContext;
import io.jmix.core.Metadata;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.Fragments;
import io.jmix.flowui.UiComponents;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.component.formlayout.JmixFormLayout;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.fragment.FragmentOwner;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.model.CollectionLoader;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.DefaultMainViewParent;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.StandardView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Supply;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.openbpm.control.entity.filter.ProcessDefinitionFilter;
import io.openbpm.control.entity.processdefinition.ProcessDefinitionData;
import io.openbpm.control.entity.processdefinition.ProcessDefinitionState;
import io.openbpm.control.service.processdefinition.ProcessDefinitionLoadContext;
import io.openbpm.control.service.processdefinition.ProcessDefinitionService;
import io.openbpm.control.view.newprocessdeployment.NewProcessDeploymentView;
import io.openbpm.control.view.processdefinition.BulkActivateProcessDefinitionView;
import io.openbpm.control.view.processdefinition.BulkDeleteProcessDefinitionView;
import io.openbpm.control.view.processdefinition.BulkSuspendProcessDefinitionView;
import io.openbpm.control.view.processdefinition.ProcessDefinitionDiagramView;
import io.openbpm.control.view.processdefinition.ProcessDefinitionListItemActionsFragment;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="bpm/process-definitions", layout=DefaultMainViewParent.class)
@ViewController(value="bpm_ProcessDefinition.list")
@ViewDescriptor(value="process-definition-list-view.xml")
public class ProcessDefinitionListView
extends StandardView {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessDefinitionListView.class);
    @ViewComponent
    protected MessageBundle messageBundle;
    @Autowired
    protected ViewNavigators viewNavigators;
    @Autowired
    protected DialogWindows dialogWindows;
    @Autowired
    protected UiComponents uiComponents;
    @Autowired
    protected Fragments fragments;
    @Autowired
    protected Metadata metadata;
    @ViewComponent
    protected CollectionLoader<ProcessDefinitionData> processDefinitionsDl;
    @ViewComponent
    protected InstanceContainer<ProcessDefinitionFilter> processDefinitionFilterDc;
    @Autowired
    protected ProcessDefinitionService processDefinitionService;
    @ViewComponent
    protected JmixFormLayout filterFormLayout;
    @ViewComponent
    protected HorizontalLayout filterPanel;
    @ViewComponent
    protected DataGrid<ProcessDefinitionData> processDefinitionsGrid;

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.addClassNames(new String[]{"pt-s"});
        this.initFilterFormStyles();
    }

    @Subscribe
    public void onBeforeShow(View.BeforeShowEvent event) {
        this.initFilter();
        this.processDefinitionsDl.load();
    }

    @Install(to="processDefinitionsDl", target=Target.DATA_LOADER)
    protected List<ProcessDefinitionData> processDefinitionsDlLoadDelegate(LoadContext<ProcessDefinitionData> loadContext) {
        LoadContext.Query query = loadContext.getQuery();
        ProcessDefinitionFilter filter = (ProcessDefinitionFilter)this.processDefinitionFilterDc.getItemOrNull();
        ProcessDefinitionLoadContext context = new ProcessDefinitionLoadContext().setFilter(filter);
        if (query != null) {
            context = context.setFirstResult(Integer.valueOf(query.getFirstResult())).setMaxResults(Integer.valueOf(query.getMaxResults())).setSort(query.getSort());
        }
        return this.processDefinitionService.findAll(context);
    }

    @Install(to="processDefinitionsGrid.bulkActivate", subject="enabledRule")
    protected boolean processDefinitionsGridBulkActivateEnabledRule() {
        Set selectedItems = this.processDefinitionsGrid.getSelectedItems();
        boolean suspendedDefinitionExists = selectedItems.stream().anyMatch(definition -> BooleanUtils.isTrue((Boolean)definition.getSuspended()));
        return CollectionUtils.isNotEmpty((Collection)selectedItems) && suspendedDefinitionExists;
    }

    @Subscribe(value="processDefinitionsGrid.bulkActivate")
    public void onProcessDefinitionsGridBulkActivate(ActionPerformedEvent event) {
        Set selectedItems = this.processDefinitionsGrid.getSelectedItems();
        this.dialogWindows.view((View)this, BulkActivateProcessDefinitionView.class).withAfterCloseListener(closeEvent -> {
            if (closeEvent.closedWith(StandardOutcome.SAVE)) {
                this.processDefinitionsDl.load();
            }
        }).withViewConfigurer(view -> view.setProcessDefinitions((Collection)selectedItems)).build().open();
    }

    @Install(to="processDefinitionPagination", subject="totalCountDelegate")
    protected Integer processDefinitionPaginationTotalCountDelegate(DataLoadContext dataLoadContext) {
        return (int)this.processDefinitionService.getCount((ProcessDefinitionFilter)this.processDefinitionFilterDc.getItemOrNull());
    }

    @Subscribe(id="processDefinitionFilterDc", target=Target.DATA_CONTAINER)
    public void onProcessDefinitionFilterDcItemPropertyChange(InstanceContainer.ItemPropertyChangeEvent<ProcessDefinitionFilter> event) {
        this.processDefinitionsDl.load();
    }

    @Subscribe(id="clearBtn", subject="clickListener")
    public void onClearBtnClick(ClickEvent<JmixButton> event) {
        ProcessDefinitionFilter filter = (ProcessDefinitionFilter)this.processDefinitionFilterDc.getItem();
        filter.setKeyLike(null);
        filter.setNameLike(null);
        filter.setState(null);
        filter.setLatestVersionOnly(Boolean.valueOf(true));
    }

    @Supply(to="stateComboBox", subject="renderer")
    protected Renderer<ProcessDefinitionState> stateComboBoxRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)processDefinitionState -> {
            if (processDefinitionState == ProcessDefinitionState.ACTIVE) {
                return this.createStateBadge(false);
            }
            if (processDefinitionState == ProcessDefinitionState.SUSPENDED) {
                return this.createStateBadge(true);
            }
            return null;
        });
    }

    @Subscribe(value="processDefinitionsGrid.bulkRemove")
    protected void onProcessDefinitionsGridBulkRemove(ActionPerformedEvent event) {
        Set selectedItems = this.processDefinitionsGrid.getSelectedItems();
        if (selectedItems.isEmpty()) {
            return;
        }
        this.dialogWindows.view((View)this, BulkDeleteProcessDefinitionView.class).withAfterCloseListener(closeEvent -> {
            if (closeEvent.closedWith(StandardOutcome.SAVE)) {
                this.processDefinitionsDl.load();
            }
        }).withViewConfigurer(view -> view.setProcessDefinitions((Collection)selectedItems)).build().open();
    }

    @Subscribe(value="processDefinitionsGrid.deploy")
    protected void onProcessDefinitionsGridDeploy(ActionPerformedEvent event) {
        this.viewNavigators.view((View)this, NewProcessDeploymentView.class).withBackwardNavigation(true).navigate();
    }

    @Install(to="processDefinitionsGrid.name", subject="tooltipGenerator")
    protected String processDefinitionsGridNameTooltipGenerator(ProcessDefinitionData processDefinitionData) {
        return processDefinitionData.getName();
    }

    @Subscribe(value="applyFilter")
    public void onApplyFilter(ActionPerformedEvent event) {
        this.processDefinitionsDl.load();
    }

    @Supply(to="processDefinitionsGrid.status", subject="renderer")
    protected Renderer<ProcessDefinitionData> processDefinitionsGridStatusRenderer() {
        return new ComponentRenderer(arg_0 -> this.createStateBadge(arg_0));
    }

    @Supply(to="processDefinitionsGrid.actions", subject="renderer")
    protected Renderer<ProcessDefinitionData> processDefinitionsGridActionsRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)processDefinitionData -> {
            ProcessDefinitionListItemActionsFragment actionsFragment = (ProcessDefinitionListItemActionsFragment)this.fragments.create((FragmentOwner)this, ProcessDefinitionListItemActionsFragment.class);
            actionsFragment.setProcessDefinition(processDefinitionData);
            return actionsFragment;
        });
    }

    @Install(to="processDefinitionsGrid.bulkSuspend", subject="enabledRule")
    protected boolean processDefinitionsGridBulkSuspendEnabledRule() {
        Set selectedDefinitions = this.processDefinitionsGrid.getSelectedItems();
        boolean activeDefinitionExists = selectedDefinitions.stream().anyMatch(definition -> BooleanUtils.isNotTrue((Boolean)definition.getSuspended()));
        return CollectionUtils.isNotEmpty((Collection)selectedDefinitions) && activeDefinitionExists;
    }

    @Subscribe(value="processDefinitionsGrid.bulkSuspend")
    protected void onProcessDefinitionsGridBulkSuspend(ActionPerformedEvent event) {
        Set selectedItems = this.processDefinitionsGrid.getSelectedItems();
        this.dialogWindows.view((View)this, BulkSuspendProcessDefinitionView.class).withAfterCloseListener(closeEvent -> {
            if (closeEvent.closedWith(StandardOutcome.SAVE)) {
                this.processDefinitionsDl.load();
            }
        }).withViewConfigurer(view -> view.setProcessDefinitions((Collection)selectedItems)).build().open();
    }

    protected void initFilterFormStyles() {
        this.filterFormLayout.getOwnComponents().forEach(component -> component.addClassName("pt-xs"));
        this.filterPanel.addClassNames(new String[]{"pt-xs", "pl-m", "pb-xs", "pr-m", "border", "rounded-l", "border-contrast-20"});
    }

    protected void initFilter() {
        ProcessDefinitionFilter filter = (ProcessDefinitionFilter)this.metadata.create(ProcessDefinitionFilter.class);
        filter.setLatestVersionOnly(Boolean.valueOf(true));
        this.processDefinitionFilterDc.setItem((Object)filter);
    }

    protected Span createStateBadge(ProcessDefinitionData processDefinitionData) {
        return this.createStateBadge(BooleanUtils.isTrue((Boolean)processDefinitionData.getSuspended()));
    }

    protected Span createStateBadge(boolean suspended) {
        Span badge = (Span)this.uiComponents.create(Span.class);
        String themeNames = suspended ? "badge warning pill" : "badge success pill";
        badge.getElement().getThemeList().add((Object)themeNames);
        String messageKey = suspended ? "processDefinitionList.status.suspended" : "processDefinitionList.status.active";
        badge.setText(this.messageBundle.getMessage(messageKey));
        return badge;
    }

    @Supply(to="processDefinitionsGrid.key", subject="renderer")
    protected Renderer<ProcessDefinitionData> processDefinitionsGridKeyRenderer() {
        StreamResource iconResource = new StreamResource("preview.svg", (InputStreamFactory & Serializable)() -> this.getClass().getResourceAsStream("/META-INF/resources/icons/preview.svg"));
        return new ComponentRenderer((SerializableFunction & Serializable)processDefinitionData -> {
            HorizontalLayout layout = (HorizontalLayout)this.uiComponents.create(HorizontalLayout.class);
            layout.setAlignItems(FlexComponent.Alignment.BASELINE);
            Span key = (Span)this.uiComponents.create(Span.class);
            key.setText(processDefinitionData.getKey());
            key.setWidthFull();
            key.addClassNames(new String[]{"overflow-hidden", "overflow-ellipsis"});
            JmixButton previewBtn = this.createDiagramPreviewButton(processDefinitionData, iconResource);
            layout.addAndExpand(new Component[]{key});
            layout.add(new Component[]{previewBtn});
            return layout;
        });
    }

    protected JmixButton createDiagramPreviewButton(ProcessDefinitionData processDefinitionData, StreamResource iconResource) {
        SvgIcon previewIcon = (SvgIcon)this.uiComponents.create(SvgIcon.class);
        previewIcon.setSrc((AbstractStreamResource)iconResource);
        JmixButton previewBtn = (JmixButton)this.uiComponents.create(JmixButton.class);
        previewBtn.setIcon((Component)previewIcon);
        previewBtn.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE});
        previewBtn.addClickListener((ComponentEventListener & Serializable)clickEvent -> this.dialogWindows.view((View)this, ProcessDefinitionDiagramView.class).withViewConfigurer(view -> view.setProcessDefinition(processDefinitionData)).build().open());
        return previewBtn;
    }
}

