/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.processinstance.generalpanel;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.datetimepicker.DateTimePicker;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.router.RouteParameters;
import io.jmix.core.Messages;
import io.jmix.core.Metadata;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.Dialogs;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.component.checkbox.JmixCheckbox;
import io.jmix.flowui.component.formlayout.JmixFormLayout;
import io.jmix.flowui.component.textarea.JmixTextArea;
import io.jmix.flowui.fragment.Fragment;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.DialogWindow;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.openbpm.control.entity.processdefinition.ProcessDefinitionData;
import io.openbpm.control.entity.processinstance.ProcessInstanceData;
import io.openbpm.control.entity.processinstance.ProcessInstanceState;
import io.openbpm.control.service.processdefinition.ProcessDefinitionService;
import io.openbpm.control.service.processinstance.ProcessInstanceService;
import io.openbpm.control.view.processinstance.ActivateProcessInstanceView;
import io.openbpm.control.view.processinstance.ProcessInstanceDetailView;
import io.openbpm.control.view.processinstance.SuspendProcessInstanceView;
import io.openbpm.control.view.processinstancemigration.ProcessInstanceMigrationView;
import io.openbpm.control.view.processinstanceterminate.ProcessInstanceTerminateView;
import org.springframework.beans.factory.annotation.Autowired;

@FragmentDescriptor(value="general-panel-fragment.xml")
public class GeneralPanelFragment
extends Fragment<FlexLayout> {
    @ViewComponent
    protected InstanceContainer<ProcessInstanceData> processInstanceDataDc;
    @Autowired
    protected Dialogs dialogs;
    @Autowired
    protected Notifications notifications;
    @Autowired
    protected ViewNavigators viewNavigators;
    @Autowired
    protected Metadata metadata;
    @ViewComponent
    protected MessageBundle messageBundle;
    @Autowired
    protected DialogWindows dialogWindows;
    @Autowired
    protected Messages messages;
    @Autowired
    protected ProcessInstanceService processInstanceService;
    @Autowired
    protected ProcessDefinitionService processDefinitionService;
    @ViewComponent
    protected JmixFormLayout processInstanceInfoGroupBox;
    @ViewComponent
    protected TextField processDefinitionField;
    @ViewComponent
    protected DateTimePicker endTimeField;
    @ViewComponent
    protected JmixTextArea deleteReason;
    @ViewComponent
    protected VerticalLayout upperPanel;
    @ViewComponent
    protected JmixButton infoBtn;
    @ViewComponent
    protected Button suspendBtn;
    @ViewComponent
    protected Button activateBtn;
    @ViewComponent
    protected VerticalLayout runtimeInstanceActions;
    @ViewComponent
    protected JmixCheckbox externallyTerminatedField;

    @Subscribe
    public void onReady(Fragment.ReadyEvent event) {
        this.processInstanceInfoGroupBox.getComponents().forEach(component -> component.addClassNames(new String[]{"pt-s"}));
    }

    @Subscribe(target=Target.HOST_CONTROLLER)
    public void onHostBeforeShow(View.BeforeShowEvent event) {
        ProcessInstanceData processInstanceData = (ProcessInstanceData)this.processInstanceDataDc.getItem();
        this.initProcessDefinitionField(processInstanceData);
        boolean hasEndTime = processInstanceData.getEndTime() != null;
        this.endTimeField.setVisible(hasEndTime);
        this.deleteReason.setVisible(hasEndTime);
        this.externallyTerminatedField.setVisible(hasEndTime);
        this.initActionButtons();
    }

    protected void initProcessDefinitionField(ProcessInstanceData processInstanceData) {
        String value = processInstanceData.getProcessDefinitionVersion() != null ? this.messages.formatMessage("", "common.processDefinitionKeyAndVersion", new Object[]{processInstanceData.getProcessDefinitionKey(), processInstanceData.getProcessDefinitionVersion()}) : processInstanceData.getProcessDefinitionId();
        this.processDefinitionField.setValue(value);
    }

    protected void initActionButtons() {
        ProcessInstanceData item = (ProcessInstanceData)this.processInstanceDataDc.getItem();
        if (item.getState() == ProcessInstanceState.COMPLETED) {
            this.runtimeInstanceActions.setVisible(false);
        } else {
            boolean suspended = Boolean.TRUE.equals(((ProcessInstanceData)this.processInstanceDataDc.getItem()).getSuspended());
            this.activateBtn.setVisible(suspended);
            this.suspendBtn.setVisible(!suspended);
        }
    }

    @Subscribe(value="refreshAction")
    public void onRefreshAction(ActionPerformedEvent event) {
        this.reopenProcessInstanceDetailsView();
    }

    @Subscribe(value="activateAction")
    public void onActivateAction(ActionPerformedEvent event) {
        ProcessInstanceData processInstanceData = (ProcessInstanceData)this.processInstanceDataDc.getItem();
        DialogWindow dialogWindow = this.dialogWindows.view(UiComponentUtils.getCurrentView(), ActivateProcessInstanceView.class).withAfterCloseListener(closeEvent -> {
            if (closeEvent.closedWith(StandardOutcome.SAVE)) {
                this.reopenProcessInstanceDetailsView();
            }
        }).build();
        ActivateProcessInstanceView activateProcessInstanceView = (ActivateProcessInstanceView)dialogWindow.getView();
        activateProcessInstanceView.setProcessInstanceData(processInstanceData);
        dialogWindow.open();
    }

    @Subscribe(value="openProcessDefinitionEditorBtn")
    public void openProcessDefinitionEditor(ClickEvent<Button> event) {
        ProcessDefinitionData processDefinitionData = this.processDefinitionService.getById(((ProcessInstanceData)this.processInstanceDataDc.getItem()).getProcessDefinitionId());
        if (processDefinitionData != null) {
            this.viewNavigators.detailView(UiComponentUtils.getCurrentView(), ProcessDefinitionData.class).withRouteParameters(new RouteParameters("id", processDefinitionData.getId())).withBackwardNavigation(true).navigate();
        } else {
            this.notifications.create(this.messageBundle.getMessage("processDoesNotExist")).withType(Notifications.Type.WARNING).show();
        }
    }

    @Subscribe(value="suspendAction")
    public void onSuspendAction(ActionPerformedEvent event) {
        DialogWindow dialogWindow = this.dialogWindows.view(UiComponentUtils.getCurrentView(), SuspendProcessInstanceView.class).withAfterCloseListener(closeEvent -> {
            if (closeEvent.closedWith(StandardOutcome.SAVE)) {
                this.reopenProcessInstanceDetailsView();
            }
        }).build();
        SuspendProcessInstanceView suspendProcessInstanceView = (SuspendProcessInstanceView)dialogWindow.getView();
        suspendProcessInstanceView.setProcessInstanceData((ProcessInstanceData)this.processInstanceDataDc.getItem());
        dialogWindow.open();
    }

    @Subscribe(value="terminateAction")
    public void onTerminateAction(ActionPerformedEvent event) {
        DialogWindow dialog = this.dialogWindows.view(UiComponentUtils.getCurrentView(), ProcessInstanceTerminateView.class).withAfterCloseListener(afterCloseEvent -> {
            if (afterCloseEvent.closedWith(StandardOutcome.SAVE)) {
                this.notifications.create(this.messageBundle.getMessage("processInstanceTerminated")).withType(Notifications.Type.SUCCESS).show();
                this.reopenProcessInstanceDetailsView();
            }
        }).build();
        ((ProcessInstanceTerminateView)dialog.getView()).setProcessInstanceData((ProcessInstanceData)this.processInstanceDataDc.getItem());
        dialog.open();
    }

    @Subscribe(value="migrateAction")
    public void onMigrateAction(ActionPerformedEvent event) {
        ProcessDefinitionData processDefinitionData = (ProcessDefinitionData)this.metadata.create(ProcessDefinitionData.class);
        ProcessInstanceData processInstanceData = (ProcessInstanceData)this.processInstanceDataDc.getItem();
        processDefinitionData.setId(processInstanceData.getProcessDefinitionId());
        processDefinitionData.setKey(processInstanceData.getProcessDefinitionKey());
        processDefinitionData.setVersion(processInstanceData.getProcessDefinitionVersion());
        DialogWindow dialog = this.dialogWindows.view(UiComponentUtils.getCurrentView(), ProcessInstanceMigrationView.class).withAfterCloseListener(afterCloseEvent -> {
            if (afterCloseEvent.closedWith(StandardOutcome.SAVE)) {
                this.notifications.create(this.messageBundle.getMessage("processInstanceMigrated")).withType(Notifications.Type.SUCCESS).show();
                this.reopenProcessInstanceDetailsView();
            }
        }).build();
        ((ProcessInstanceMigrationView)dialog.getView()).setProcessDefinitionData(processDefinitionData);
        ((ProcessInstanceMigrationView)dialog.getView()).setProcessInstanceData(processInstanceData);
        dialog.open();
    }

    @Subscribe(value="infoBtn")
    protected void onInfoButtonClickBtnClick(ClickEvent<Button> event) {
        this.upperPanel.setVisible(!this.upperPanel.isVisible());
        if (this.upperPanel.isVisible()) {
            this.infoBtn.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
            this.infoBtn.setTitle(this.messageBundle.getMessage("hideProcessInstanceDetails"));
        } else {
            this.infoBtn.removeThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
            this.infoBtn.setTitle(this.messageBundle.getMessage("viewProcessInstanceDetails"));
        }
    }

    protected void reopenProcessInstanceDetailsView() {
        ProcessInstanceDetailView view = (ProcessInstanceDetailView)UiComponentUtils.getCurrentView();
        view.reopenView();
    }
}

