/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.processinstance.runtime;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.data.event.SortEvent;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableSupplier;
import io.jmix.core.DataLoadContext;
import io.jmix.core.LoadContext;
import io.jmix.core.Messages;
import io.jmix.core.Metadata;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.Dialogs;
import io.jmix.flowui.Fragments;
import io.jmix.flowui.action.DialogAction;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.component.grid.TreeDataGrid;
import io.jmix.flowui.component.tabsheet.JmixTabSheet;
import io.jmix.flowui.fragment.Fragment;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.kit.action.Action;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.kit.action.ActionVariant;
import io.jmix.flowui.model.CollectionContainer;
import io.jmix.flowui.model.CollectionLoader;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Supply;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.openbpm.control.entity.activity.ActivityInstanceTreeItem;
import io.openbpm.control.entity.filter.ExternalTaskFilter;
import io.openbpm.control.entity.filter.IncidentFilter;
import io.openbpm.control.entity.filter.JobFilter;
import io.openbpm.control.entity.filter.UserTaskFilter;
import io.openbpm.control.entity.filter.VariableFilter;
import io.openbpm.control.entity.processinstance.ProcessInstanceData;
import io.openbpm.control.entity.processinstance.ProcessInstanceState;
import io.openbpm.control.entity.variable.ObjectTypeInfo;
import io.openbpm.control.entity.variable.VariableInstanceData;
import io.openbpm.control.entity.variable.VariableValueInfo;
import io.openbpm.control.service.externaltask.ExternalTaskService;
import io.openbpm.control.service.incident.IncidentService;
import io.openbpm.control.service.job.JobService;
import io.openbpm.control.service.usertask.UserTaskService;
import io.openbpm.control.service.variable.VariableLoadContext;
import io.openbpm.control.service.variable.VariableService;
import io.openbpm.control.view.processinstance.LazyTabContent;
import io.openbpm.control.view.processinstance.event.ExternalTaskCountUpdateEvent;
import io.openbpm.control.view.processinstance.event.ExternalTaskRetriesUpdateEvent;
import io.openbpm.control.view.processinstance.event.IncidentCountUpdateEvent;
import io.openbpm.control.view.processinstance.event.IncidentUpdateEvent;
import io.openbpm.control.view.processinstance.event.JobCountUpdateEvent;
import io.openbpm.control.view.processinstance.event.JobRetriesUpdateEvent;
import io.openbpm.control.view.processinstance.event.UserTaskCountUpdateEvent;
import io.openbpm.control.view.processinstance.runtime.ExternalTasksTabFragment;
import io.openbpm.control.view.processinstance.runtime.JobsTabFragment;
import io.openbpm.control.view.processinstance.runtime.RuntimeIncidentsTabFragment;
import io.openbpm.control.view.processinstance.runtime.RuntimeUserTasksTabFragment;
import io.openbpm.control.view.processvariable.VariableInstanceDataDetail;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.lang.Nullable;

@FragmentDescriptor(value="runtime-tab-fragment.xml")
public class RuntimeTabFragment
extends Fragment<HorizontalLayout> {
    public static final String USER_TASKS_TAB_ID = "userTasksTab";
    public static final String JOBS_TAB_ID = "jobsTab";
    public static final String EXTERNAL_TASKS_TAB_ID = "externalTasksTab";
    public static final String INCIDENTS_TAB_ID = "incidentsTab";
    public static final int VARIABLES_TAB_IDX = 0;
    public static final int USER_TASKS_TAB_IDX = 1;
    public static final int JOBS_TAB_IDX = 2;
    public static final int EXTERNAL_TASKS_TAB_IDX = 3;
    public static final int INCIDENTS_TAB_IDX = 4;
    @Autowired
    protected Metadata metadata;
    @Autowired
    protected Fragments fragments;
    @Autowired
    protected DialogWindows dialogWindows;
    @Autowired
    protected VariableService variableService;
    @Autowired
    protected UserTaskService userTaskService;
    @Autowired
    protected ExternalTaskService externalTaskService;
    @Autowired
    protected JobService jobService;
    @Autowired
    protected IncidentService incidentService;
    @Autowired
    private Dialogs dialogs;
    @Autowired
    private Messages messages;
    @ViewComponent
    protected MessageBundle messageBundle;
    @ViewComponent
    protected CollectionContainer<ActivityInstanceTreeItem> runtimeActivityInstancesDc;
    @ViewComponent
    protected InstanceContainer<ProcessInstanceData> processInstanceDataDc;
    @ViewComponent
    protected CollectionLoader<VariableInstanceData> runtimeVariablesDl;
    @ViewComponent
    protected DataGrid<VariableInstanceData> runtimeVariablesGrid;
    @ViewComponent
    protected TreeDataGrid<ActivityInstanceTreeItem> activityInstancesTree;
    @ViewComponent
    protected JmixTabSheet runtimeTabsheet;
    @ViewComponent
    protected VerticalLayout activityTreeContainer;
    protected VariableFilter variableFilter;

    @Subscribe
    public void onReady(Fragment.ReadyEvent event) {
        this.activityTreeContainer.addClassNames(new String[]{"pt-s", "pr-s"});
    }

    @Subscribe(target=Target.HOST_CONTROLLER)
    public void onHostBeforeShow(View.BeforeShowEvent event) {
        ProcessInstanceData item = (ProcessInstanceData)this.processInstanceDataDc.getItem();
        if (item.getState() != ProcessInstanceState.COMPLETED) {
            this.variableFilter = (VariableFilter)this.metadata.create(VariableFilter.class);
            this.variableFilter.setProcessInstanceId(item.getInstanceId());
            this.updateVariablesTabCaption(0);
            this.initUserTasksTab();
            this.initJobsTab();
            this.initExternalTasksTab();
            this.initIncidentsTab();
            this.activityInstancesTree.expand((Collection)this.runtimeActivityInstancesDc.getItems());
            this.runtimeVariablesDl.load();
            this.loadAndUpdateVariablesCount();
            this.loadAndUpdateUserTasksCount();
            this.loadAndUpdateJobsCount();
            this.loadAndUpdateExternalTasksCount();
            this.loadAndUpdateIncidentsCount();
        }
    }

    protected void initIncidentsTab() {
        Tab incidentsTab = this.createTab(INCIDENTS_TAB_ID, "incidentsTabCaption", VaadinIcon.WARNING);
        this.runtimeTabsheet.add(incidentsTab, (Component)new LazyTabContent(() -> this.createIncidentsFragment()), 4);
    }

    @Subscribe(value="runtimeTabsheet")
    public void onRuntimeTabsheetSelectedChange(JmixTabSheet.SelectedChangeEvent event) {
        Component tabContent;
        String tabId;
        Tab selectedTab = event.getSelectedTab();
        String string = tabId = selectedTab != null ? (String)selectedTab.getId().orElse(null) : null;
        if (StringUtils.equals((CharSequence)tabId, (CharSequence)USER_TASKS_TAB_ID)) {
            Component tabContent2 = this.getTabContent(selectedTab);
            if (tabContent2 instanceof RuntimeUserTasksTabFragment) {
                RuntimeUserTasksTabFragment userTasksFragment = (RuntimeUserTasksTabFragment)tabContent2;
                userTasksFragment.refreshIfChanged(this.getSelectedActivityInstanceId());
            }
        } else if (StringUtils.equals((CharSequence)tabId, (CharSequence)JOBS_TAB_ID)) {
            Component tabContent3 = this.getTabContent(selectedTab);
            if (tabContent3 instanceof JobsTabFragment) {
                JobsTabFragment jobsTabFragment = (JobsTabFragment)tabContent3;
                jobsTabFragment.refreshIfRequired();
            }
        } else if (StringUtils.equals((CharSequence)tabId, (CharSequence)EXTERNAL_TASKS_TAB_ID)) {
            Component tabContent4 = this.getTabContent(selectedTab);
            if (tabContent4 instanceof ExternalTasksTabFragment) {
                ExternalTasksTabFragment externalTasksTabFragment = (ExternalTasksTabFragment)tabContent4;
                externalTasksTabFragment.refreshIfChanged(this.getSelectedActivityId());
            }
        } else if (StringUtils.equals((CharSequence)tabId, (CharSequence)INCIDENTS_TAB_ID) && (tabContent = this.getTabContent(selectedTab)) instanceof RuntimeIncidentsTabFragment) {
            RuntimeIncidentsTabFragment incidentsTabFragment = (RuntimeIncidentsTabFragment)tabContent;
            incidentsTabFragment.refreshIfChanged(this.getSelectedActivityId());
        }
    }

    @EventListener
    public void handleUserTaskCountUpdate(UserTaskCountUpdateEvent event) {
        this.updateUserTasksTabCaption(event.getCount());
    }

    @EventListener
    public void handleIncidentCountUpdate(IncidentCountUpdateEvent event) {
        this.updateIncidentsTabCaption(event.getCount());
    }

    @EventListener
    public void handleIncidentUpdate(IncidentUpdateEvent event) {
        this.loadAndUpdateIncidentsCount();
    }

    @EventListener
    public void handleJobRetriesUpdate(JobRetriesUpdateEvent event) {
        this.loadAndUpdateJobsCount();
        this.loadAndUpdateIncidentsCount();
    }

    @EventListener
    public void handleExternalTaskRetriesUpdate(ExternalTaskRetriesUpdateEvent event) {
        this.loadAndUpdateExternalTasksCount();
        this.loadAndUpdateIncidentsCount();
    }

    @EventListener
    public void handleJobCountUpdate(JobCountUpdateEvent event) {
        this.updateJobsTabCaption(event.getCount());
    }

    @EventListener
    public void handleExternalTaskCountUpdate(ExternalTaskCountUpdateEvent event) {
        this.updateExternalTasksTabCaption(event.getCount());
    }

    @Install(to="activityInstancesTree.activityId", subject="tooltipGenerator")
    protected String activityInstancesTreeActivityIdTooltipGenerator(ActivityInstanceTreeItem activityInstanceTreeItem) {
        if (activityInstanceTreeItem.getParentActivityInstance() == null) {
            return this.messageBundle.formatMessage("rootActivityInstanceTreeItem.tooltip", new Object[]{activityInstanceTreeItem.getActivityName()});
        }
        return String.format("%s: %s", activityInstanceTreeItem.getActivityType(), activityInstanceTreeItem.getActivityName());
    }

    @Supply(to="runtimeVariablesGrid.value", subject="renderer")
    protected Renderer<VariableInstanceData> runtimeVariablesGridValueRenderer() {
        return new TextRenderer(arg_0 -> this.getVariableValueColumnText(arg_0));
    }

    @Install(to="runtimeVariablesGrid.value", subject="tooltipGenerator")
    protected String runtimeVariablesGridValueIdTooltipGenerator(VariableInstanceData variableInstanceData) {
        return this.getVariableValueColumnText(variableInstanceData);
    }

    @Subscribe(value="runtimeVariablesGrid.create")
    public void onRuntimeVariablesGridCreate(ActionPerformedEvent event) {
        this.dialogWindows.detail(UiComponentUtils.getCurrentView(), VariableInstanceData.class).withViewClass(VariableInstanceDataDetail.class).withViewConfigurer(view -> {
            view.setNewVariable(true);
            view.setSaveEnabled(true);
            view.setValidationEnabled(true);
            view.setProcessInstanceId(((ProcessInstanceData)this.processInstanceDataDc.getItem()).getId());
        }).newEntity().withInitializer(variableInstanceData -> {
            VariableValueInfo variableValueInfo = (VariableValueInfo)this.metadata.create(VariableValueInfo.class);
            ObjectTypeInfo objectTypeInfo = (ObjectTypeInfo)this.metadata.create(ObjectTypeInfo.class);
            variableValueInfo.setObject(objectTypeInfo);
            variableInstanceData.setValueInfo(variableValueInfo);
            variableInstanceData.setExecutionId(((ProcessInstanceData)this.processInstanceDataDc.getItem()).getInstanceId());
        }).withAfterCloseListener(afterCloseEvent -> {
            if (afterCloseEvent.closedWith(StandardOutcome.SAVE)) {
                this.runtimeVariablesDl.load();
            }
        }).build().open();
    }

    @Subscribe(value="runtimeVariablesGrid.edit")
    public void onRuntimeVariablesGridEdit(ActionPerformedEvent event) {
        VariableInstanceData variableInstanceData = (VariableInstanceData)this.runtimeVariablesGrid.getSingleSelectedItem();
        if (variableInstanceData == null) {
            return;
        }
        this.dialogWindows.detail(UiComponentUtils.getCurrentView(), VariableInstanceData.class).editEntity((Object)variableInstanceData).withViewClass(VariableInstanceDataDetail.class).withViewConfigurer(view -> {
            view.setSaveEnabled(true);
            view.setValidationEnabled(true);
        }).withAfterCloseListener(afterCloseEvent -> {
            if (afterCloseEvent.closedWith(StandardOutcome.SAVE)) {
                this.runtimeVariablesDl.load();
            }
        }).build().open();
    }

    @Subscribe(value="runtimeVariablesGrid.remove")
    public void onRuntimeVariablesGridRemove(ActionPerformedEvent event) {
        Set variableItems = this.runtimeVariablesGrid.getSelectedItems();
        if (variableItems.isEmpty()) {
            return;
        }
        ((Dialogs.OptionDialogBuilder)((Dialogs.OptionDialogBuilder)this.dialogs.createOptionDialog().withHeader(this.messageBundle.getMessage("removeProcessVariableTaskDialog.header"))).withText(this.messageBundle.getMessage("removeProcessVariableTaskDialog.text"))).withActions(new Action[]{new DialogAction(DialogAction.Type.YES).withIcon(VaadinIcon.TRASH.create()).withText(this.messages.getMessage("actions.Remove")).withVariant(ActionVariant.PRIMARY).withHandler(actionPerformedEvent -> {
            ProcessInstanceData processInstanceData = (ProcessInstanceData)this.processInstanceDataDc.getItem();
            this.variableService.removeVariablesLocal(processInstanceData.getInstanceId(), variableItems);
            this.runtimeVariablesDl.load();
        }), new DialogAction(DialogAction.Type.CANCEL)}).open();
    }

    @Install(to="runtimeVariablesDl", target=Target.DATA_LOADER)
    protected List<VariableInstanceData> runtimeVariablesDlLoadDelegate(LoadContext<VariableInstanceData> loadContext) {
        LoadContext.Query query = loadContext.getQuery();
        VariableLoadContext context = new VariableLoadContext().setFilter(this.variableFilter);
        if (query != null) {
            context.setFirstResult(Integer.valueOf(query.getFirstResult())).setMaxResults(Integer.valueOf(query.getMaxResults())).setSort(query.getSort());
        }
        return this.variableService.findRuntimeVariables(context);
    }

    @Install(to="runtimeVariablesPagination", subject="totalCountDelegate")
    protected Integer runtimeVariablesPaginationTotalCountDelegate(DataLoadContext dataLoadContext) {
        int runtimeVariablesCount = (int)this.variableService.getRuntimeVariablesCount(this.variableFilter);
        this.updateVariablesTabCaption(runtimeVariablesCount);
        return runtimeVariablesCount;
    }

    @Subscribe(value="runtimeVariablesGrid")
    public void onRuntimeVariablesGridGridSort(SortEvent<DataGrid<VariableInstanceData>, GridSortOrder<DataGrid<VariableInstanceData>>> event) {
        this.runtimeVariablesDl.load();
    }

    @Subscribe(id="runtimeActivityInstancesDc", target=Target.DATA_CONTAINER)
    public void onRuntimeActivityInstancesDcItemChange(InstanceContainer.ItemChangeEvent<ActivityInstanceTreeItem> event) {
        ActivityInstanceTreeItem treeItem = (ActivityInstanceTreeItem)event.getItem();
        this.variableFilter.setActivityInstanceId(treeItem != null ? treeItem.getActivityInstanceId() : null);
        int selectedTabIdx = this.runtimeTabsheet.getSelectedIndex();
        switch (selectedTabIdx) {
            case 0: {
                this.runtimeVariablesDl.load();
                break;
            }
            case 1: {
                Component tabContent = this.getTabContent(this.runtimeTabsheet.getSelectedTab());
                if (!(tabContent instanceof RuntimeUserTasksTabFragment)) break;
                RuntimeUserTasksTabFragment userTasksFragment = (RuntimeUserTasksTabFragment)tabContent;
                userTasksFragment.refreshIfChanged(this.getSelectedActivityInstanceId());
                break;
            }
            case 4: {
                Component tabContent = this.getTabContent(this.runtimeTabsheet.getSelectedTab());
                if (!(tabContent instanceof RuntimeIncidentsTabFragment)) break;
                RuntimeIncidentsTabFragment incidentsTabFragment = (RuntimeIncidentsTabFragment)tabContent;
                incidentsTabFragment.refreshIfChanged(this.getSelectedActivityId());
                break;
            }
            case 3: {
                Component tabContent = this.getTabContent(this.runtimeTabsheet.getSelectedTab());
                if (!(tabContent instanceof ExternalTasksTabFragment)) break;
                ExternalTasksTabFragment externalTasksTabFragment = (ExternalTasksTabFragment)tabContent;
                externalTasksTabFragment.refreshIfChanged(this.getSelectedActivityId());
                break;
            }
        }
        this.loadAndUpdateUserTasksCount();
        this.loadAndUpdateVariablesCount();
        this.loadAndUpdateIncidentsCount();
        this.loadAndUpdateExternalTasksCount();
    }

    protected void loadAndUpdateVariablesCount() {
        int runtimeVariablesCount = (int)this.variableService.getRuntimeVariablesCount(this.variableFilter);
        this.updateVariablesTabCaption(runtimeVariablesCount);
    }

    protected void loadAndUpdateJobsCount() {
        JobFilter jobFilter = (JobFilter)this.metadata.create(JobFilter.class);
        jobFilter.setProcessInstanceId(((ProcessInstanceData)this.processInstanceDataDc.getItem()).getId());
        long jobsCount = this.jobService.getCount(jobFilter);
        this.updateJobsTabCaption(jobsCount);
    }

    protected void loadAndUpdateUserTasksCount() {
        UserTaskFilter userTaskFilter = (UserTaskFilter)this.metadata.create(UserTaskFilter.class);
        userTaskFilter.setActivityInstanceId(this.getSelectedActivityInstanceId());
        userTaskFilter.setProcessInstanceId(((ProcessInstanceData)this.processInstanceDataDc.getItem()).getId());
        long runtimeTasksCount = this.userTaskService.getRuntimeTasksCount(userTaskFilter);
        this.updateUserTasksTabCaption(runtimeTasksCount);
    }

    protected void loadAndUpdateExternalTasksCount() {
        ExternalTaskFilter filter = (ExternalTaskFilter)this.metadata.create(ExternalTaskFilter.class);
        filter.setActivityId(this.getSelectedActivityId());
        filter.setProcessInstanceId(((ProcessInstanceData)this.processInstanceDataDc.getItem()).getId());
        long tasksCount = this.externalTaskService.getRunningTasksCount(filter);
        this.updateExternalTasksTabCaption(tasksCount);
    }

    protected void loadAndUpdateIncidentsCount() {
        IncidentFilter filter = (IncidentFilter)this.metadata.create(IncidentFilter.class);
        filter.setActivityId(this.getSelectedActivityId());
        filter.setProcessInstanceId(((ProcessInstanceData)this.processInstanceDataDc.getItem()).getId());
        long runtimeIncidentsCount = this.incidentService.getRuntimeIncidentCount(filter);
        this.updateIncidentsTabCaption(runtimeIncidentsCount);
    }

    @Nullable
    protected String getSelectedActivityInstanceId() {
        ActivityInstanceTreeItem item = (ActivityInstanceTreeItem)this.activityInstancesTree.getSingleSelectedItem();
        return item != null ? item.getActivityInstanceId() : null;
    }

    @Nullable
    protected String getSelectedActivityId() {
        ActivityInstanceTreeItem item = (ActivityInstanceTreeItem)this.activityInstancesTree.getSingleSelectedItem();
        return item != null ? item.getActivityId() : null;
    }

    protected void initUserTasksTab() {
        Tab userTasksTab = this.createTab(USER_TASKS_TAB_ID, "tasksTabCaption", VaadinIcon.USER_CARD);
        this.runtimeTabsheet.add(userTasksTab, (Component)new LazyTabContent(() -> this.createUserTasksFragment()), 1);
    }

    protected void initJobsTab() {
        Tab jobsTab = this.createTab(JOBS_TAB_ID, "jobsTabCaption", VaadinIcon.COGS);
        this.runtimeTabsheet.add(jobsTab, (Component)new LazyTabContent((SerializableSupplier & Serializable)() -> this.fragments.create(this.getParentController(), JobsTabFragment.class)), 2);
    }

    protected void initExternalTasksTab() {
        Tab externalTasksTab = this.createTab(EXTERNAL_TASKS_TAB_ID, "externalTasksTabCaption", VaadinIcon.CLUSTER);
        this.runtimeTabsheet.add(externalTasksTab, (Component)new LazyTabContent((SerializableSupplier & Serializable)() -> this.fragments.create(this.getParentController(), ExternalTasksTabFragment.class)), 3);
    }

    protected void updateUserTasksTabCaption(long userTasksCount) {
        this.updateTabCaption(1, "tasksTabCaption", userTasksCount, VaadinIcon.USER_CARD);
    }

    protected void updateExternalTasksTabCaption(long externalTaskCount) {
        this.updateTabCaption(3, "externalTasksTabCaption", externalTaskCount, VaadinIcon.CLUSTER);
    }

    protected void updateIncidentsTabCaption(long incidentCount) {
        this.updateTabCaption(4, "incidentsTabCaption", incidentCount, VaadinIcon.WARNING);
    }

    protected void updateJobsTabCaption(long jobsCount) {
        this.updateTabCaption(2, "jobsTabCaption", jobsCount, VaadinIcon.COGS);
    }

    protected void updateVariablesTabCaption(int runtimeVariablesCount) {
        this.updateTabCaption(0, "variablesTabCaption", (long)runtimeVariablesCount, VaadinIcon.CURLY_BRACKETS);
    }

    protected Component createUserTasksFragment() {
        RuntimeUserTasksTabFragment userTasksFragment = (RuntimeUserTasksTabFragment)this.fragments.create(this.getParentController(), RuntimeUserTasksTabFragment.class);
        userTasksFragment.setSelectedActivityInstanceId(this.getSelectedActivityInstanceId());
        return userTasksFragment;
    }

    protected Component createIncidentsFragment() {
        RuntimeIncidentsTabFragment incidentsTabFragment = (RuntimeIncidentsTabFragment)this.fragments.create(this.getParentController(), RuntimeIncidentsTabFragment.class);
        incidentsTabFragment.setSelectedActivityId(this.getSelectedActivityId());
        return incidentsTabFragment;
    }

    @Nullable
    protected String getVariableValueColumnText(VariableInstanceData variableInstance) {
        if (variableInstance.getValue() != null) {
            return variableInstance.getValue().toString();
        }
        return null;
    }

    protected void updateTabCaption(int tabIndex, String messageKey, long count, VaadinIcon icon) {
        this.runtimeTabsheet.getTabAt(tabIndex).setLabel(this.messageBundle.formatMessage(messageKey, new Object[]{count}));
        this.runtimeTabsheet.getTabAt(tabIndex).addComponentAsFirst((Component)icon.create());
    }

    protected Tab createTab(String id, String messageKey, VaadinIcon icon) {
        Tab tab = (Tab)this.uiComponents.create(Tab.class);
        tab.setId(id);
        tab.setLabel(this.messageBundle.formatMessage(messageKey, new Object[]{0}));
        tab.addComponentAsFirst((Component)icon.create());
        return tab;
    }

    @Nullable
    protected Component getTabContent(Tab tab) {
        Component contentByTab = this.runtimeTabsheet.getContentByTab(tab);
        return contentByTab != null ? (Component)contentByTab.getChildren().findFirst().orElse(null) : null;
    }
}

