/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.taskreassign;

import com.vaadin.flow.router.Route;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.component.textfield.TypedTextField;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.view.DefaultMainViewParent;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.StandardView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.openbpm.control.entity.UserTaskData;
import io.openbpm.control.service.usertask.UserTaskService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="bpm/taskreassign", layout=DefaultMainViewParent.class)
@ViewController(value="bpm_TaskReassignView")
@ViewDescriptor(value="task-reassign-view.xml")
@DialogMode(width="30em")
public class TaskReassignView
extends StandardView {
    @Autowired
    protected UserTaskService userTaskService;
    @Autowired
    protected Notifications notifications;
    @ViewComponent
    protected MessageBundle messageBundle;
    @ViewComponent
    protected TypedTextField<String> newAssigneeField;
    protected List<String> taskIdList = new ArrayList();

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.addClassNames(new String[]{"pt-s", "gap-xs"});
    }

    public void setTaskDataList(Collection<UserTaskData> userTaskDataList) {
        if (userTaskDataList != null) {
            this.taskIdList = userTaskDataList.stream().map(UserTaskData::getId).collect(Collectors.toList());
        }
    }

    @Subscribe(value="reassignAction")
    public void onReassignAction(ActionPerformedEvent event) {
        String newAssignee = this.newAssigneeField.getValue();
        if (StringUtils.isBlank((CharSequence)newAssignee)) {
            newAssignee = null;
        }
        for (String taskId : this.taskIdList) {
            this.userTaskService.setAssignee(taskId, newAssignee);
        }
        this.close(StandardOutcome.SAVE);
    }

    @Subscribe(value="closeAction")
    public void onCloseAction(ActionPerformedEvent event) {
        this.close(StandardOutcome.CLOSE);
    }
}

