/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.configuration;

import feign.Client;
import feign.Contract;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import io.openbpm.control.restsupport.DynamicEngineUrlRequestInterceptor;
import io.openbpm.control.restsupport.FeignClientProvider;
import io.openbpm.control.restsupport.ObjectToStringConverter;
import io.openbpm.control.restsupport.camunda.CamundaFeignErrorDecoder;
import io.openbpm.control.service.engine.EngineService;
import java.util.Optional;
import org.camunda.community.rest.EnableCamundaRestClient;
import org.camunda.community.rest.client.FeignClientConfiguration;
import org.camunda.community.rest.config.CamundaRestClientProperties;
import org.springframework.cloud.openfeign.FeignClientProperties;
import org.springframework.cloud.openfeign.FeignClientsConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableCamundaRestClient
@Import(value={FeignClientsConfiguration.class, FeignClientConfiguration.class})
public class CamundaFeignConfiguration {
    @Bean(value={"control_FeignClientProvider"})
    public FeignClientProvider feignClientProvider(Encoder encoder, Decoder decoder, Retryer retryer, ErrorDecoder errorDecoder, Contract contract, Optional<Client> client, FeignClientProperties properties) {
        return new FeignClientProvider(encoder, decoder, retryer, errorDecoder, contract, (Client)client.orElse(null), properties);
    }

    @Bean(value={"control_DynamicEngineUrlRequestInterceptor"})
    public RequestInterceptor dynamicUrlInterceptor(EngineService engineService) {
        return new DynamicEngineUrlRequestInterceptor(engineService);
    }

    @Bean(value={"control_ObjectToStringConverter"})
    public ObjectToStringConverter objectToStringConverter() {
        return new ObjectToStringConverter();
    }

    @Bean(value={"control_CamundaFeignErrorDecoder"})
    @Primary
    public ErrorDecoder errorDecoder(CamundaRestClientProperties restClientProperties) {
        return new CamundaFeignErrorDecoder(restClientProperties);
    }
}

