/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.service.dashboard.impl;

import feign.FeignException;
import feign.RequestInterceptor;
import feign.auth.BasicAuthRequestInterceptor;
import io.jmix.core.Id;
import io.jmix.core.Metadata;
import io.jmix.core.event.EntityChangedEvent;
import io.openbpm.control.entity.ProcessExecutionGraphEntry;
import io.openbpm.control.entity.dashboard.ProcessDefinitionStatistics;
import io.openbpm.control.entity.engine.AuthType;
import io.openbpm.control.entity.engine.BpmEngine;
import io.openbpm.control.mapper.ProcessDefinitionMapper;
import io.openbpm.control.property.UiProperties;
import io.openbpm.control.restsupport.FeignClientCreationContext;
import io.openbpm.control.restsupport.FeignClientProvider;
import io.openbpm.control.service.dashboard.DashboardService;
import io.openbpm.control.util.EngineRestUtils;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.camunda.community.rest.client.api.HistoryApiClient;
import org.camunda.community.rest.client.api.ProcessDefinitionApiClient;
import org.camunda.community.rest.client.api.ProcessInstanceApiClient;
import org.camunda.community.rest.client.api.TaskApiClient;
import org.camunda.community.rest.client.model.CountResultDto;
import org.camunda.community.rest.client.model.HistoricProcessInstanceDto;
import org.camunda.community.rest.client.model.HistoricProcessInstanceQueryDto;
import org.camunda.community.rest.client.model.ProcessInstanceQueryDto;
import org.camunda.community.rest.client.model.TaskQueryDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.event.TransactionalEventListener;

@Service(value="control_DashboardService")
public class DashboardServiceImpl
implements DashboardService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DashboardServiceImpl.class);
    protected final Metadata metadata;
    protected final FeignClientProvider feignClientProvider;
    protected final ProcessDefinitionMapper processDefinitionMapper;
    protected final UiProperties uiProperties;
    protected Map<UUID, TaskApiClient> taskClientByEngineId = new ConcurrentHashMap();
    protected Map<UUID, ProcessDefinitionApiClient> processDefinitionClientByEngineId = new ConcurrentHashMap();
    protected Map<UUID, ProcessInstanceApiClient> processInstanceClientByEngineId = new ConcurrentHashMap();
    protected Map<UUID, HistoryApiClient> historyApiClientByEngineId = new ConcurrentHashMap();

    public DashboardServiceImpl(Metadata metadata, FeignClientProvider feignClientProvider, ProcessDefinitionMapper processDefinitionMapper, UiProperties uiProperties) {
        this.metadata = metadata;
        this.feignClientProvider = feignClientProvider;
        this.processDefinitionMapper = processDefinitionMapper;
        this.uiProperties = uiProperties;
    }

    public List<ProcessExecutionGraphEntry> getRecentActivityStatistics(BpmEngine bpmEngine) {
        OffsetDateTime from = OffsetDateTime.now().minusDays(this.uiProperties.getRecentActivityDays()).with(LocalTime.MIN);
        OffsetDateTime to = OffsetDateTime.now().minusDays(1L).with(LocalTime.MAX);
        HistoryApiClient historyApiClient = this.historyApiClientByEngineId.computeIfAbsent(bpmEngine.getId(), engineId -> (HistoryApiClient)this.createClient(bpmEngine, HistoryApiClient.class));
        List startedInstances = this.loadStartedInstances(from, to, historyApiClient);
        List finishedInstances = this.loadFinishedInstances(from, to, historyApiClient);
        return this.createWeeklyStatistics(from, to, startedInstances, finishedInstances);
    }

    public long getUserTasksCount(BpmEngine bpmEngine) {
        TaskApiClient taskApiClient = this.taskClientByEngineId.computeIfAbsent(bpmEngine.getId(), engineId -> (TaskApiClient)this.createClient(bpmEngine, TaskApiClient.class));
        try {
            ResponseEntity response = taskApiClient.queryTasksCount(new TaskQueryDto());
            if (response.getStatusCode().is2xxSuccessful()) {
                return EngineRestUtils.getCountResult((CountResultDto)((CountResultDto)response.getBody()));
            }
            log.error("Error while user task count loading, status code {}", (Object)response.getStatusCode());
            return 0L;
        }
        catch (FeignException e) {
            log.error("Error while user task count loading ", (Throwable)e);
            return 0L;
        }
    }

    public long getDeployedProcessesCount(BpmEngine bpmEngine) {
        ProcessDefinitionApiClient processDefinitionApiClient = this.processDefinitionClientByEngineId.computeIfAbsent(bpmEngine.getId(), engineId -> (ProcessDefinitionApiClient)this.createClient(bpmEngine, ProcessDefinitionApiClient.class));
        try {
            ResponseEntity response = processDefinitionApiClient.getProcessDefinitionsCount(null, null, null, null, null, null, null, null, null, null, null, null, null, Boolean.valueOf(true), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
            if (response.getStatusCode().is2xxSuccessful()) {
                return EngineRestUtils.getCountResult((CountResultDto)((CountResultDto)response.getBody()));
            }
            log.error("Error while deployed processes count loading, status code {}", (Object)response.getStatusCode());
            return 0L;
        }
        catch (FeignException e) {
            log.error("Error while deployed processes count loading ", (Throwable)e);
            return 0L;
        }
    }

    public long getRunningProcessCount(BpmEngine bpmEngine) {
        ProcessInstanceApiClient processInstanceApiClient = this.processInstanceClientByEngineId.computeIfAbsent(bpmEngine.getId(), engineId -> (ProcessInstanceApiClient)this.createClient(bpmEngine, ProcessInstanceApiClient.class));
        try {
            ResponseEntity response = processInstanceApiClient.queryProcessInstancesCount(new ProcessInstanceQueryDto().active(Boolean.valueOf(true)));
            if (response.getStatusCode().is2xxSuccessful()) {
                return EngineRestUtils.getCountResult((CountResultDto)((CountResultDto)response.getBody()));
            }
            log.error("Error while running process instances count loading, status code {}", (Object)response.getStatusCode());
            return 0L;
        }
        catch (FeignException e) {
            log.error("Error while running process instances loading", (Throwable)e);
            return 0L;
        }
    }

    public long getSuspendedProcessCount(BpmEngine bpmEngine) {
        ProcessInstanceApiClient processInstanceApiClient = this.processInstanceClientByEngineId.computeIfAbsent(bpmEngine.getId(), engineId -> (ProcessInstanceApiClient)this.createClient(bpmEngine, ProcessInstanceApiClient.class));
        try {
            ResponseEntity response = processInstanceApiClient.queryProcessInstancesCount(new ProcessInstanceQueryDto().suspended(Boolean.valueOf(true)));
            if (response.getStatusCode().is2xxSuccessful()) {
                return EngineRestUtils.getCountResult((CountResultDto)((CountResultDto)response.getBody()));
            }
            log.error("Error while suspended process instances count loading, status code {}", (Object)response.getStatusCode());
            return 0L;
        }
        catch (FeignException e) {
            log.error("Error while suspended process instances loading", (Throwable)e);
            return 0L;
        }
    }

    public List<ProcessDefinitionStatistics> getProcessDefinitionStatistics(BpmEngine bpmEngine) {
        ProcessDefinitionApiClient processDefinitionApiClient = this.processDefinitionClientByEngineId.computeIfAbsent(bpmEngine.getId(), engineId -> (ProcessDefinitionApiClient)this.createClient(bpmEngine, ProcessDefinitionApiClient.class));
        try {
            ResponseEntity response = processDefinitionApiClient.getProcessDefinitionStatistics(Boolean.valueOf(true), null, null, Boolean.valueOf(true));
            if (response.getStatusCode().is2xxSuccessful()) {
                List statisticsResultDtos = (List)response.getBody();
                return CollectionUtils.emptyIfNull((Collection)statisticsResultDtos).stream().map(arg_0 -> ((ProcessDefinitionMapper)this.processDefinitionMapper).fromStatisticsResultDto(arg_0)).toList();
            }
            log.error("Error on process process definition statistics, status code {}", (Object)response.getStatusCode());
            return List.of();
        }
        catch (FeignException e) {
            log.error("Error while process definition statistics loading", (Throwable)e);
            return List.of();
        }
    }

    protected List<ProcessExecutionGraphEntry> createWeeklyStatistics(OffsetDateTime from, OffsetDateTime to, List<HistoricProcessInstanceDto> startedInstances, List<HistoricProcessInstanceDto> finishedInstances) {
        Map<LocalDate, Long> startedInstancesByDate = startedInstances.stream().collect(Collectors.groupingBy(historicInstance -> historicInstance.getStartTime().toLocalDate(), Collectors.counting()));
        Map<LocalDate, Long> finishedInstancesByDate = finishedInstances.stream().filter(historicTask -> historicTask.getEndTime() != null).collect(Collectors.groupingBy(historicInstance -> historicInstance.getEndTime().toLocalDate(), Collectors.counting()));
        LocalDate fromDate = from.toLocalDate();
        LocalDate toDate = to.toLocalDate().plusDays(1L);
        Stream<LocalDate> dates = fromDate.datesUntil(toDate);
        List<ProcessExecutionGraphEntry> items = dates.map(date -> {
            ProcessExecutionGraphEntry item = (ProcessExecutionGraphEntry)this.metadata.create(ProcessExecutionGraphEntry.class);
            item.setDate(date);
            item.setStartedInstancesCount(startedInstancesByDate.getOrDefault(date, 0L));
            item.setCompletedInstancesCount(finishedInstancesByDate.getOrDefault(date, 0L));
            return item;
        }).toList();
        return items;
    }

    protected <V> V createClient(BpmEngine engine, Class<V> clientClass) {
        return (V)this.feignClientProvider.createCamundaClient(new FeignClientCreationContext(clientClass).setUrl(engine.getBaseUrl()).setRequestInterceptor(this.createBpmEngineRequestInterceptor(engine)));
    }

    @Nullable
    protected RequestInterceptor createBpmEngineRequestInterceptor(BpmEngine engine) {
        RequestInterceptor requestInterceptor = null;
        if (BooleanUtils.isTrue((Boolean)engine.getAuthEnabled())) {
            if (engine.getAuthType() == AuthType.BASIC) {
                requestInterceptor = new BasicAuthRequestInterceptor(engine.getBasicAuthUsername(), engine.getBasicAuthPassword());
            } else if (engine.getAuthType() == AuthType.HTTP_HEADER) {
                requestInterceptor = requestTemplate -> requestTemplate.header(engine.getHttpHeaderName(), new String[]{engine.getHttpHeaderValue()});
            }
        }
        return requestInterceptor;
    }

    protected List<HistoricProcessInstanceDto> loadStartedInstances(OffsetDateTime from, OffsetDateTime to, HistoryApiClient historyApiClient) {
        HistoricProcessInstanceQueryDto queryByStartedDate = new HistoricProcessInstanceQueryDto().startedAfter(from).startedBefore(to);
        try {
            ResponseEntity response = historyApiClient.queryHistoricProcessInstances(Integer.valueOf(0), Integer.valueOf(this.uiProperties.getRecentActivityMaxResults()), queryByStartedDate);
            if (response.getStatusCode().is2xxSuccessful()) {
                return Optional.ofNullable((List)response.getBody()).orElse(List.of());
            }
            log.error("Unable to load started instances by period: from '{}', to '{}', status code: {}", new Object[]{from, to, response.getStatusCode().value()});
            return List.of();
        }
        catch (FeignException e) {
            log.error("Unable to load started instances by period: from '{}', to '{}'", new Object[]{from, to, e});
            return List.of();
        }
    }

    protected List<HistoricProcessInstanceDto> loadFinishedInstances(OffsetDateTime from, OffsetDateTime to, HistoryApiClient historyApiClient) {
        HistoricProcessInstanceQueryDto queryByStartedDate = new HistoricProcessInstanceQueryDto().finishedAfter(from).finishedBefore(to);
        try {
            ResponseEntity response = historyApiClient.queryHistoricProcessInstances(Integer.valueOf(0), Integer.valueOf(this.uiProperties.getRecentActivityMaxResults()), queryByStartedDate);
            if (response.getStatusCode().is2xxSuccessful()) {
                return Optional.ofNullable((List)response.getBody()).orElse(List.of());
            }
            log.error("Unable to load finished instances by period: from '{}', to '{}', status code: {}", new Object[]{from, to, response.getStatusCode().value()});
            return List.of();
        }
        catch (FeignException e) {
            log.error("Unable to load finished instances by period: from '{}', to '{}'", new Object[]{from, to, e});
            return List.of();
        }
    }

    @TransactionalEventListener
    public void onBpmEngineChangedAfterCommit(EntityChangedEvent<BpmEngine> event) {
        Id entityId = event.getEntityId();
        if (event.getType() == EntityChangedEvent.Type.DELETED || event.getType() == EntityChangedEvent.Type.UPDATED) {
            this.processDefinitionClientByEngineId.remove((UUID)entityId.getValue());
            this.processInstanceClientByEngineId.remove((UUID)entityId.getValue());
            this.historyApiClientByEngineId.remove((UUID)entityId.getValue());
            this.taskClientByEngineId.remove((UUID)entityId.getValue());
        }
    }
}

