/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.service.decisiondefinition.impl;

import feign.FeignException;
import feign.utils.ExceptionUtils;
import io.jmix.core.Sort;
import io.openbpm.control.entity.decisiondefinition.DecisionDefinitionData;
import io.openbpm.control.entity.filter.DecisionDefinitionFilter;
import io.openbpm.control.exception.EngineNotSelectedException;
import io.openbpm.control.mapper.DecisionDefinitionMapper;
import io.openbpm.control.service.decisiondefinition.DecisionDefinitionLoadContext;
import io.openbpm.control.service.decisiondefinition.DecisionDefinitionService;
import io.openbpm.control.service.decisiondefinition.impl.DecisionDefinitionQueryImpl;
import io.openbpm.control.util.QueryUtils;
import jakarta.annotation.Nullable;
import java.net.ConnectException;
import java.util.List;
import lombok.Generated;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.community.rest.client.api.DecisionDefinitionApiClient;
import org.camunda.community.rest.client.model.DecisionDefinitionDiagramDto;
import org.camunda.community.rest.impl.RemoteRepositoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service(value="control_DecisionDefinitionService")
public class DecisionDefinitionServiceImpl
implements DecisionDefinitionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DecisionDefinitionServiceImpl.class);
    protected final RemoteRepositoryService remoteRepositoryService;
    protected final DecisionDefinitionMapper decisionDefinitionMapper;
    protected final DecisionDefinitionApiClient decisionDefinitionApiClient;

    public DecisionDefinitionServiceImpl(RemoteRepositoryService remoteRepositoryService, DecisionDefinitionMapper decisionDefinitionMapper, DecisionDefinitionApiClient decisionDefinitionApiClient) {
        this.remoteRepositoryService = remoteRepositoryService;
        this.decisionDefinitionMapper = decisionDefinitionMapper;
        this.decisionDefinitionApiClient = decisionDefinitionApiClient;
    }

    public List<DecisionDefinitionData> findLatestVersions() {
        try {
            return ((DecisionDefinitionQuery)this.createDecisionDefinitionQuery().orderByDecisionDefinitionVersion().asc()).latestVersion().list().stream().map(arg_0 -> ((DecisionDefinitionMapper)this.decisionDefinitionMapper).fromDecisionDefinitionModel(arg_0)).toList();
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load latest versions of decision definitions because BPM engine not selected");
                return List.of();
            }
            throw e;
        }
    }

    public List<DecisionDefinitionData> findAllByKey(String decisionDefinitionKey) {
        return ((DecisionDefinitionQuery)this.createDecisionDefinitionQuery().orderByDecisionDefinitionVersion().asc()).decisionDefinitionKey(decisionDefinitionKey).list().stream().map(arg_0 -> ((DecisionDefinitionMapper)this.decisionDefinitionMapper).fromDecisionDefinitionModel(arg_0)).toList();
    }

    public List<DecisionDefinitionData> findAll(DecisionDefinitionLoadContext context) {
        try {
            DecisionDefinitionQuery decisionDefinitionQuery = this.createDecisionDefinitionQuery((DecisionDefinitionFilter)context.getFilter(), context.getSort());
            List decisionDefinitions = context.getFirstResult() != null && context.getMaxResults() != null ? decisionDefinitionQuery.listPage(context.getFirstResult().intValue(), context.getMaxResults().intValue()) : decisionDefinitionQuery.list();
            return decisionDefinitions.stream().map(arg_0 -> ((DecisionDefinitionMapper)this.decisionDefinitionMapper).fromDecisionDefinitionModel(arg_0)).toList();
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load decision definitions because BPM engine not selected");
                return List.of();
            }
            if (rootCause instanceof ConnectException) {
                log.error("Unable to load decision definitions because of connection error: ", (Throwable)e);
                return List.of();
            }
            throw e;
        }
    }

    public long getCount(@Nullable DecisionDefinitionFilter filter) {
        DecisionDefinitionQuery decisionDefinitionQuery = this.createDecisionDefinitionQuery(filter, null);
        return decisionDefinitionQuery.count();
    }

    public DecisionDefinitionData getById(String decisionDefinitionId) {
        try {
            DecisionDefinition decisionDefinition = (DecisionDefinition)this.createDecisionDefinitionQuery().decisionDefinitionId(decisionDefinitionId).singleResult();
            return this.decisionDefinitionMapper.fromDecisionDefinitionModel(decisionDefinition);
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load decision definition by id '{}' because BPM engine not selected", (Object)decisionDefinitionId);
                return null;
            }
            if (rootCause instanceof ConnectException) {
                log.error("Unable load decision definition by id '{}' because of connection error: ", (Object)decisionDefinitionId, (Object)e);
                return null;
            }
            throw e;
        }
    }

    public String getDmnXml(String decisionDefinitionId) {
        try {
            ResponseEntity decisionDefinitionDmnXml = this.decisionDefinitionApiClient.getDecisionDefinitionDmnXmlById(decisionDefinitionId);
            DecisionDefinitionDiagramDto decisionDefinitionDiagramDto = (DecisionDefinitionDiagramDto)decisionDefinitionDmnXml.getBody();
            if (decisionDefinitionDmnXml.getStatusCode().is2xxSuccessful() && decisionDefinitionDiagramDto != null) {
                return decisionDefinitionDiagramDto.getDmnXml();
            }
            return null;
        }
        catch (Exception e) {
            FeignException feignException;
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load decision definition XML by id '{}' because BPM engine not selected", (Object)decisionDefinitionId);
                return null;
            }
            if (rootCause instanceof ConnectException) {
                log.error("Unable load decision definition XML by id '{}' because of connection error: ", (Object)decisionDefinitionId, (Object)e);
                return null;
            }
            if (rootCause instanceof FeignException && (feignException = (FeignException)rootCause).status() == 404) {
                log.warn("Unable to load decision definition XML by id '{}' because decision does not exist", (Object)decisionDefinitionId);
                return null;
            }
            throw e;
        }
    }

    protected DecisionDefinitionQuery createDecisionDefinitionQuery(@Nullable DecisionDefinitionFilter filter, @Nullable Sort sort) {
        DecisionDefinitionQueryImpl decisionDefinitionQuery = new DecisionDefinitionQueryImpl(this.decisionDefinitionApiClient);
        QueryUtils.addDecisionDefinitionFilters((DecisionDefinitionQuery)decisionDefinitionQuery, (DecisionDefinitionFilter)filter);
        QueryUtils.addDecisionDefinitionSort((DecisionDefinitionQuery)decisionDefinitionQuery, (Sort)sort);
        return decisionDefinitionQuery;
    }

    protected DecisionDefinitionQuery createDecisionDefinitionQuery() {
        return this.createDecisionDefinitionQuery(null, null);
    }
}

