/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.service.decisioninstance.impl;

import io.openbpm.control.service.decisioninstance.impl.HistoricDecisionInstanceQueryImpl;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.camunda.bpm.engine.history.HistoricDecisionInputInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.history.HistoricDecisionOutputInstance;
import org.camunda.community.rest.client.api.HistoryApiClient;
import org.camunda.community.rest.client.model.CountResultDto;
import org.camunda.community.rest.client.model.HistoricDecisionInputInstanceDto;
import org.camunda.community.rest.client.model.HistoricDecisionOutputInstanceDto;
import org.camunda.community.rest.impl.query.BaseQuery;
import org.camunda.community.rest.impl.query.QueryOrderingProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class HistoricDecisionInstanceQueryImpl
extends BaseQuery<HistoricDecisionInstanceQuery, HistoricDecisionInstance>
implements HistoricDecisionInstanceQuery {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HistoricDecisionInstanceQueryImpl.class);
    private final HistoryApiClient historyApiClient;
    private String decisionInstanceId;
    private String decisionInstanceIdIn;
    private String decisionDefinitionId;
    private String decisionDefinitionIdIn;
    private String decisionDefinitionKey;
    private String decisionDefinitionKeyIn;
    private String decisionDefinitionName;
    private String decisionDefinitionNameLike;
    private String processDefinitionId;
    private String processDefinitionKey;
    private String processInstanceId;
    private String caseDefinitionId;
    private String caseDefinitionKey;
    private String caseInstanceId;
    private String activityIdIn;
    private String activityInstanceIdIn;
    private OffsetDateTime evaluatedBefore;
    private OffsetDateTime evaluatedAfter;
    private String userId;
    private String rootDecisionInstanceId;
    private Boolean rootDecisionInstancesOnly;
    private String decisionRequirementsDefinitionId;
    private String decisionRequirementsDefinitionKey;
    private Boolean includeInputs;
    private Boolean includeOutputs;
    private Boolean disableBinaryFetching;
    private Boolean disableCustomObjectDeserialization;

    public HistoricDecisionInstanceQueryImpl(HistoryApiClient historyApiClient) {
        this.historyApiClient = historyApiClient;
    }

    public long count() {
        ResponseEntity response = this.historyApiClient.getHistoricDecisionInstancesCount(this.decisionInstanceId, this.decisionInstanceIdIn, this.decisionDefinitionId, this.decisionDefinitionIdIn, this.decisionDefinitionKey, this.decisionDefinitionKeyIn, this.decisionDefinitionName, this.decisionDefinitionNameLike, this.processDefinitionId, this.processDefinitionKey, this.processInstanceId, this.caseDefinitionId, this.caseDefinitionKey, this.caseInstanceId, this.activityIdIn, this.activityInstanceIdIn, this.getTenantIds() != null ? String.join((CharSequence)",", this.getTenantIds()) : null, Boolean.valueOf(this.getTenantIdsSet()), this.evaluatedBefore, this.evaluatedAfter, this.userId, this.rootDecisionInstanceId, this.rootDecisionInstancesOnly, this.decisionRequirementsDefinitionId, this.decisionRequirementsDefinitionKey);
        CountResultDto countResultDto = (CountResultDto)response.getBody();
        if (response.getStatusCode().is2xxSuccessful() && countResultDto != null) {
            return countResultDto.getCount();
        }
        log.error("Error on loading decisions count, status code {}", (Object)response.getStatusCode());
        return -1L;
    }

    public List<HistoricDecisionInstance> listPage(int firstResult, int maxResult) {
        QueryOrderingProperty queryOrderingProperty = this.sortProperty();
        String orderBy = queryOrderingProperty != null ? queryOrderingProperty.getProperty() : null;
        String orderDirection = queryOrderingProperty != null && queryOrderingProperty.getDirection() != null ? queryOrderingProperty.getDirection().name().toLowerCase() : null;
        ResponseEntity response = this.historyApiClient.getHistoricDecisionInstances(this.decisionInstanceId, this.decisionInstanceIdIn, this.decisionDefinitionId, this.decisionDefinitionIdIn, this.decisionDefinitionKey, this.decisionDefinitionKeyIn, this.decisionDefinitionName, this.decisionDefinitionNameLike, this.processDefinitionId, this.processDefinitionKey, this.processInstanceId, this.caseDefinitionId, this.caseDefinitionKey, this.caseInstanceId, this.activityIdIn, this.activityInstanceIdIn, this.getTenantIds() != null ? String.join((CharSequence)",", this.getTenantIds()) : null, Boolean.valueOf(this.getTenantIdsSet()), this.evaluatedBefore, this.evaluatedAfter, this.userId, this.rootDecisionInstanceId, this.rootDecisionInstancesOnly, this.decisionRequirementsDefinitionId, this.decisionRequirementsDefinitionKey, this.includeInputs, this.includeOutputs, this.disableBinaryFetching, this.disableCustomObjectDeserialization, orderBy, orderDirection, Integer.valueOf(firstResult), Integer.valueOf(maxResult));
        List historicDecisionInstanceDtoList = (List)response.getBody();
        if (response.getStatusCode().is2xxSuccessful() && historicDecisionInstanceDtoList != null) {
            return historicDecisionInstanceDtoList.stream().map(e -> new HistoricDecisionInstanceImpl(e.getId(), e.getDecisionDefinitionId(), e.getDecisionDefinitionKey(), e.getDecisionDefinitionName(), this.convertOffsetDateTimeToDate(e.getEvaluationTime()), this.convertOffsetDateTimeToDate(e.getRemovalTime()), e.getProcessDefinitionKey(), e.getProcessDefinitionId(), e.getProcessInstanceId(), e.getCaseDefinitionKey(), e.getCaseDefinitionId(), e.getCaseInstanceId(), e.getActivityId(), e.getActivityInstanceId(), e.getUserId(), this.getHistoryDecisionInstanceInputs(e.getInputs()), this.getHistoryDecisionInstanceOutputs(e.getOutputs()), e.getCollectResultValue(), e.getRootDecisionInstanceId(), e.getRootProcessInstanceId(), e.getDecisionRequirementsDefinitionId(), e.getDecisionRequirementsDefinitionKey(), e.getTenantId())).toList();
        }
        log.error("Error on loading decisions, status code {}", (Object)response.getStatusCode());
        return List.of();
    }

    private Date convertOffsetDateTimeToDate(OffsetDateTime offsetDateTime) {
        if (offsetDateTime != null) {
            return Date.from(offsetDateTime.toInstant());
        }
        return null;
    }

    private List<HistoricDecisionInputInstance> getHistoryDecisionInstanceInputs(List<HistoricDecisionInputInstanceDto> inputs) {
        if (inputs != null) {
            return inputs.stream().map(e -> new HistoricDecisionInputInstanceImpl(e.getId(), e.getDecisionInstanceId(), e.getClauseId(), e.getClauseName(), e.getType(), e.getValue(), null, e.getErrorMessage(), this.convertOffsetDateTimeToDate(e.getCreateTime()), e.getRootProcessInstanceId(), this.convertOffsetDateTimeToDate(e.getRemovalTime()))).toList();
        }
        return List.of();
    }

    private List<HistoricDecisionOutputInstance> getHistoryDecisionInstanceOutputs(List<HistoricDecisionOutputInstanceDto> outputs) {
        if (outputs != null) {
            return outputs.stream().map(e -> new HistoricDecisionOutputInstanceImpl(e.getId(), e.getDecisionInstanceId(), e.getClauseId(), e.getClauseName(), e.getRuleId(), e.getRuleOrder(), e.getVariableName(), e.getType(), e.getValue(), null, e.getErrorMessage(), this.convertOffsetDateTimeToDate(e.getCreateTime()), e.getRootProcessInstanceId(), this.convertOffsetDateTimeToDate(e.getRemovalTime()))).toList();
        }
        return List.of();
    }

    public HistoricDecisionInstanceQuery decisionInstanceId(String decisionInstanceId) {
        this.decisionInstanceId = decisionInstanceId;
        return this;
    }

    public HistoricDecisionInstanceQuery decisionInstanceIdIn(String ... decisionInstanceIdIn) {
        if (decisionInstanceIdIn != null) {
            this.decisionInstanceIdIn = String.join((CharSequence)",", decisionInstanceIdIn);
        }
        return this;
    }

    public HistoricDecisionInstanceQuery decisionDefinitionId(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
        return this;
    }

    public HistoricDecisionInstanceQuery decisionDefinitionIdIn(String ... decisionDefinitionIdIn) {
        if (decisionDefinitionIdIn != null) {
            this.decisionDefinitionIdIn = String.join((CharSequence)",", decisionDefinitionIdIn);
        }
        return this;
    }

    public HistoricDecisionInstanceQuery decisionDefinitionKey(String decisionDefinitionKey) {
        this.decisionDefinitionKey = decisionDefinitionKey;
        return this;
    }

    public HistoricDecisionInstanceQuery decisionDefinitionKeyIn(String ... decisionDefinitionKeyIn) {
        if (decisionDefinitionKeyIn != null) {
            this.decisionDefinitionKeyIn = String.join((CharSequence)",", decisionDefinitionKeyIn);
        }
        return null;
    }

    public HistoricDecisionInstanceQuery decisionDefinitionName(String decisionDefinitionName) {
        this.decisionDefinitionName = decisionDefinitionName;
        return this;
    }

    public HistoricDecisionInstanceQuery decisionDefinitionNameLike(String decisionDefinitionNameLike) {
        this.decisionDefinitionNameLike = decisionDefinitionNameLike;
        return this;
    }

    public HistoricDecisionInstanceQuery processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    public HistoricDecisionInstanceQuery processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    public HistoricDecisionInstanceQuery processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    public HistoricDecisionInstanceQuery caseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
        return this;
    }

    public HistoricDecisionInstanceQuery caseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
        return this;
    }

    public HistoricDecisionInstanceQuery caseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    public HistoricDecisionInstanceQuery activityIdIn(String ... activityIdIn) {
        if (activityIdIn != null) {
            this.activityIdIn = String.join((CharSequence)",", activityIdIn);
        }
        return this;
    }

    public HistoricDecisionInstanceQuery activityInstanceIdIn(String ... strings) {
        if (strings != null) {
            this.activityInstanceIdIn = String.join((CharSequence)",", strings);
        }
        return this;
    }

    public HistoricDecisionInstanceQuery evaluatedBefore(Date evaluatedBefore) {
        if (evaluatedBefore != null) {
            this.evaluatedBefore = evaluatedBefore.toInstant().atOffset(ZoneOffset.UTC);
        }
        return this;
    }

    public HistoricDecisionInstanceQuery evaluatedAfter(Date evaluatedAfter) {
        if (evaluatedAfter != null) {
            this.evaluatedAfter = evaluatedAfter.toInstant().atOffset(ZoneOffset.UTC);
        }
        return this;
    }

    public HistoricDecisionInstanceQuery userId(String userId) {
        this.userId = userId;
        return this;
    }

    public HistoricDecisionInstanceQuery includeInputs() {
        this.includeInputs = true;
        return this;
    }

    public HistoricDecisionInstanceQuery includeOutputs() {
        this.includeOutputs = true;
        return this;
    }

    public HistoricDecisionInstanceQuery disableBinaryFetching() {
        this.disableBinaryFetching = true;
        return this;
    }

    public HistoricDecisionInstanceQuery disableCustomObjectDeserialization() {
        this.disableCustomObjectDeserialization = true;
        return this;
    }

    public HistoricDecisionInstanceQuery rootDecisionInstanceId(String rootDecisionInstanceId) {
        this.rootDecisionInstanceId = rootDecisionInstanceId;
        return this;
    }

    public HistoricDecisionInstanceQuery rootDecisionInstancesOnly() {
        this.rootDecisionInstancesOnly = true;
        return this;
    }

    public HistoricDecisionInstanceQuery decisionRequirementsDefinitionId(String decisionRequirementsDefinitionId) {
        this.decisionRequirementsDefinitionId = decisionRequirementsDefinitionId;
        return this;
    }

    public HistoricDecisionInstanceQuery decisionRequirementsDefinitionKey(String decisionrequirementsDefinitionKey) {
        this.decisionRequirementsDefinitionKey = decisionrequirementsDefinitionKey;
        return this;
    }

    public HistoricDecisionInstanceQuery orderByEvaluationTime() {
        this.orderBy("evaluationTime");
        return this;
    }
}

