/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.service.externaltask.impl;

import com.google.common.base.Strings;
import io.jmix.core.Sort;
import io.openbpm.control.entity.ExternalTaskData;
import io.openbpm.control.entity.filter.ExternalTaskFilter;
import io.openbpm.control.mapper.ExternalTaskMapper;
import io.openbpm.control.service.externaltask.ExternalTaskLoadContext;
import io.openbpm.control.service.externaltask.ExternalTaskService;
import io.openbpm.control.util.QueryUtils;
import java.util.List;
import lombok.Generated;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.query.Query;
import org.camunda.community.rest.client.api.ExternalTaskApiClient;
import org.camunda.community.rest.client.api.HistoryApiClient;
import org.camunda.community.rest.impl.RemoteExternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

@Service(value="control_ExternalTaskService")
public class ExternalTaskServiceImpl
implements ExternalTaskService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExternalTaskServiceImpl.class);
    protected final RemoteExternalTaskService remoteExternalTaskService;
    protected final HistoryApiClient historyApiClient;
    protected final ExternalTaskApiClient externalTaskApiClient;
    protected final ExternalTaskMapper externalTaskMapper;

    public ExternalTaskServiceImpl(RemoteExternalTaskService remoteExternalTaskService, HistoryApiClient historyApiClient, ExternalTaskApiClient externalTaskApiClient, ExternalTaskMapper externalTaskMapper) {
        this.remoteExternalTaskService = remoteExternalTaskService;
        this.historyApiClient = historyApiClient;
        this.externalTaskApiClient = externalTaskApiClient;
        this.externalTaskMapper = externalTaskMapper;
    }

    public List<ExternalTaskData> findRunningTasks(ExternalTaskLoadContext loadContext) {
        ExternalTaskQuery externalTaskQuery = this.remoteExternalTaskService.createExternalTaskQuery();
        this.addSort(loadContext.getSort(), externalTaskQuery);
        this.addFilters((ExternalTaskFilter)loadContext.getFilter(), externalTaskQuery);
        List externalTasks = loadContext.getFirstResult() != null && loadContext.getMaxResults() != null ? externalTaskQuery.listPage(loadContext.getFirstResult().intValue(), loadContext.getMaxResults().intValue()) : externalTaskQuery.list();
        return externalTasks.stream().map(arg_0 -> ((ExternalTaskMapper)this.externalTaskMapper).fromExternalTask(arg_0)).toList();
    }

    public long getRunningTasksCount(@Nullable ExternalTaskFilter filter) {
        ExternalTaskQuery externalTaskQuery = this.remoteExternalTaskService.createExternalTaskQuery();
        this.addFilters(filter, externalTaskQuery);
        return externalTaskQuery.count();
    }

    public void setRetries(String externalTaskId, int retries) {
        this.remoteExternalTaskService.setRetries(externalTaskId, retries);
        log.debug("Update retries count for external task {}. New value: {}", (Object)externalTaskId, (Object)retries);
    }

    public void setRetriesAsync(List<String> externalTaskIds, int retries) {
        this.remoteExternalTaskService.setRetriesAsync(externalTaskIds, null, retries);
        log.debug("Async update retries count for external tasks {}. New value: {}", externalTaskIds, (Object)retries);
    }

    public String getErrorDetails(String externalTaskId) {
        ResponseEntity response = this.externalTaskApiClient.getExternalTaskErrorDetails(externalTaskId);
        if (response.getStatusCode().is2xxSuccessful()) {
            return (String)response.getBody();
        }
        return "";
    }

    public String getHistoryErrorDetails(String externalTaskId) {
        ResponseEntity response = this.historyApiClient.getErrorDetailsHistoricExternalTaskLog(externalTaskId);
        if (response.getStatusCode().is2xxSuccessful()) {
            return Strings.nullToEmpty((String)((String)response.getBody()));
        }
        return "";
    }

    protected void addFilters(@Nullable ExternalTaskFilter filter, ExternalTaskQuery externalTaskQuery) {
        if (filter != null) {
            QueryUtils.addIfStringNotEmpty((String)filter.getProcessInstanceId(), arg_0 -> ((ExternalTaskQuery)externalTaskQuery).processInstanceId(arg_0));
            QueryUtils.addIfStringNotEmpty((String)filter.getActivityId(), arg_0 -> ((ExternalTaskQuery)externalTaskQuery).activityId(arg_0));
        }
    }

    protected void addSort(Sort sort, ExternalTaskQuery externalTaskQuery) {
        if (sort != null) {
            for (Sort.Order order : sort.getOrders()) {
                String property = order.getProperty();
                boolean unknownValueUsed = false;
                switch (property) {
                    case "priority": {
                        externalTaskQuery.orderByPriority();
                        break;
                    }
                    case "createTime": {
                        externalTaskQuery.orderByCreateTime();
                        break;
                    }
                    case "id": {
                        externalTaskQuery.orderById();
                        break;
                    }
                    default: {
                        unknownValueUsed = true;
                    }
                }
                QueryUtils.addSortDirection((Query)externalTaskQuery, (!unknownValueUsed ? 1 : 0) != 0, (Sort.Order)order);
            }
        }
    }
}

