/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.bulktaskcomplete;

import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.router.Route;
import io.jmix.core.Metadata;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.component.ListDataComponent;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.model.CollectionContainer;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.StandardView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Supply;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.openbpm.control.entity.UserTaskData;
import io.openbpm.control.entity.variable.ObjectTypeInfo;
import io.openbpm.control.entity.variable.VariableInstanceData;
import io.openbpm.control.entity.variable.VariableValueInfo;
import io.openbpm.control.service.usertask.UserTaskService;
import io.openbpm.control.view.main.MainView;
import io.openbpm.control.view.processvariable.VariableInstanceDataDetail;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="bulk-task-complete", layout=MainView.class)
@ViewController(value="BulkTaskCompleteView")
@ViewDescriptor(value="bulk-task-complete-view.xml")
@DialogMode(width="50em")
public class BulkTaskCompleteView
extends StandardView {
    @ViewComponent
    protected CollectionContainer<UserTaskData> userTasksDc;
    protected Collection<UserTaskData> userTasks;
    @Autowired
    protected DialogWindows dialogWindows;
    @ViewComponent
    protected DataGrid<VariableInstanceData> variableGrid;
    @Autowired
    protected Metadata metadata;
    @Autowired
    protected UserTaskService userTaskService;
    @ViewComponent
    protected CollectionContainer<VariableInstanceData> variableDc;
    @Autowired
    protected Notifications notifications;
    @ViewComponent
    protected MessageBundle messageBundle;

    public void setUserTasks(Collection<UserTaskData> userTasks) {
        this.userTasks = userTasks;
    }

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.addClassNames(new String[]{"pt-0", "pl-l", "pr-l", "pb-m"});
    }

    @Subscribe
    public void onBeforeShow(View.BeforeShowEvent event) {
        this.userTasksDc.setItems(this.userTasks);
    }

    @Supply(to="variableGrid.value", subject="renderer")
    protected Renderer<VariableInstanceData> variableValueRenderer() {
        return new TextRenderer((ItemLabelGenerator & Serializable)e -> e.getValue() != null ? e.getValue().toString() : null);
    }

    @Subscribe(value="completeTasksAction")
    public void onCompleteTasksAction(ActionPerformedEvent event) {
        this.userTasksDc.getItems().forEach(userTaskData -> this.userTaskService.completeTaskById(userTaskData.getTaskId(), (Collection)this.variableDc.getItems()));
        this.notifications.create(this.messageBundle.getMessage("userTasksCompleted")).withType(Notifications.Type.SUCCESS).show();
        this.close(StandardOutcome.SAVE);
    }

    @Subscribe(value="cancelAction")
    public void onCancelAction(ActionPerformedEvent event) {
        this.close(StandardOutcome.CLOSE);
    }

    @Subscribe(value="variableGrid.add")
    public void onVariableGridAdd(ActionPerformedEvent event) {
        this.dialogWindows.detail((ListDataComponent)this.variableGrid).withViewClass(VariableInstanceDataDetail.class).withViewConfigurer(view -> view.setNewVariable(true)).newEntity().withInitializer(variableInstanceData -> {
            VariableValueInfo variableValueInfo = (VariableValueInfo)this.metadata.create(VariableValueInfo.class);
            ObjectTypeInfo objectTypeInfo = (ObjectTypeInfo)this.metadata.create(ObjectTypeInfo.class);
            variableValueInfo.setObject(objectTypeInfo);
            variableInstanceData.setValueInfo(variableValueInfo);
        }).build().open();
    }

    @Subscribe(value="variableGrid.edit")
    public void onVariableGridEdit(ActionPerformedEvent event) {
        this.dialogWindows.detail((ListDataComponent)this.variableGrid).withViewClass(VariableInstanceDataDetail.class).withViewConfigurer(view -> view.setNewVariable(true)).editEntity((Object)Objects.requireNonNull((VariableInstanceData)this.variableGrid.getSingleSelectedItem())).build().open();
    }
}

