/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.dashboard;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H3;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.ViewComponent;
import io.openbpm.control.view.dashboard.DashboardCard;
import io.openbpm.control.view.processinstance.ProcessInstanceListView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FragmentDescriptor(value="process-instance-statistics-card-fragment.xml")
public class ProcessInstanceStatisticsCardFragment
extends DashboardCard<Div> {
    protected static final Logger log = LoggerFactory.getLogger(ProcessInstanceStatisticsCardFragment.class);
    @ViewComponent
    protected H3 runningProcessInstances;
    @ViewComponent
    protected H3 suspendedProcessInstances;

    protected void updateComponents(boolean loading) {
        if (loading) {
            this.runningProcessInstances.addClassNames(new String[]{"skeleton-background"});
            this.suspendedProcessInstances.addClassNames(new String[]{"skeleton-background"});
        } else {
            this.runningProcessInstances.removeClassName("skeleton-background");
            this.suspendedProcessInstances.removeClassName("skeleton-background");
        }
    }

    public void refresh(long runningCount, long suspendedCount) {
        this.updateComponents(false);
        this.runningProcessInstances.setText(this.formattedCount(runningCount));
        this.suspendedProcessInstances.setText(this.formattedCount(suspendedCount));
    }

    @Subscribe(id="viewInstancesBtn", subject="clickListener")
    public void onViewInstancesBtnClick(ClickEvent<JmixButton> event) {
        this.viewNavigators.view(UiComponentUtils.getCurrentView(), ProcessInstanceListView.class).navigate();
    }
}

