/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.historicactivityinstancedata;

import com.vaadin.flow.router.Route;
import io.jmix.core.LoadContext;
import io.jmix.flowui.component.formlayout.JmixFormLayout;
import io.jmix.flowui.component.textfield.TypedTextField;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.EditedEntityContainer;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardDetailView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.openbpm.control.entity.activity.HistoricActivityInstanceData;
import io.openbpm.control.service.activity.ActivityService;
import io.openbpm.control.view.main.MainView;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="historicActivityInstanceDatas/:id", layout=MainView.class)
@ViewController(value="HistoricActivityInstanceData.detail")
@ViewDescriptor(value="historic-activity-instance-data-detail-view.xml")
@EditedEntityContainer(value="historicActivityInstanceDataDc")
@DialogMode(minWidth="30em", maxWidth="60em", width="auto")
public class HistoricActivityInstanceDataDetailView
extends StandardDetailView<HistoricActivityInstanceData> {
    @ViewComponent
    protected MessageBundle messageBundle;
    @Autowired
    protected ActivityService activityService;
    @ViewComponent
    protected JmixFormLayout form;
    @ViewComponent
    protected TypedTextField<Object> durationField;

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.addClassNames(new String[]{"pt-xs"});
        this.form.getOwnComponents().forEach(component -> component.addClassNames(new String[]{"pt-s"}));
    }

    @Subscribe
    public void onBeforeShow(View.BeforeShowEvent event) {
        Long durationInMillis = ((HistoricActivityInstanceData)this.getEditedEntity()).getDurationInMillis();
        if (durationInMillis != null) {
            Duration duration = Duration.ofMillis(durationInMillis);
            this.durationField.setValue(this.messageBundle.formatMessage("formattedDuration", new Object[]{duration.toDaysPart(), duration.toHoursPart(), duration.toMinutesPart(), duration.toSecondsPart()}));
        }
    }

    @Install(to="historicActivityInstanceDataDl", target=Target.DATA_LOADER)
    protected HistoricActivityInstanceData historicActivityInstanceDataDlLoadDelegate(LoadContext<HistoricActivityInstanceData> loadContext) {
        Object id = loadContext.getId();
        if (id != null) {
            return this.activityService.findById(id.toString());
        }
        return null;
    }
}

