/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.incidentdata;

import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.router.Route;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.StandardView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.openbpm.control.entity.incident.IncidentData;
import io.openbpm.control.service.externaltask.ExternalTaskService;
import io.openbpm.control.service.job.JobService;
import io.openbpm.control.view.main.MainView;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="bulk-retry-incident-view", layout=MainView.class)
@ViewController(id="BulkRetryIncidentView")
@ViewDescriptor(path="bulk-retry-incident-view.xml")
public class BulkRetryIncidentView
extends StandardView {
    @Autowired
    private ExternalTaskService externalTaskService;
    @Autowired
    private JobService jobService;
    @Autowired
    private Notifications notifications;
    @ViewComponent
    private MessageBundle messageBundle;
    protected Set<IncidentData> incidentDataSet;

    public void setIncidentDataSet(Set<IncidentData> incidentDataSet) {
        this.incidentDataSet = incidentDataSet;
    }

    @Subscribe(value="retryAction")
    public void onRetryAction(ActionPerformedEvent event) {
        List jobIds;
        List externalTaskIds = this.getIncidentsByType(this.incidentDataSet, "failedExternalTask");
        if (CollectionUtils.isNotEmpty((Collection)externalTaskIds)) {
            this.externalTaskService.setRetriesAsync(externalTaskIds, 1);
        }
        if (CollectionUtils.isNotEmpty((Collection)(jobIds = this.getIncidentsByType(this.incidentDataSet, "failedJob")))) {
            this.jobService.setJobRetriesAsync(jobIds, 1);
        }
        this.notifications.create(this.messageBundle.getMessage("retriesBulkUpdateStarted")).withThemeVariant(NotificationVariant.LUMO_PRIMARY).show();
        this.close(StandardOutcome.SAVE);
    }

    @Subscribe(value="cancelAction")
    public void onCancelAction(ActionPerformedEvent event) {
        this.close(StandardOutcome.CLOSE);
    }

    protected List<String> getIncidentsByType(Set<IncidentData> selectedItems, String incidentType) {
        return selectedItems.stream().filter(incidentData -> incidentData.getType().equals(incidentType) && incidentData.getConfiguration() != null).map(IncidentData::getConfiguration).toList();
    }
}

