/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.incidentdata;

import com.vaadin.flow.router.Route;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.StandardView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.openbpm.control.service.job.JobService;
import io.openbpm.control.view.main.MainView;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="retry-job-view", layout=MainView.class)
@ViewController(id="RetryJobView")
@ViewDescriptor(path="retry-job-view.xml")
public class RetryJobView
extends StandardView {
    @Autowired
    private JobService jobService;
    @Autowired
    private Notifications notifications;
    @ViewComponent
    private MessageBundle messageBundle;
    protected String jobId;

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @Subscribe(value="retryAction")
    public void onRetryAction(ActionPerformedEvent event) {
        this.jobService.setJobRetries(this.jobId, 1);
        this.notifications.create(this.messageBundle.getMessage("jobRetriesUpdated")).withType(Notifications.Type.SUCCESS).show();
        this.close(StandardOutcome.SAVE);
    }

    @Subscribe(value="cancelAction")
    public void onCancelAction(ActionPerformedEvent event) {
        this.close(StandardOutcome.CLOSE);
    }
}

