/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.main;

import com.vaadin.flow.component.avatar.Avatar;
import com.vaadin.flow.component.combobox.ComboBoxVariant;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import io.jmix.core.security.UserRepository;
import io.jmix.core.usersubstitution.CurrentUserSubstitution;
import io.jmix.core.usersubstitution.event.UiUserSubstitutionsChangedEvent;
import io.jmix.flowui.component.combobox.JmixComboBox;
import io.jmix.flowui.component.main.JmixUserIndicator;
import io.jmix.flowui.fragment.Fragment;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.openbpm.control.entity.User;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

@FragmentDescriptor(value="user-indicator-fragment.xml")
public class UserIndicatorFragment
extends Fragment<HorizontalLayout> {
    private static final Logger log = LoggerFactory.getLogger(UserIndicatorFragment.class);
    @Autowired
    protected CurrentUserSubstitution currentUserSubstitution;
    @Autowired
    protected UserRepository userRepository;
    @ViewComponent
    protected Avatar userAvatar;
    @ViewComponent
    protected Span emailField;
    @ViewComponent
    protected JmixUserIndicator userIndicator;

    @Subscribe(target=Target.HOST_CONTROLLER)
    protected void onHostInit(View.InitEvent event) {
        this.updateUserInfo();
        this.updateUserIndicatorControl();
    }

    protected void updateUserInfo() {
        UserDetails userDetails = this.currentUserSubstitution.getEffectiveUser();
        try {
            userDetails = this.userRepository.loadUserByUsername(userDetails.getUsername());
        }
        catch (UsernameNotFoundException e) {
            log.error("User repository doesn't contain user with username {}", (Object)userDetails.getUsername());
        }
        if (userDetails instanceof User) {
            User user = (User)userDetails;
            String abbreviation = this.getUserAbbreviation(user);
            this.userAvatar.setAbbreviation(abbreviation.toUpperCase());
            this.emailField.setText(user.getEmail());
        }
    }

    @EventListener
    public void onUserSubstitutionsChanged(UiUserSubstitutionsChangedEvent event) {
        UserDetails authenticatedUser = this.currentUserSubstitution.getAuthenticatedUser();
        if (Objects.equals(authenticatedUser.getUsername(), event.getSource())) {
            this.updateUserInfo();
            this.updateUserIndicatorControl();
        }
    }

    protected void updateUserIndicatorControl() {
        ((Div)this.userIndicator.getContent()).getChildren().findFirst().ifPresent(component -> {
            if (component instanceof JmixComboBox) {
                JmixComboBox comboBox = (JmixComboBox)component;
                comboBox.addThemeVariants((ThemeVariant[])new ComboBoxVariant[]{ComboBoxVariant.LUMO_SMALL});
            }
        });
    }

    protected String getUserAbbreviation(User user) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{user.getFirstName(), user.getLastName()})) {
            return user.getFirstName().substring(0, 1) + user.getLastName().substring(0, 1);
        }
        return user.getUsername().substring(0, 1);
    }
}

