/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.processdefinition;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.router.Route;
import io.jmix.core.Messages;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.component.checkbox.JmixCheckbox;
import io.jmix.flowui.view.DefaultMainViewParent;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.openbpm.control.entity.processdefinition.ProcessDefinitionData;
import io.openbpm.control.service.processdefinition.ProcessDefinitionService;
import io.openbpm.control.view.processdefinition.ProcessDefinitionBulkOperationView;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="bpm/bulkactivateprocessdefinition", layout=DefaultMainViewParent.class)
@ViewController(value="bpm_BulkActivateProcessDefinition")
@ViewDescriptor(value="bulk-activate-process-definition-view.xml")
@DialogMode(width="35em")
public class BulkActivateProcessDefinitionView
extends ProcessDefinitionBulkOperationView {
    @Autowired
    protected Notifications notifications;
    @Autowired
    protected Messages messages;
    @Autowired
    protected ProcessDefinitionService processDefinitionService;
    @ViewComponent
    protected JmixCheckbox activateAllVersionsCheckBox;
    @ViewComponent
    protected Checkbox activateProcessInstancesCheckBox;

    @Subscribe
    protected void onBeforeShow(View.BeforeShowEvent event) {
        this.activateProcessInstancesCheckBox.setValue((Object)true);
    }

    @Subscribe(value="activateBtn")
    protected void onActivateBtnClick(ClickEvent<Button> event) {
        if (BooleanUtils.isTrue((Boolean)((Boolean)this.activateAllVersionsCheckBox.getValue()))) {
            Set processDefinitionKeys = this.collectProcessDefinitionKeys();
            for (String key : processDefinitionKeys) {
                this.processDefinitionService.activateAllVersionsByKey(key, Boolean.TRUE.equals(this.activateProcessInstancesCheckBox.getValue()));
            }
        } else {
            for (ProcessDefinitionData processDefinition : this.processDefinitions) {
                this.processDefinitionService.activateById(processDefinition.getId(), Boolean.TRUE.equals(this.activateProcessInstancesCheckBox.getValue()));
            }
        }
        this.notifications.create(this.messages.getMessage(this.getClass(), "bulkActivationSuccessNotification.headed")).withType(Notifications.Type.SUCCESS).build().open();
        this.close(StandardOutcome.SAVE);
    }

    @Subscribe(value="cancelBtn")
    protected void onCancelBtnClick(ClickEvent<Button> event) {
        this.close(StandardOutcome.DISCARD);
    }
}

