/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.processdefinition;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.router.Route;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.component.checkbox.JmixCheckbox;
import io.jmix.flowui.view.DefaultMainViewParent;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.StandardView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.openbpm.control.exception.RemoteProcessEngineException;
import io.openbpm.control.service.processdefinition.ProcessDefinitionService;
import io.openbpm.control.service.processinstance.ProcessInstanceService;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="bpm/deleteprocessdefinition", layout=DefaultMainViewParent.class)
@ViewController(value="bpm_DeleteProcessDefinition")
@ViewDescriptor(value="delete-process-definition-view.xml")
@DialogMode(width="35em")
public class DeleteProcessDefinitionView
extends StandardView {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeleteProcessDefinitionView.class);
    @Autowired
    protected Notifications notifications;
    @Autowired
    protected ProcessDefinitionService processDefinitionService;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @ViewComponent
    protected Icon allInstancesContextHelp;
    @ViewComponent
    protected JmixCheckbox deleteProcessInstancesCheckBox;
    protected String processDefinitionId;
    @ViewComponent
    private MessageBundle messageBundle;

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.addClassNames(new String[]{"pt-0", "pl-l"});
        this.allInstancesContextHelp.addClassNames(new String[]{"text-secondary"});
    }

    @Subscribe
    protected void onBeforeShow(View.BeforeShowEvent event) {
        this.deleteProcessInstancesCheckBox.setValue(Boolean.valueOf(true));
        long countByProcessDefinitionId = this.processInstanceService.getCountByProcessDefinitionId(this.processDefinitionId);
        if (countByProcessDefinitionId > 0L) {
            this.allInstancesContextHelp.setTooltipText(this.messageBundle.getMessage("deleteAllRunningInstances.tooltip"));
        }
        this.deleteProcessInstancesCheckBox.setEnabled(countByProcessDefinitionId == 0L);
    }

    @Subscribe(value="okBtn")
    protected void onActivateBtnClick(ClickEvent<Button> event) {
        boolean deleteAllRelatedInstances = BooleanUtils.isTrue((Boolean)((Boolean)this.deleteProcessInstancesCheckBox.getValue()));
        try {
            this.processDefinitionService.deleteById(this.processDefinitionId, deleteAllRelatedInstances);
        }
        catch (Exception e) {
            if (e instanceof RemoteProcessEngineException) {
                RemoteProcessEngineException engineException = (RemoteProcessEngineException)e;
                log.error("Unable to delete process definition version", (Throwable)e);
                String responseMessage = engineException.getResponseMessage();
                String errorReason = StringUtils.isNotBlank((CharSequence)responseMessage) ? responseMessage.replaceAll("\\.", ".\n") : e.getMessage();
                this.notifications.create(errorReason).withType(Notifications.Type.ERROR).withDuration(10000).show();
                return;
            }
            throw e;
        }
        this.close(StandardOutcome.SAVE);
    }

    @Subscribe(value="cancelBtn")
    protected void onCancelBtnClick(ClickEvent<Button> event) {
        this.close(StandardOutcome.DISCARD);
    }
}

