/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.processdefinition;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.router.Route;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.StandardView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.openbpm.control.entity.processdefinition.ProcessDefinitionData;
import io.openbpm.control.service.processdefinition.ProcessDefinitionService;
import io.openbpm.control.uicomponent.viewer.handler.CallActivityOverlayClickHandler;
import io.openbpm.control.view.main.MainView;
import io.openbpm.uikit.fragment.bpmnviewer.BpmnViewerFragment;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="process-definition-diagram", layout=MainView.class)
@ViewController(value="ProcessDefinitionDiagramView")
@ViewDescriptor(value="process-definition-diagram-view.xml")
@DialogMode(width="90%", height="90%", minWidth="40em", minHeight="25em")
public class ProcessDefinitionDiagramView
extends StandardView {
    protected ProcessDefinitionData processDefinition;
    @Autowired
    protected ProcessDefinitionService processDefinitionService;
    @ViewComponent
    protected BpmnViewerFragment viewerFragment;
    @ViewComponent
    protected InstanceContainer<ProcessDefinitionData> processDefinitionDc;
    @Autowired
    protected CallActivityOverlayClickHandler callActivityClickHandler;

    public void setProcessDefinition(ProcessDefinitionData processDefinitionId) {
        this.processDefinition = processDefinitionId;
    }

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.addClassNames(new String[]{"pt-xs", "pl-l", "pr-l"});
    }

    @Subscribe
    public void onBeforeShow(View.BeforeShowEvent event) {
        this.processDefinitionDc.setItem((Object)this.processDefinition);
        String bpmnXml = this.processDefinitionService.getBpmnXml(this.processDefinition.getProcessDefinitionId());
        this.viewerFragment.initViewer(bpmnXml);
        this.viewerFragment.showCalledProcessOverlays();
        this.viewerFragment.addCalledProcessOverlayClickListener((ComponentEventListener & Serializable)callActivityOverlayClickEvent -> this.callActivityClickHandler.handleProcessNavigation((ProcessDefinitionData)this.processDefinitionDc.getItem(), callActivityOverlayClickEvent.getCallActivity(), UiComponentUtils.isComponentAttachedToDialog((Component)this)));
    }
}

