/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.processinstance;

import com.google.common.base.Strings;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.html.H5;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteParameters;
import io.jmix.core.LoadContext;
import io.jmix.core.Messages;
import io.jmix.core.Metadata;
import io.jmix.flowui.Fragments;
import io.jmix.flowui.UiComponents;
import io.jmix.flowui.UiEventPublisher;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.component.tabsheet.JmixTabSheet;
import io.jmix.flowui.fragment.FragmentOwner;
import io.jmix.flowui.model.CollectionContainer;
import io.jmix.flowui.model.CollectionLoader;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.model.InstanceLoader;
import io.jmix.flowui.view.DefaultMainViewParent;
import io.jmix.flowui.view.EditedEntityContainer;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardDetailView;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.openbpm.control.entity.activity.ActivityInstanceTreeItem;
import io.openbpm.control.entity.activity.ActivityShortData;
import io.openbpm.control.entity.decisioninstance.HistoricDecisionInstanceShortData;
import io.openbpm.control.entity.filter.DecisionInstanceFilter;
import io.openbpm.control.entity.processinstance.ProcessInstanceData;
import io.openbpm.control.entity.processinstance.ProcessInstanceState;
import io.openbpm.control.service.activity.ActivityService;
import io.openbpm.control.service.decisioninstance.DecisionInstanceLoadContext;
import io.openbpm.control.service.decisioninstance.DecisionInstanceService;
import io.openbpm.control.service.incident.IncidentService;
import io.openbpm.control.service.processdefinition.ProcessDefinitionService;
import io.openbpm.control.service.processinstance.ProcessInstanceService;
import io.openbpm.control.uicomponent.viewer.handler.CallActivityOverlayClickHandler;
import io.openbpm.control.view.decisioninstance.DecisionInstanceDetailView;
import io.openbpm.control.view.event.TitleUpdateEvent;
import io.openbpm.control.view.processinstance.LazyTabContent;
import io.openbpm.control.view.processinstance.event.ExternalTaskRetriesUpdateEvent;
import io.openbpm.control.view.processinstance.event.IncidentUpdateEvent;
import io.openbpm.control.view.processinstance.event.JobRetriesUpdateEvent;
import io.openbpm.control.view.processinstance.history.HistoryTabFragment;
import io.openbpm.control.view.util.ComponentHelper;
import io.openbpm.uikit.component.bpmnviewer.command.AddMarkerCmd;
import io.openbpm.uikit.component.bpmnviewer.command.ElementMarkerType;
import io.openbpm.uikit.component.bpmnviewer.command.SetElementColorCmd;
import io.openbpm.uikit.component.bpmnviewer.command.SetIncidentCountCmd;
import io.openbpm.uikit.component.bpmnviewer.command.ShowCalledInstanceOverlayCmd;
import io.openbpm.uikit.component.bpmnviewer.command.ShowDecisionInstanceLinkOverlayCmd;
import io.openbpm.uikit.fragment.bpmnviewer.BpmnViewerFragment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.EventListener;
import org.springframework.lang.Nullable;

@Route(value="bpm/process-instances/:id", layout=DefaultMainViewParent.class)
@ViewController(value="bpm_ProcessInstanceData.detail")
@ViewDescriptor(value="process-instance-detail-view.xml")
@EditedEntityContainer(value="processInstanceDataDc")
public class ProcessInstanceDetailView
extends StandardDetailView<ProcessInstanceData> {
    public static final String HISTORY_TAB_ID = "historyTab";
    public static final int RUNTIME_TAB_IDX = 0;
    public static final int HISTORY_TAB_IDX = 1;
    @Autowired
    protected UiComponents uiComponents;
    @Autowired
    protected UiEventPublisher uiEventPublisher;
    @Autowired
    protected Fragments fragments;
    @Autowired
    protected ViewNavigators viewNavigators;
    @Autowired
    protected ProcessDefinitionService processDefinitionService;
    @Autowired
    protected ProcessInstanceService processInstanceService;
    @Autowired
    protected ActivityService activityService;
    @Autowired
    protected ComponentHelper componentHelper;
    @Autowired
    protected CallActivityOverlayClickHandler callActivityClickHandler;
    @Autowired
    protected Messages messages;
    @Autowired
    protected IncidentService incidentService;
    @Autowired
    protected DecisionInstanceService decisionInstanceService;
    @Autowired
    protected Metadata metadata;
    @ViewComponent
    protected JmixTabSheet relatedEntitiesTabSheet;
    @ViewComponent
    protected InstanceContainer<ProcessInstanceData> processInstanceDataDc;
    @ViewComponent
    protected CollectionContainer<ActivityInstanceTreeItem> runtimeActivityInstancesDc;
    @ViewComponent
    protected InstanceLoader<ProcessInstanceData> processInstanceDataDl;
    @ViewComponent
    protected CollectionLoader<ActivityInstanceTreeItem> runtimeActivityInstancesDl;
    @ViewComponent
    protected BpmnViewerFragment diagramFragment;
    @ViewComponent
    protected VerticalLayout emptyDiagramBox;
    @ViewComponent
    protected MessageBundle messageBundle;
    protected String title = "";

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.relatedEntitiesTabSheet.getTabAt(0).addComponentAsFirst((Component)VaadinIcon.FILE_TREE_SMALL.create());
        Tab historyTab = (Tab)this.uiComponents.create(Tab.class);
        historyTab.setId(HISTORY_TAB_ID);
        historyTab.setLabel(this.messageBundle.getMessage("historyTabCaption"));
        historyTab.addComponentAsFirst((Component)VaadinIcon.TIME_BACKWARD.create());
        this.relatedEntitiesTabSheet.add(historyTab, (Component)new LazyTabContent((SerializableSupplier & Serializable)() -> this.fragments.create((FragmentOwner)this, HistoryTabFragment.class)), 1);
    }

    @Subscribe
    public void onBeforeShow(View.BeforeShowEvent event) {
        this.processInstanceDataDl.load();
        ProcessInstanceData processInstanceData = (ProcessInstanceData)this.processInstanceDataDc.getItem();
        ProcessInstanceState state = processInstanceData.getState();
        if (state != ProcessInstanceState.COMPLETED) {
            this.runtimeActivityInstancesDl.load();
        }
        if (processInstanceData.getEndTime() != null) {
            this.relatedEntitiesTabSheet.getTabAt(0).setEnabled(false);
            Tab historyTab = this.relatedEntitiesTabSheet.getTabAt(1);
            this.relatedEntitiesTabSheet.setSelectedTab(historyTab);
            LazyTabContent contentByTab = (LazyTabContent)this.relatedEntitiesTabSheet.getContentByTab(historyTab);
            if (contentByTab != null) {
                contentByTab.init();
                Component tabContent = contentByTab.getChildren().findFirst().orElse(null);
                if (tabContent instanceof HistoryTabFragment) {
                    HistoryTabFragment historyTabFragment = (HistoryTabFragment)tabContent;
                    historyTabFragment.refresh();
                }
            }
        }
        this.initBpmnViewerFragment();
    }

    @Subscribe
    public void onReady(View.ReadyEvent event) {
        this.sendUpdateViewTitleEvent();
    }

    @Subscribe(value="relatedEntitiesTabSheet")
    public void onRelatedEntitiesTabSheetSelectedChange(JmixTabSheet.SelectedChangeEvent event) {
        Component tabContent;
        String selectedTabId;
        Tab selectedTab = event.getSelectedTab();
        String string = selectedTabId = selectedTab != null ? (String)selectedTab.getId().orElse(null) : null;
        if (StringUtils.equals((CharSequence)selectedTabId, (CharSequence)HISTORY_TAB_ID) && (tabContent = this.getTabContent(selectedTab)) instanceof HistoryTabFragment) {
            HistoryTabFragment historyTabFragment = (HistoryTabFragment)tabContent;
            historyTabFragment.refresh();
        }
    }

    @EventListener
    public void handleIncidentUpdate(IncidentUpdateEvent event) {
        this.initBpmnViewerFragment();
    }

    @EventListener
    public void handleJobRetriesUpdate(JobRetriesUpdateEvent event) {
        this.initBpmnViewerFragment();
    }

    @EventListener
    public void handleExternalRetriesUpdate(ExternalTaskRetriesUpdateEvent event) {
        this.initBpmnViewerFragment();
    }

    public void reopenView() {
        String instanceId = ((ProcessInstanceData)this.processInstanceDataDc.getItem()).getInstanceId();
        this.close(StandardOutcome.DISCARD).then(() -> this.viewNavigators.view((View)this, ProcessInstanceDetailView.class).withRouteParameters(new RouteParameters("id", instanceId)).withBackwardNavigation(false).navigate());
    }

    public String getPageTitle() {
        return this.title;
    }

    @Install(to="processInstanceDataDl", target=Target.DATA_LOADER)
    protected ProcessInstanceData processInstanceDataDlLoadDelegate(LoadContext<ProcessInstanceData> loadContext) {
        return this.processInstanceService.getProcessInstanceById(Objects.requireNonNull(loadContext.getId()).toString());
    }

    @Install(to="runtimeActivityInstancesDl", target=Target.DATA_LOADER)
    protected List<ActivityInstanceTreeItem> runtimeActivityInstancesDlLoadDelegate(LoadContext<ActivityInstanceTreeItem> loadContext) {
        return this.activityService.getActivityInstancesTree(((ProcessInstanceData)this.processInstanceDataDc.getItem()).getInstanceId());
    }

    protected void initBpmnViewerFragment() {
        String processBpmnXml = this.processDefinitionService.getBpmnXml(((ProcessInstanceData)this.processInstanceDataDc.getItem()).getProcessDefinitionId());
        if (!Strings.isNullOrEmpty((String)processBpmnXml)) {
            this.emptyDiagramBox.setVisible(false);
            this.diagramFragment.initViewer(processBpmnXml);
            this.diagramFragment.addImportCompleteListener((ComponentEventListener & Serializable)event -> this.handleProcessXmlImportComplete());
            this.diagramFragment.addDecisionInstanceLinkOverlayClickListener((ComponentEventListener & Serializable)event -> this.handleDecisionInstanceLinkOverlayClicked(event.getDecisionInstanceId()));
            this.diagramFragment.addCalledProcessInstanceOverlayClickListener((ComponentEventListener & Serializable)event -> this.callActivityClickHandler.handleInstancesNavigation(event.getProcessInstanceIds()));
        } else if (processBpmnXml == null) {
            this.emptyDiagramBox.setVisible(true);
            this.diagramFragment.setVisible(false);
        }
    }

    protected void handleProcessXmlImportComplete() {
        ProcessInstanceData processInstanceData = (ProcessInstanceData)this.processInstanceDataDc.getItem();
        String processInstanceId = processInstanceData.getInstanceId();
        this.showRunningActivities(processInstanceId);
        this.showFinishedActivities(processInstanceId);
        if (processInstanceData.getState() != ProcessInstanceState.COMPLETED) {
            List incidents = this.incidentService.findRuntimeIncidents(processInstanceId);
            this.diagramFragment.setIncidentCount(new SetIncidentCountCmd(incidents));
        }
    }

    protected void showFinishedActivities(String processInstanceId) {
        List finishedActivities = this.activityService.findFinishedActivities(processInstanceId);
        HashMap calledInstancesByActivityId = new HashMap();
        for (ActivityShortData activityData : finishedActivities) {
            String activityId = activityData.getActivityId();
            if (!Strings.isNullOrEmpty((String)activityId)) {
                this.diagramFragment.setElementColor(new SetElementColorCmd(activityId, "#000000", "var(--bpmn-history-activity-color)"));
            }
            String decisionInstanceId = this.findDecisionInstanceByActivity(activityId);
            if (!Strings.isNullOrEmpty((String)activityId)) {
                String tooltipMessage = this.messages.formatMessage("", "viewer.openDecisionInstanceOverlay.tooltipMessage", new Object[]{decisionInstanceId});
                this.diagramFragment.showDecisionInstanceLinkOverlay(new ShowDecisionInstanceLinkOverlayCmd(activityId, decisionInstanceId, tooltipMessage));
            }
            this.addCalledInstance(activityData, calledInstancesByActivityId);
        }
        this.showCalledInstanceOverlays(calledInstancesByActivityId);
    }

    protected void showRunningActivities(String processInstanceId) {
        Set<String> runtimeActivityIds = this.runtimeActivityInstancesDc.getItems().stream().filter(treeItem -> treeItem.getParentActivityInstance() != null).map(ActivityInstanceTreeItem::getActivityId).collect(Collectors.toSet());
        runtimeActivityIds.forEach(activityId -> {
            if (!Strings.isNullOrEmpty((String)activityId)) {
                this.diagramFragment.addMarker(new AddMarkerCmd(activityId, ElementMarkerType.RUNNING_ACTIVITY));
            }
        });
        List runningHistoricActivities = this.activityService.findRunningActivities(processInstanceId);
        HashMap calledInstances = new HashMap();
        for (ActivityShortData activityData : runningHistoricActivities) {
            this.addCalledInstance(activityData, calledInstances);
        }
        this.showCalledInstanceOverlays(calledInstances);
    }

    protected void addCalledInstance(ActivityShortData activityData, Map<String, List<String>> calledInstancesByActivityId) {
        if (StringUtils.isNotEmpty((CharSequence)activityData.getCalledProcessInstanceId())) {
            List activityCalledInstances = calledInstancesByActivityId.getOrDefault(activityData.getActivityId(), new ArrayList());
            activityCalledInstances.add(activityData.getCalledProcessInstanceId());
            calledInstancesByActivityId.put(activityData.getActivityId(), activityCalledInstances);
        }
    }

    protected void showCalledInstanceOverlays(Map<String, List<String>> calledInstances) {
        calledInstances.forEach((activityId, calledInstanceIds) -> {
            ShowCalledInstanceOverlayCmd showCalledInstanceOverlayCmd = new ShowCalledInstanceOverlayCmd();
            showCalledInstanceOverlayCmd.setElementId(activityId);
            showCalledInstanceOverlayCmd.setProcessInstanceIds(calledInstanceIds);
            this.diagramFragment.showCalledInstance(showCalledInstanceOverlayCmd);
        });
    }

    protected void sendUpdateViewTitleEvent() {
        this.title = this.messageBundle.formatMessage("processInstanceDetailView.title", new Object[]{((ProcessInstanceData)this.getEditedEntity()).getInstanceId()});
        String titleText = this.messageBundle.getMessage("processInstanceDetailView.baseTitle");
        FlexLayout titleLayout = this.createTitleLayout();
        this.uiEventPublisher.publishEventForCurrentUI((ApplicationEvent)new TitleUpdateEvent((Object)this, titleText, (Component)titleLayout));
    }

    protected FlexLayout createTitleLayout() {
        FlexLayout flexLayout = (FlexLayout)this.uiComponents.create(FlexLayout.class);
        flexLayout.addClassNames(new String[]{"ml-xs", "gap-s"});
        flexLayout.setAlignItems(FlexComponent.Alignment.CENTER);
        H5 instanceId = this.createInstanceIdComponent();
        Span processDefinitionBadge = this.createProcessBadge();
        Span stateBadge = this.componentHelper.createProcessInstanceStateBadge(((ProcessInstanceData)this.getEditedEntity()).getState());
        flexLayout.add(new Component[]{instanceId, stateBadge, processDefinitionBadge});
        return flexLayout;
    }

    protected H5 createInstanceIdComponent() {
        H5 instanceId = new H5("\"%s\"".formatted(((ProcessInstanceData)this.getEditedEntity()).getInstanceId()));
        instanceId.setHeightFull();
        instanceId.addClassNames(new String[]{"text-body"});
        return instanceId;
    }

    protected Span createProcessBadge() {
        Span processDefinitionBadge = (Span)this.uiComponents.create(Span.class);
        processDefinitionBadge.getElement().getThemeList().add((Object)"badge normal pill");
        Integer processVersion = ((ProcessInstanceData)this.getEditedEntity()).getProcessDefinitionVersion();
        String processKey = ((ProcessInstanceData)this.getEditedEntity()).getProcessDefinitionKey();
        String processBadgeText = processVersion == null ? processKey : this.messages.formatMessage("", "common.processDefinitionKeyAndVersion", new Object[]{processKey, processVersion});
        processDefinitionBadge.setText(processBadgeText);
        return processDefinitionBadge;
    }

    @Nullable
    protected Component getTabContent(Tab tab) {
        Component contentByTab = this.relatedEntitiesTabSheet.getContentByTab(tab);
        return contentByTab != null ? (Component)contentByTab.getChildren().findFirst().orElse(null) : null;
    }

    private void handleDecisionInstanceLinkOverlayClicked(String decisionInstanceId) {
        if (!Strings.isNullOrEmpty((String)decisionInstanceId)) {
            this.viewNavigators.detailView((View)this, HistoricDecisionInstanceShortData.class).withViewClass(DecisionInstanceDetailView.class).withRouteParameters(new RouteParameters("id", decisionInstanceId)).withBackwardNavigation(true).navigate();
        }
    }

    private String findDecisionInstanceByActivity(String activityId) {
        DecisionInstanceLoadContext loadContext = new DecisionInstanceLoadContext();
        DecisionInstanceFilter filter = (DecisionInstanceFilter)this.metadata.create(DecisionInstanceFilter.class);
        loadContext.setFilter(filter);
        filter.setActivityId(activityId);
        filter.setProcessInstanceId(((ProcessInstanceData)this.processInstanceDataDc.getItem()).getInstanceId());
        List allHistoryDecisionInstances = this.decisionInstanceService.findAllHistoryDecisionInstances(loadContext);
        if (CollectionUtils.isNotEmpty((Collection)allHistoryDecisionInstances)) {
            return ((HistoricDecisionInstanceShortData)allHistoryDecisionInstances.get(0)).getDecisionInstanceId();
        }
        return null;
    }
}

