/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.processinstance.column.state;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.fragmentrenderer.FragmentRenderer;
import io.jmix.flowui.fragmentrenderer.RendererItemContainer;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.ViewComponent;
import io.openbpm.control.entity.processinstance.ProcessInstanceData;
import io.openbpm.control.entity.processinstance.ProcessInstanceState;
import io.openbpm.control.entity.processinstance.RuntimeProcessInstanceData;
import io.openbpm.control.view.processinstance.terminatereason.InstanceTerminateReasonView;
import io.openbpm.control.view.util.ComponentHelper;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@FragmentDescriptor(value="process-instance-state-column-fragment.xml")
@RendererItemContainer(value="processInstanceDataDc")
public class ProcessInstanceStateColumnFragment
extends FragmentRenderer<HorizontalLayout, RuntimeProcessInstanceData> {
    @Autowired
    protected ComponentHelper componentHelper;
    @Autowired
    protected DialogWindows dialogWindows;
    @ViewComponent
    protected Icon incidentIcon;
    @ViewComponent
    protected JmixButton viewTerminateReasonBtn;

    public void setItem(RuntimeProcessInstanceData item) {
        super.setItem((Object)item);
        Span processInstanceStateBadge = this.componentHelper.createProcessInstanceStateBadge(item.getState());
        ((HorizontalLayout)this.getContent()).addComponentAsFirst((Component)processInstanceStateBadge);
        this.incidentIcon.setVisible(BooleanUtils.isTrue((Boolean)item.getHasIncidents()));
        if (item instanceof ProcessInstanceData) {
            ProcessInstanceData processInstanceData = (ProcessInstanceData)item;
            this.updateComponentsVisibility(processInstanceData);
        }
    }

    @Subscribe(id="viewTerminateReasonBtn", subject="clickListener")
    public void onViewTerminateReasonBtnClick(ClickEvent<JmixButton> event) {
        this.dialogWindows.view(UiComponentUtils.getCurrentView(), InstanceTerminateReasonView.class).withViewConfigurer(instanceTerminateReasonView -> instanceTerminateReasonView.setProcessInstance((ProcessInstanceData)this.item)).open();
    }

    protected void updateComponentsVisibility(ProcessInstanceData processInstanceData) {
        ProcessInstanceState state = processInstanceData.getState();
        boolean externallyCompleted = state == ProcessInstanceState.COMPLETED && BooleanUtils.isTrue((Boolean)processInstanceData.getExternallyTerminated());
        this.viewTerminateReasonBtn.setVisible(externallyCompleted);
    }
}

