/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.processinstance.filter;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import io.jmix.flowui.component.checkbox.JmixCheckbox;
import io.jmix.flowui.component.combobox.JmixComboBox;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.component.grid.DataGridColumn;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.model.InstanceContainer;
import io.openbpm.control.entity.filter.ProcessInstanceFilter;
import io.openbpm.control.entity.processinstance.ProcessInstanceData;
import io.openbpm.control.entity.processinstance.ProcessInstanceState;
import io.openbpm.control.view.processinstance.ProcessInstanceViewMode;
import io.openbpm.control.view.processinstance.filter.ProcessInstanceDataGridHeaderFilter;
import io.openbpm.control.view.processinstance.filter.ProcessInstanceStateHeaderFilter;
import io.openbpm.control.view.util.ComponentHelper;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ProcessInstanceStateHeaderFilter
extends ProcessInstanceDataGridHeaderFilter {
    private JmixComboBox<ProcessInstanceState> stateComboBox;
    private JmixCheckbox withIncidentsCheckBox;
    private ComponentHelper componentHelper;
    private ProcessInstanceViewMode viewMode = ProcessInstanceViewMode.ACTIVE;

    public ProcessInstanceStateHeaderFilter(DataGrid<ProcessInstanceData> dataGrid, DataGridColumn<ProcessInstanceData> column, InstanceContainer<ProcessInstanceFilter> filterDc) {
        super(dataGrid, column, filterDc);
    }

    @Autowired
    public void setComponentHelper(ComponentHelper componentHelper) {
        this.componentHelper = componentHelper;
    }

    protected Component createFilterComponent() {
        VerticalLayout verticalLayout = (VerticalLayout)this.uiComponents.create(VerticalLayout.class);
        verticalLayout.setPadding(false);
        this.stateComboBox = (JmixComboBox)this.uiComponents.create(JmixComboBox.class);
        this.stateComboBox.setItems(List.of(ProcessInstanceState.ACTIVE, ProcessInstanceState.SUSPENDED));
        this.stateComboBox.setRenderer((Renderer)new ComponentRenderer(arg_0 -> ((ComponentHelper)this.componentHelper).createProcessInstanceStateBadge(arg_0)));
        this.stateComboBox.setLabel(this.messages.getMessage(this.getClass(), "stateLabel"));
        this.stateComboBox.setClearButtonVisible(true);
        this.stateComboBox.setMinWidth("10em");
        this.stateComboBox.setPlaceholder(this.messages.getMessage(this.getClass(), "selectState"));
        this.withIncidentsCheckBox = (JmixCheckbox)this.uiComponents.create(JmixCheckbox.class);
        this.withIncidentsCheckBox.setLabel(this.messages.getMessage(ProcessInstanceFilter.class, "ProcessInstanceFilter.withIncidents"));
        verticalLayout.add(new Component[]{this.stateComboBox, this.withIncidentsCheckBox});
        return verticalLayout;
    }

    protected void onClearButtonClick(ClickEvent<Button> event) {
        this.resetFilterValues();
    }

    protected void resetFilterValues() {
        this.stateComboBox.setValue(null);
        this.withIncidentsCheckBox.setValue(Boolean.valueOf(false));
    }

    protected JmixButton createResetButton() {
        JmixButton resetButton = super.createResetButton();
        resetButton.addClassNames(new String[]{"mr-xl"});
        return resetButton;
    }

    protected JmixButton createApplyButton() {
        JmixButton applyButton = super.createApplyButton();
        applyButton.addClassNames(new String[]{"ml-xl"});
        return applyButton;
    }

    public void apply() {
        Boolean withIncidents;
        ProcessInstanceState state = (ProcessInstanceState)this.stateComboBox.getValue();
        if (this.viewMode == ProcessInstanceViewMode.ALL || this.viewMode == ProcessInstanceViewMode.ACTIVE) {
            ((ProcessInstanceFilter)this.filterDc.getItem()).setState(state);
        }
        if (BooleanUtils.isTrue((Boolean)(withIncidents = (Boolean)this.withIncidentsCheckBox.getValue()))) {
            ((ProcessInstanceFilter)this.filterDc.getItem()).setWithIncidents(withIncidents);
        } else {
            ((ProcessInstanceFilter)this.filterDc.getItem()).setWithIncidents(null);
        }
        this.filterButton.getElement().setAttribute("activated", state != null || BooleanUtils.isTrue((Boolean)withIncidents));
    }

    public void update(ProcessInstanceViewMode newViewMode) {
        this.viewMode = newViewMode;
        this.stateComboBox.setValue(null);
        switch (1.$SwitchMap$io$openbpm$control$view$processinstance$ProcessInstanceViewMode[newViewMode.ordinal()]) {
            case 1: {
                this.stateComboBox.setEnabled(true);
                this.stateComboBox.setItems(ProcessInstanceState.class);
                break;
            }
            case 2: {
                this.stateComboBox.setEnabled(false);
                break;
            }
            case 3: {
                this.stateComboBox.setEnabled(true);
                this.stateComboBox.setItems(List.of(ProcessInstanceState.ACTIVE, ProcessInstanceState.SUSPENDED));
            }
        }
    }
}

