/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.processinstance.runtime;

import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import io.jmix.core.DataLoadContext;
import io.jmix.core.LoadContext;
import io.jmix.core.Messages;
import io.jmix.core.Metadata;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.Dialogs;
import io.jmix.flowui.UiEventPublisher;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.fragment.Fragment;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.model.CollectionContainer;
import io.jmix.flowui.model.CollectionLoader;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.DialogWindow;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.ViewComponent;
import io.openbpm.control.entity.ExternalTaskData;
import io.openbpm.control.entity.filter.ExternalTaskFilter;
import io.openbpm.control.entity.processinstance.ProcessInstanceData;
import io.openbpm.control.service.externaltask.ExternalTaskLoadContext;
import io.openbpm.control.service.externaltask.ExternalTaskService;
import io.openbpm.control.view.incidentdata.RetryExternalTaskView;
import io.openbpm.control.view.processinstance.event.ExternalTaskCountUpdateEvent;
import io.openbpm.control.view.processinstance.event.ExternalTaskRetriesUpdateEvent;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;

@FragmentDescriptor(value="external-tasks-tab-fragment.xml")
public class ExternalTasksTabFragment
extends Fragment<VerticalLayout> {
    @Autowired
    protected ExternalTaskService externalTaskService;
    @Autowired
    protected Metadata metadata;
    @Autowired
    protected UiEventPublisher uiEventPublisher;
    @Autowired
    protected DialogWindows dialogWindows;
    @Autowired
    protected ViewNavigators viewNavigators;
    @Autowired
    protected Dialogs dialogs;
    @ViewComponent
    protected MessageBundle messageBundle;
    @Autowired
    protected Messages messages;
    @ViewComponent
    protected CollectionLoader<ExternalTaskData> runtimeExternalTasksDl;
    @ViewComponent
    protected CollectionContainer<ExternalTaskData> runtimeExternalTasksDc;
    @ViewComponent
    protected DataGrid<ExternalTaskData> runtimeExternalTasksGrid;
    @ViewComponent
    protected InstanceContainer<ProcessInstanceData> processInstanceDataDc;
    protected ExternalTaskFilter filter;
    protected String selectedActivityId;
    protected boolean initialized = false;

    public void setSelectedActivityId(String selectedActivityId) {
        this.selectedActivityId = selectedActivityId;
    }

    public void refreshIfChanged(String selectedActivityId) {
        if (!this.initialized) {
            this.filter = (ExternalTaskFilter)this.metadata.create(ExternalTaskFilter.class);
            this.filter.setProcessInstanceId(((ProcessInstanceData)this.processInstanceDataDc.getItem()).getId());
            this.runtimeExternalTasksDl.load();
            this.initialized = true;
            return;
        }
        if (!StringUtils.equals((CharSequence)this.selectedActivityId, (CharSequence)selectedActivityId)) {
            this.selectedActivityId = selectedActivityId;
            this.filter.setActivityId(selectedActivityId);
            this.runtimeExternalTasksDl.load();
        }
    }

    @Install(to="runtimeExternalTasksDl", target=Target.DATA_LOADER)
    protected List<ExternalTaskData> runtimeExternalTasksDlLoadDelegate(LoadContext<ExternalTaskData> loadContext) {
        LoadContext.Query query = loadContext.getQuery();
        ExternalTaskLoadContext context = new ExternalTaskLoadContext().setFilter(this.filter);
        if (query != null) {
            context.setFirstResult(Integer.valueOf(query.getFirstResult())).setMaxResults(Integer.valueOf(query.getMaxResults())).setSort(query.getSort());
        }
        return this.externalTaskService.findRunningTasks(context);
    }

    @Install(to="pagination", subject="totalCountDelegate")
    protected Integer paginationTotalCountDelegate(DataLoadContext dataLoadContext) {
        long count = this.externalTaskService.getRunningTasksCount(this.filter);
        this.uiEventPublisher.publishEventForCurrentUI((ApplicationEvent)new ExternalTaskCountUpdateEvent((Object)this, count));
        return (int)count;
    }

    @Subscribe(value="runtimeExternalTasksGrid.edit")
    public void onRuntimeExternalTasksEdit(ActionPerformedEvent event) {
        ExternalTaskData selectedTask = (ExternalTaskData)this.runtimeExternalTasksGrid.getSingleSelectedItem();
        if (selectedTask == null) {
            return;
        }
        this.dialogWindows.detail(UiComponentUtils.getCurrentView(), ExternalTaskData.class).editEntity((Object)selectedTask).withAfterCloseListener(afterCloseEvent -> {
            if (afterCloseEvent.closedWith(StandardOutcome.SAVE)) {
                this.reloadExternalTasks();
            }
        }).build().open();
    }

    @Install(to="runtimeExternalTasksGrid.retries", subject="partNameGenerator")
    protected String runtimeExternalTasksGridRetriesPartNameGenerator(ExternalTaskData externalTaskData) {
        return externalTaskData.getRetries() != null && externalTaskData.getRetries() == 0 ? "error-cell" : null;
    }

    @Install(to="runtimeExternalTasksGrid.retry", subject="enabledRule")
    protected boolean runtimeExternalTasksGridRetryEnabledRule() {
        ExternalTaskData selectedTask = (ExternalTaskData)this.runtimeExternalTasksGrid.getSingleSelectedItem();
        return selectedTask != null && selectedTask.getRetries() != null && selectedTask.getRetries() == 0;
    }

    @Subscribe(value="runtimeExternalTasksGrid.retry")
    public void onRuntimeExternalTasksGridRetry(ActionPerformedEvent event) {
        ExternalTaskData selectedTask = (ExternalTaskData)this.runtimeExternalTasksGrid.getSingleSelectedItem();
        if (selectedTask == null) {
            return;
        }
        DialogWindow dialogWindow = this.dialogWindows.view(UiComponentUtils.getCurrentView(), RetryExternalTaskView.class).withAfterCloseListener(afterClose -> {
            if (afterClose.closedWith(StandardOutcome.SAVE)) {
                this.reloadExternalTasks();
            }
        }).build();
        RetryExternalTaskView retryExternalTaskView = (RetryExternalTaskView)dialogWindow.getView();
        retryExternalTaskView.setExternalTaskId(selectedTask.getExternalTaskId());
        dialogWindow.open();
    }

    protected void reloadExternalTasks() {
        this.runtimeExternalTasksDl.load();
        this.uiEventPublisher.publishEventForCurrentUI((ApplicationEvent)new ExternalTaskRetriesUpdateEvent((Object)this));
    }
}

