/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.processinstance.terminatereason;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.data.event.SortEvent;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.RouterLink;
import io.jmix.core.DataLoadContext;
import io.jmix.core.DataManager;
import io.jmix.core.LoadContext;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.model.CollectionLoader;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.StandardView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Supply;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.openbpm.control.entity.filter.IncidentFilter;
import io.openbpm.control.entity.incident.HistoricIncidentData;
import io.openbpm.control.entity.processinstance.ProcessInstanceData;
import io.openbpm.control.service.incident.IncidentLoadContext;
import io.openbpm.control.service.incident.IncidentService;
import io.openbpm.control.view.main.MainView;
import io.openbpm.control.view.processinstance.ProcessInstanceDetailView;
import io.openbpm.control.view.util.ComponentHelper;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="instance-terminate-reason-view", layout=MainView.class)
@ViewController(id="InstanceTerminateReasonView")
@ViewDescriptor(path="instance-terminate-reason-view.xml")
@DialogMode(width="60em")
public class InstanceTerminateReasonView
extends StandardView {
    @Autowired
    protected IncidentService incidentService;
    @Autowired
    protected DataManager dataManager;
    @Autowired
    protected DialogWindows dialogWindows;
    @Autowired
    protected ComponentHelper componentHelper;
    @ViewComponent
    protected InstanceContainer<ProcessInstanceData> processInstanceDc;
    @ViewComponent
    protected CollectionLoader<HistoricIncidentData> incidentsDl;
    @ViewComponent
    protected DataGrid<HistoricIncidentData> incidentsGrid;
    protected IncidentFilter filter;

    public void setProcessInstance(ProcessInstanceData processInstanceData) {
        this.processInstanceDc.setItem((Object)processInstanceData);
    }

    @Subscribe
    public void onBeforeShow(View.BeforeShowEvent event) {
        this.filter = (IncidentFilter)this.dataManager.create(IncidentFilter.class);
        this.filter.setProcessInstanceId(((ProcessInstanceData)this.processInstanceDc.getItem()).getInstanceId());
        this.incidentsDl.load();
    }

    @Subscribe(value="incidentsGrid.view")
    public void onViewAction(ActionPerformedEvent event) {
        HistoricIncidentData incident = (HistoricIncidentData)this.incidentsGrid.getSingleSelectedItem();
        if (incident == null) {
            return;
        }
        this.dialogWindows.detail(UiComponentUtils.getCurrentView(), HistoricIncidentData.class).editEntity((Object)incident).build().open();
    }

    @Install(to="incidentsGrid.createTime", subject="partNameGenerator")
    protected String incidentsGridCreateTimePartNameGenerator(HistoricIncidentData historicIncidentData) {
        return "multiline-text-cell";
    }

    @Supply(to="incidentsGrid.createTime", subject="renderer")
    protected Renderer<HistoricIncidentData> incidentsGridCreateTimeRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)incidentData -> {
            Span dateSpan = this.componentHelper.createDateSpan(incidentData.getCreateTime());
            dateSpan.addClassNames(new String[]{"overflow-hidden", "overflow-ellipsis"});
            return dateSpan;
        });
    }

    @Install(to="incidentsGrid.endTime", subject="partNameGenerator")
    protected String incidentsGridEndTimePartNameGenerator(HistoricIncidentData historicIncidentData) {
        return "multiline-text-cell";
    }

    @Supply(to="incidentsGrid.endTime", subject="renderer")
    protected Renderer<HistoricIncidentData> incidentsGridEndTimeRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)incidentData -> {
            Span dateSpan = this.componentHelper.createDateSpan(incidentData.getEndTime());
            dateSpan.addClassNames(new String[]{"overflow-hidden", "overflow-ellipsis"});
            return dateSpan;
        });
    }

    @Install(to="incidentsDl", target=Target.DATA_LOADER)
    protected List<HistoricIncidentData> incidentsDlLoadDelegate(LoadContext<HistoricIncidentData> loadContext) {
        LoadContext.Query query = loadContext.getQuery();
        IncidentLoadContext context = new IncidentLoadContext().setFilter(this.filter);
        if (query != null) {
            context.setFirstResult(Integer.valueOf(query.getFirstResult())).setMaxResults(Integer.valueOf(query.getMaxResults())).setSort(query.getSort());
        }
        return this.incidentService.findHistoricIncidents(context);
    }

    @Install(to="incidentsPagination", subject="totalCountDelegate")
    protected Integer incidentsPaginationTotalCountDelegate(DataLoadContext dataLoadContext) {
        long incidentsCount = this.incidentService.getHistoricIncidentCount(this.filter);
        return (int)incidentsCount;
    }

    @Subscribe(value="incidentsGrid")
    public void onHistoryTasksGridGridSort(SortEvent<DataGrid<HistoricIncidentData>, GridSortOrder<DataGrid<HistoricIncidentData>>> event) {
        this.incidentsDl.load();
    }

    @Subscribe(id="viewInstanceBtn", subject="clickListener")
    public void onViewInstanceBtnClick(ClickEvent<JmixButton> event) {
        RouterLink routerLink = new RouterLink(ProcessInstanceDetailView.class, new RouteParameters("id", ((ProcessInstanceData)this.processInstanceDc.getItem()).getInstanceId()));
        this.getUI().ifPresent(ui -> ui.getPage().open(routerLink.getHref()));
    }
}

