/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control;

import com.google.common.base.Strings;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.component.page.Push;
import com.vaadin.flow.server.PWA;
import com.vaadin.flow.theme.Theme;
import javax.sql.DataSource;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;

@Push
@Theme(value="openbpm-control")
@PWA(name="OpenBPM Control", shortName="OpenBPM Control", iconPath="icons/logo.png")
@SpringBootApplication
@ConfigurationPropertiesScan
public class OpenBpmControlApplication
implements AppShellConfigurator {
    @Autowired
    private Environment environment;

    public static void main(String[] args) {
        SpringApplication.run(OpenBpmControlApplication.class, (String[])args);
    }

    @Bean
    @Primary
    @ConfigurationProperties(value="main.datasource")
    DataSourceProperties dataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean
    @Primary
    @ConfigurationProperties(value="main.datasource.hikari")
    DataSource dataSource(DataSourceProperties dataSourceProperties) {
        return dataSourceProperties.initializeDataSourceBuilder().build();
    }

    @EventListener
    public void printApplicationUrl(ApplicationStartedEvent event) {
        LoggerFactory.getLogger(OpenBpmControlApplication.class).info("Application started at http://localhost:" + this.environment.getProperty("local.server.port") + Strings.nullToEmpty((String)this.environment.getProperty("server.servlet.context-path")));
    }
}

