/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.configuration;

import com.vaadin.flow.spring.security.VaadinSavedRequestAwareAuthenticationSuccessHandler;
import io.jmix.oidc.userinfo.JmixOidcUserService;
import io.jmix.securityflowui.security.FlowuiVaadinWebSecurity;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.oauth2.client.oidc.web.logout.OidcClientInitiatedLogoutSuccessHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@Configuration
@EnableWebSecurity
@Order(value=200)
@ConditionalOnProperty(name={"openbpm.control.security.login-mode"}, havingValue="oidc")
public class OidcSecurityConfiguration
extends FlowuiVaadinWebSecurity {
    protected final JmixOidcUserService jmixOidcUserService;
    protected final ClientRegistrationRepository clientRegistrationRepository;

    public OidcSecurityConfiguration(JmixOidcUserService jmixOidcUserService, ClientRegistrationRepository clientRegistrationRepository) {
        this.jmixOidcUserService = jmixOidcUserService;
        this.clientRegistrationRepository = clientRegistrationRepository;
    }

    protected void configure(HttpSecurity http) throws Exception {
        super.configure(http);
        http.oauth2Login(oauth2 -> oauth2.userInfoEndpoint(userInfo -> userInfo.oidcUserService((OAuth2UserService)this.jmixOidcUserService)).successHandler((AuthenticationSuccessHandler)new VaadinSavedRequestAwareAuthenticationSuccessHandler()));
        OidcClientInitiatedLogoutSuccessHandler oidcLogoutHandler = new OidcClientInitiatedLogoutSuccessHandler(this.clientRegistrationRepository);
        oidcLogoutHandler.setPostLogoutRedirectUri("{baseUrl}/login");
        http.logout(logout -> logout.logoutSuccessHandler((LogoutSuccessHandler)oidcLogoutHandler));
    }
}

