/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.mapper;

import io.openbpm.control.entity.processinstance.ProcessInstanceData;
import io.openbpm.control.entity.processinstance.RuntimeProcessInstanceData;
import io.openbpm.control.mapper.ProcessInstanceMapper;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.community.rest.client.model.HistoricProcessInstanceDto;
import org.springframework.stereotype.Component;

@Component
public class ProcessInstanceMapperImpl
extends ProcessInstanceMapper {
    public ProcessInstanceData fromProcessInstanceModel(ProcessInstance source) {
        if (source == null) {
            return null;
        }
        ProcessInstanceData processInstanceData = (ProcessInstanceData)this.createProcessInstanceData(ProcessInstanceData.class);
        processInstanceData.setInstanceId(source.getId());
        processInstanceData.setId(source.getId());
        processInstanceData.setBusinessKey(source.getBusinessKey());
        processInstanceData.setProcessDefinitionId(source.getProcessDefinitionId());
        processInstanceData.setSuspended(Boolean.valueOf(source.isSuspended()));
        processInstanceData.setTenantId(source.getTenantId());
        processInstanceData.setRootProcessInstanceId(source.getRootProcessInstanceId());
        processInstanceData.setComplete(Boolean.valueOf(false));
        processInstanceData.setExternallyTerminated(Boolean.valueOf(false));
        processInstanceData.setInternallyTerminated(Boolean.valueOf(false));
        return processInstanceData;
    }

    public ProcessInstanceData fromHistoryProcessInstanceDto(HistoricProcessInstanceDto source) {
        if (source == null) {
            return null;
        }
        ProcessInstanceData processInstanceData = (ProcessInstanceData)this.createProcessInstanceData(ProcessInstanceData.class);
        processInstanceData.setInstanceId(source.getId());
        processInstanceData.setDeleteReason(source.getDeleteReason());
        processInstanceData.setId(source.getId());
        processInstanceData.setBusinessKey(source.getBusinessKey());
        processInstanceData.setProcessDefinitionId(source.getProcessDefinitionId());
        processInstanceData.setTenantId(source.getTenantId());
        processInstanceData.setProcessDefinitionKey(source.getProcessDefinitionKey());
        processInstanceData.setProcessDefinitionName(source.getProcessDefinitionName());
        processInstanceData.setProcessDefinitionVersion(source.getProcessDefinitionVersion());
        processInstanceData.setRootProcessInstanceId(source.getRootProcessInstanceId());
        processInstanceData.setEndTime(this.offsetDateTimeToDate(source.getEndTime()));
        processInstanceData.setStartTime(this.offsetDateTimeToDate(source.getStartTime()));
        this.afterHistoricProcessInstanceDtoMapping(processInstanceData, source);
        return processInstanceData;
    }

    public RuntimeProcessInstanceData toRuntimeProcessInstanceData(ProcessInstance source) {
        if (source == null) {
            return null;
        }
        RuntimeProcessInstanceData runtimeProcessInstanceData = this.createProcessInstanceData(RuntimeProcessInstanceData.class);
        runtimeProcessInstanceData.setInstanceId(source.getId());
        runtimeProcessInstanceData.setId(source.getId());
        runtimeProcessInstanceData.setBusinessKey(source.getBusinessKey());
        runtimeProcessInstanceData.setProcessDefinitionId(source.getProcessDefinitionId());
        runtimeProcessInstanceData.setSuspended(Boolean.valueOf(source.isSuspended()));
        return runtimeProcessInstanceData;
    }
}

