/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.service.decisiondefinition.impl;

import io.openbpm.control.service.decisiondefinition.impl.DecisionDefinitionQueryImpl;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.community.rest.client.api.DecisionDefinitionApiClient;
import org.camunda.community.rest.client.model.CountResultDto;
import org.camunda.community.rest.impl.query.BaseQuery;
import org.camunda.community.rest.impl.query.QueryOrderingProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class DecisionDefinitionQueryImpl
extends BaseQuery<DecisionDefinitionQuery, DecisionDefinition>
implements DecisionDefinitionQuery {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DecisionDefinitionQueryImpl.class);
    protected final DecisionDefinitionApiClient decisionDefinitionApiClient;
    protected String decisionDefinitionId;
    protected String decisionDefinitionIdIn;
    protected String name;
    protected String nameLike;
    protected String deploymentId;
    protected OffsetDateTime deployedAfter;
    protected OffsetDateTime deployedAt;
    protected String key;
    protected String keyLike;
    protected String category;
    protected String categoryLike;
    protected Integer version;
    protected Boolean latestVersion;
    protected String resourceName;
    protected String resourceNameLike;
    protected String decisionRequirementsDefinitionId;
    protected String decisionRequirementsDefinitionKey;
    protected Boolean withoutDecisionRequirementsDefinition;
    protected String tenantIdIn;
    protected Boolean withoutTenantId;
    protected Boolean includeDecisionDefinitionsWithoutTenantId;
    protected String versionTag;
    protected String versionTagLike;

    public DecisionDefinitionQueryImpl(DecisionDefinitionApiClient decisionDefinitionApiClient) {
        this.decisionDefinitionApiClient = decisionDefinitionApiClient;
    }

    public long count() {
        ResponseEntity response = this.decisionDefinitionApiClient.getDecisionDefinitionsCount(this.decisionDefinitionId, this.decisionDefinitionIdIn, this.name, this.nameLike, this.deploymentId, this.deployedAfter, this.deployedAt, this.key, this.keyLike, this.category, this.categoryLike, this.version, this.latestVersion, this.resourceName, this.resourceNameLike, this.decisionRequirementsDefinitionId, this.decisionRequirementsDefinitionKey, this.withoutDecisionRequirementsDefinition, this.tenantIdIn, this.withoutTenantId, this.includeDecisionDefinitionsWithoutTenantId, this.versionTag, this.versionTagLike);
        CountResultDto countResultDto = (CountResultDto)response.getBody();
        if (response.getStatusCode().is2xxSuccessful() && countResultDto != null) {
            return countResultDto.getCount();
        }
        log.error("Error on loading decisions count, status code {}", (Object)response.getStatusCode());
        return -1L;
    }

    public List<DecisionDefinition> listPage(int firstResult, int maxResult) {
        QueryOrderingProperty queryOrderingProperty = this.sortProperty();
        String orderBy = queryOrderingProperty != null ? queryOrderingProperty.getProperty() : null;
        String orderDirection = queryOrderingProperty != null && queryOrderingProperty.getDirection() != null ? queryOrderingProperty.getDirection().name().toLowerCase() : null;
        ResponseEntity response = this.decisionDefinitionApiClient.getDecisionDefinitions(orderBy, orderDirection, Integer.valueOf(firstResult), Integer.valueOf(maxResult), this.decisionDefinitionId, this.decisionDefinitionIdIn, this.name, this.nameLike, this.deploymentId, this.deployedAfter, this.deployedAt, this.key, this.keyLike, this.category, this.categoryLike, this.version, this.latestVersion, this.resourceName, this.resourceNameLike, this.decisionRequirementsDefinitionId, this.decisionRequirementsDefinitionKey, this.withoutDecisionRequirementsDefinition, this.tenantIdIn, this.withoutTenantId, this.includeDecisionDefinitionsWithoutTenantId, this.versionTag, this.versionTagLike);
        List decisionDefinitionDtoList = (List)response.getBody();
        if (response.getStatusCode().is2xxSuccessful() && decisionDefinitionDtoList != null) {
            return decisionDefinitionDtoList.stream().map(e -> new DecisionDefinitionImpl(e.getId(), e.getCategory(), e.getName(), e.getKey(), e.getVersion().intValue(), e.getResource(), e.getDeploymentId(), null, e.getTenantId(), e.getHistoryTimeToLive(), e.getDecisionRequirementsDefinitionId(), e.getDecisionRequirementsDefinitionKey(), e.getVersionTag())).toList();
        }
        log.error("Error on loading decisions, status code {}", (Object)response.getStatusCode());
        return List.of();
    }

    public DecisionDefinitionQuery decisionDefinitionId(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
        return this;
    }

    public DecisionDefinitionQuery decisionDefinitionIdIn(String ... strings) {
        this.decisionDefinitionIdIn = String.join((CharSequence)",", strings);
        return null;
    }

    public DecisionDefinitionQuery decisionDefinitionCategory(String category) {
        this.category = category;
        return this;
    }

    public DecisionDefinitionQuery decisionDefinitionCategoryLike(String categoryLike) {
        this.categoryLike = categoryLike;
        return this;
    }

    public DecisionDefinitionQuery decisionDefinitionName(String name) {
        this.name = name;
        return this;
    }

    public DecisionDefinitionQuery decisionDefinitionKey(String key) {
        this.key = key;
        return this;
    }

    public DecisionDefinitionQuery decisionDefinitionKeyLike(String keyLike) {
        this.keyLike = keyLike;
        return this;
    }

    public DecisionDefinitionQuery decisionDefinitionNameLike(String nameLike) {
        this.nameLike = nameLike;
        return this;
    }

    public DecisionDefinitionQuery deploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
        return this;
    }

    public DecisionDefinitionQuery deployedAfter(Date date) {
        this.deployedAfter = date.toInstant().atOffset(ZoneOffset.UTC);
        return this;
    }

    public DecisionDefinitionQuery deployedAt(Date date) {
        this.deployedAt = date.toInstant().atOffset(ZoneOffset.UTC);
        return this;
    }

    public DecisionDefinitionQuery decisionDefinitionVersion(Integer version) {
        this.version = version;
        return this;
    }

    public DecisionDefinitionQuery latestVersion() {
        this.latestVersion = true;
        return this;
    }

    public DecisionDefinitionQuery decisionDefinitionResourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    public DecisionDefinitionQuery decisionDefinitionResourceNameLike(String resourceNameLike) {
        this.resourceNameLike = resourceNameLike;
        return this;
    }

    public DecisionDefinitionQuery decisionRequirementsDefinitionId(String decisionRequirementsDefinitionId) {
        this.decisionRequirementsDefinitionId = decisionRequirementsDefinitionId;
        return this;
    }

    public DecisionDefinitionQuery decisionRequirementsDefinitionKey(String decisionRequirementsDefinitionKey) {
        this.decisionRequirementsDefinitionKey = decisionRequirementsDefinitionKey;
        return this;
    }

    public DecisionDefinitionQuery withoutDecisionRequirementsDefinition() {
        this.withoutDecisionRequirementsDefinition = true;
        return this;
    }

    public DecisionDefinitionQuery includeDecisionDefinitionsWithoutTenantId() {
        this.includeDecisionDefinitionsWithoutTenantId = true;
        return this;
    }

    public DecisionDefinitionQuery versionTag(String versionTag) {
        this.versionTag = versionTag;
        return this;
    }

    public DecisionDefinitionQuery versionTagLike(String versionTagLike) {
        this.versionTagLike = versionTagLike;
        return this;
    }

    public DecisionDefinitionQuery orderByDecisionDefinitionCategory() {
        super.orderBy("category");
        return this;
    }

    public DecisionDefinitionQuery orderByDecisionDefinitionKey() {
        super.orderBy("key");
        return this;
    }

    public DecisionDefinitionQuery orderByDecisionDefinitionId() {
        super.orderBy("id");
        return this;
    }

    public DecisionDefinitionQuery orderByDecisionDefinitionVersion() {
        super.orderBy("version");
        return this;
    }

    public DecisionDefinitionQuery orderByDecisionDefinitionName() {
        super.orderBy("name");
        return this;
    }

    public DecisionDefinitionQuery orderByDeploymentId() {
        super.orderBy("deploymentId");
        return this;
    }

    public DecisionDefinitionQuery orderByDeploymentTime() {
        super.orderBy("deployTime");
        return this;
    }

    public DecisionDefinitionQuery orderByDecisionRequirementsDefinitionKey() {
        super.orderBy("decisionRequirementsDefinitionKey");
        return this;
    }

    public DecisionDefinitionQuery orderByVersionTag() {
        super.orderBy("versionTag");
        return this;
    }
}

