/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.service.deployment.impl;

import feign.FeignException;
import feign.utils.ExceptionUtils;
import io.jmix.core.Sort;
import io.openbpm.control.entity.deployment.DeploymentData;
import io.openbpm.control.entity.deployment.DeploymentResource;
import io.openbpm.control.entity.filter.DeploymentFilter;
import io.openbpm.control.exception.EngineNotSelectedException;
import io.openbpm.control.mapper.DeploymentMapper;
import io.openbpm.control.mapper.DeploymentResourceMapper;
import io.openbpm.control.service.deployment.DeploymentContext;
import io.openbpm.control.service.deployment.DeploymentLoadContext;
import io.openbpm.control.service.deployment.DeploymentService;
import io.openbpm.control.util.QueryUtils;
import java.net.ConnectException;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.repository.DeploymentWithDefinitions;
import org.camunda.community.rest.client.api.DeploymentApiClient;
import org.camunda.community.rest.client.model.DeploymentDto;
import org.camunda.community.rest.impl.RemoteRepositoryService;
import org.camunda.community.rest.impl.builder.DelegatingDeploymentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

@Service(value="control_DeploymentService")
public class DeploymentServiceImpl
implements DeploymentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeploymentServiceImpl.class);
    public static final String OPENBPM_CONTROL_SOURCE = "OpenBPM Control";
    protected final RemoteRepositoryService remoteRepositoryService;
    protected final DeploymentMapper deploymentMapper;
    protected final DeploymentResourceMapper deploymentResourceMapper;
    protected final DeploymentApiClient deploymentApiClient;

    public DeploymentServiceImpl(RemoteRepositoryService remoteRepositoryService, DeploymentMapper deploymentMapper, DeploymentResourceMapper deploymentResourceMapper, DeploymentApiClient deploymentApiClient) {
        this.remoteRepositoryService = remoteRepositoryService;
        this.deploymentMapper = deploymentMapper;
        this.deploymentResourceMapper = deploymentResourceMapper;
        this.deploymentApiClient = deploymentApiClient;
    }

    public DeploymentWithDefinitions createDeployment(DeploymentContext context) {
        DelegatingDeploymentBuilder deployment = this.remoteRepositoryService.createDeployment();
        return deployment.source(OPENBPM_CONTROL_SOURCE).addInputStream(context.getResourceName(), context.getResourceContent()).deployWithResult();
    }

    @Nullable
    public DeploymentData findById(String deploymentId) {
        try {
            ResponseEntity response = this.deploymentApiClient.getDeployment(deploymentId);
            if (response.getStatusCode().is2xxSuccessful() && response.hasBody()) {
                return this.deploymentMapper.fromDto((DeploymentDto)response.getBody());
            }
        }
        catch (Exception e) {
            FeignException feignException;
            if (e instanceof FeignException && (feignException = (FeignException)((Object)e)).status() == 404) {
                log.error("Unable to find deployment by id {}", (Object)deploymentId, (Object)e);
                return null;
            }
            throw e;
        }
        return null;
    }

    public List<DeploymentData> findAll(DeploymentLoadContext context) {
        try {
            DeploymentQuery deploymentQuery = this.createDeploymentQuery((DeploymentFilter)context.getFilter(), context.getSort());
            List deployments = context.getFirstResult() != null && context.getMaxResults() != null ? deploymentQuery.listPage(context.getFirstResult().intValue(), context.getMaxResults().intValue()) : deploymentQuery.list();
            return deployments.stream().map(arg_0 -> ((DeploymentMapper)this.deploymentMapper).fromProcessDefinitionModel(arg_0)).toList();
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load deployments because BPM engine not selected");
                return List.of();
            }
            if (rootCause instanceof ConnectException) {
                log.error("Unable to load deployments because of connection error: ", (Throwable)e);
                return List.of();
            }
            throw e;
        }
    }

    @Nullable
    public List<DeploymentResource> getDeploymentResources(String deploymentId) {
        try {
            ResponseEntity response = this.deploymentApiClient.getDeploymentResources(deploymentId);
            if (response.getStatusCode().is2xxSuccessful() && response.hasBody()) {
                List deploymentResources = Optional.ofNullable((List)response.getBody()).orElse(List.of());
                return deploymentResources.stream().map(arg_0 -> ((DeploymentResourceMapper)this.deploymentResourceMapper).fromDto(arg_0)).toList();
            }
        }
        catch (Exception e) {
            FeignException feignException;
            if (e instanceof FeignException && (feignException = (FeignException)((Object)e)).status() == 404) {
                log.error("Unable to find deployment with id {}", (Object)deploymentId, (Object)e);
                return null;
            }
            throw e;
        }
        return null;
    }

    @Nullable
    public Resource getDeploymentResourceData(String deploymentId, String resourceId) {
        try {
            ResponseEntity response = this.deploymentApiClient.getDeploymentResourceData(deploymentId, resourceId);
            if (response.getStatusCode().is2xxSuccessful() && response.hasBody()) {
                return (Resource)response.getBody();
            }
        }
        catch (Exception e) {
            FeignException feignException;
            if (e instanceof FeignException && (feignException = (FeignException)((Object)e)).status() == 404) {
                log.error("Unable to find deployment resource with id {} for deployment with id {} because of {}", new Object[]{resourceId, deploymentId, e.getMessage()});
                return null;
            }
            throw e;
        }
        return null;
    }

    public void deleteById(String deploymentId, boolean deleteAllRelatedInstances, boolean skipCustomListeners, boolean skipIoMappings) {
        this.remoteRepositoryService.deleteDeployment(deploymentId, deleteAllRelatedInstances, skipCustomListeners, skipIoMappings);
    }

    protected DeploymentQuery createDeploymentQuery(@Nullable DeploymentFilter filter, @Nullable Sort sort) {
        DeploymentQuery deploymentQuery = this.remoteRepositoryService.createDeploymentQuery();
        QueryUtils.addDeploymentFilters((DeploymentQuery)deploymentQuery, (DeploymentFilter)filter);
        QueryUtils.addDeploymentSort((DeploymentQuery)deploymentQuery, (Sort)sort);
        return deploymentQuery;
    }
}

