/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.service.engine.impl;

import com.google.common.base.Strings;
import feign.FeignException;
import feign.RequestInterceptor;
import feign.auth.BasicAuthRequestInterceptor;
import io.jmix.core.DataManager;
import io.jmix.core.Id;
import io.jmix.core.Metadata;
import io.jmix.core.event.EntityChangedEvent;
import io.jmix.core.security.CurrentAuthentication;
import io.jmix.core.session.SessionData;
import io.jmix.flowui.UiEventPublisher;
import io.openbpm.control.entity.EngineConnectionCheckResult;
import io.openbpm.control.entity.engine.AuthType;
import io.openbpm.control.entity.engine.BpmEngine;
import io.openbpm.control.event.UserEngineSelectEvent;
import io.openbpm.control.exception.EngineConnectionFailedException;
import io.openbpm.control.property.EngineConnectionCheckProperties;
import io.openbpm.control.restsupport.FeignClientCreationContext;
import io.openbpm.control.restsupport.FeignClientProvider;
import io.openbpm.control.service.engine.EngineService;
import io.openbpm.control.service.engine.EngineUiService;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.camunda.community.rest.client.api.VersionApiClient;
import org.camunda.community.rest.client.model.VersionDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationEvent;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.event.TransactionalEventListener;

@Service(value="control_EngineUiService")
public class EngineUiServiceImpl
implements EngineUiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EngineUiServiceImpl.class);
    protected final Metadata metadata;
    protected final ObjectProvider<SessionData> sessionDataProvider;
    protected final DataManager dataManager;
    protected final FeignClientProvider feignClientProvider;
    protected final UiEventPublisher uiEventPublisher;
    protected final CurrentAuthentication currentAuthentication;
    protected final EngineConnectionCheckProperties checkProperties;
    protected final EngineService engineService;
    protected Map<UUID, VersionApiClient> versionClientByEngineId = new ConcurrentHashMap();

    public EngineUiServiceImpl(Metadata metadata, ObjectProvider<SessionData> sessionDataProvider, FeignClientProvider feignClientProvider, UiEventPublisher uiEventPublisher, CurrentAuthentication currentAuthentication, DataManager dataManager, EngineConnectionCheckProperties checkProperties, EngineService engineService) {
        this.metadata = metadata;
        this.sessionDataProvider = sessionDataProvider;
        this.feignClientProvider = feignClientProvider;
        this.uiEventPublisher = uiEventPublisher;
        this.currentAuthentication = currentAuthentication;
        this.dataManager = dataManager;
        this.checkProperties = checkProperties;
        this.engineService = engineService;
    }

    public EngineConnectionCheckResult checkConnection(BpmEngine bpmEngine) {
        EngineConnectionCheckResult result = (EngineConnectionCheckResult)this.metadata.create(EngineConnectionCheckResult.class);
        BpmEngine persistedEngine = this.engineService.findEngineByUuid(bpmEngine.getId());
        if (persistedEngine == null) {
            log.error("There is no engine with id  {}", (Object)bpmEngine.getId());
            result.setSuccess(Boolean.valueOf(false));
            return result;
        }
        VersionApiClient versionApiClient = this.versionClientByEngineId.computeIfAbsent(bpmEngine.getId(), engineId -> this.createVersionApiClient(persistedEngine));
        try {
            ResponseEntity response = versionApiClient.getRestAPIVersion();
            if (response.getStatusCode().is2xxSuccessful()) {
                result.setSuccess(Boolean.valueOf(true));
                VersionDto versionDto = (VersionDto)response.getBody();
                if (versionDto != null) {
                    result.setVersion(versionDto.getVersion());
                } else {
                    log.warn("Empty response is returned while engine version loading, status code {}", (Object)response.getStatusCode());
                    result.setVersion("");
                }
            } else {
                log.error("Error while engine version loading, status code {}", (Object)response.getStatusCode());
                result.setSuccess(Boolean.valueOf(false));
            }
        }
        catch (FeignException e) {
            log.error("Error while engine version loading ", (Throwable)e);
            result.setSuccess(Boolean.valueOf(false));
        }
        return result;
    }

    public String getVersion(BpmEngine engine) {
        try {
            VersionApiClient camundaClient = (VersionApiClient)this.feignClientProvider.createCamundaClient(new FeignClientCreationContext(VersionApiClient.class).setUrl(engine.getBaseUrl()).setRequestInterceptor(this.createBpmEngineRequestInterceptor(engine)));
            ResponseEntity response = camundaClient.getRestAPIVersion();
            if (response.getStatusCode().is2xxSuccessful()) {
                VersionDto versionDto = (VersionDto)response.getBody();
                return versionDto != null ? versionDto.getVersion() : "";
            }
            throw new EngineConnectionFailedException(response.getStatusCode().value(), "Unable to get an engine version");
        }
        catch (FeignException e) {
            log.error("Error on loading the version from engine  '{}'", (Object)engine.getBaseUrl(), (Object)e);
            throw new EngineConnectionFailedException(e.status(), e.getMessage());
        }
    }

    public void selectEngine(BpmEngine engine) {
        String username = this.currentAuthentication.getUser().getUsername();
        log.debug("User '{}' selects engine '{} (name: '{}', url: '{}')'", new Object[]{username, engine.getId(), engine.getName(), engine.getBaseUrl()});
        this.engineService.setSelectedEngine(engine);
        this.uiEventPublisher.publishEvent((ApplicationEvent)new UserEngineSelectEvent((Object)this, engine, username));
    }

    protected VersionApiClient createVersionApiClient(BpmEngine engine) {
        return (VersionApiClient)this.feignClientProvider.createCamundaClient(new FeignClientCreationContext(VersionApiClient.class).setUrl(engine.getBaseUrl()).setMaxRetries(this.checkProperties.getMaxRetries()).setRetryTimeout(this.checkProperties.getRetryTimeout()).setConnectTimeout(this.checkProperties.getConnectTimeout()).setReadTimeout(this.checkProperties.getReadTimeout()).setRequestInterceptor(this.createBpmEngineRequestInterceptor(engine)));
    }

    @Nullable
    protected RequestInterceptor createBpmEngineRequestInterceptor(BpmEngine engine) {
        RequestInterceptor requestInterceptor = null;
        if (BooleanUtils.isTrue((Boolean)engine.getAuthEnabled())) {
            if (engine.getAuthType() == AuthType.BASIC) {
                requestInterceptor = new BasicAuthRequestInterceptor(Strings.nullToEmpty((String)engine.getBasicAuthUsername()), Strings.nullToEmpty((String)engine.getBasicAuthPassword()));
            } else if (engine.getAuthType() == AuthType.HTTP_HEADER) {
                requestInterceptor = requestTemplate -> requestTemplate.header(engine.getHttpHeaderName(), new String[]{engine.getHttpHeaderValue()});
            }
        }
        return requestInterceptor;
    }

    @TransactionalEventListener
    public void onBpmEngineChangedAfterCommit(EntityChangedEvent<BpmEngine> event) {
        Id entityId = event.getEntityId();
        if (event.getType() == EntityChangedEvent.Type.DELETED || event.getType() == EntityChangedEvent.Type.UPDATED) {
            this.versionClientByEngineId.remove((UUID)entityId.getValue());
        }
    }
}

