/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.service.processdefinition.impl;

import feign.FeignException;
import feign.utils.ExceptionUtils;
import io.jmix.core.Sort;
import io.openbpm.control.entity.filter.ProcessDefinitionFilter;
import io.openbpm.control.entity.processdefinition.ProcessDefinitionData;
import io.openbpm.control.exception.EngineNotSelectedException;
import io.openbpm.control.mapper.ProcessDefinitionMapper;
import io.openbpm.control.service.processdefinition.ProcessDefinitionLoadContext;
import io.openbpm.control.service.processdefinition.ProcessDefinitionService;
import io.openbpm.control.util.QueryUtils;
import jakarta.annotation.Nullable;
import java.net.ConnectException;
import java.util.List;
import lombok.Generated;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.community.rest.client.api.ProcessDefinitionApiClient;
import org.camunda.community.rest.client.model.ProcessDefinitionDiagramDto;
import org.camunda.community.rest.client.model.ProcessDefinitionSuspensionStateDto;
import org.camunda.community.rest.impl.RemoteRepositoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service(value="control_ProcessDefinitionService")
public class ProcessDefinitionServiceImpl
implements ProcessDefinitionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessDefinitionServiceImpl.class);
    protected final RemoteRepositoryService remoteRepositoryService;
    protected final ProcessDefinitionMapper processDefinitionMapper;
    protected final ProcessDefinitionApiClient processDefinitionApiClient;

    public ProcessDefinitionServiceImpl(RemoteRepositoryService remoteRepositoryService, ProcessDefinitionMapper processDefinitionMapper, ProcessDefinitionApiClient processDefinitionApiClient) {
        this.remoteRepositoryService = remoteRepositoryService;
        this.processDefinitionMapper = processDefinitionMapper;
        this.processDefinitionApiClient = processDefinitionApiClient;
    }

    public List<ProcessDefinitionData> findLatestVersions() {
        try {
            return ((ProcessDefinitionQuery)this.remoteRepositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).latestVersion().list().stream().map(arg_0 -> ((ProcessDefinitionMapper)this.processDefinitionMapper).fromProcessDefinitionModel(arg_0)).toList();
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load latest versions of process definitions because BPM engine not selected");
                return List.of();
            }
            if (rootCause instanceof ConnectException) {
                log.error("Unable to load latest versions of process definitions because of connection error: ", (Throwable)e);
                return List.of();
            }
            throw e;
        }
    }

    public List<ProcessDefinitionData> findAllByKey(String processDefinitionKey) {
        try {
            return ((ProcessDefinitionQuery)this.remoteRepositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).processDefinitionKey(processDefinitionKey).list().stream().map(arg_0 -> ((ProcessDefinitionMapper)this.processDefinitionMapper).fromProcessDefinitionModel(arg_0)).toList();
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load process definition versions by key because BPM engine not selected");
                return List.of();
            }
            if (rootCause instanceof ConnectException) {
                log.error("Unable to load process definition versions by key because of connection error: ", (Throwable)e);
                return List.of();
            }
            throw e;
        }
    }

    public List<ProcessDefinitionData> findAll(ProcessDefinitionLoadContext context) {
        try {
            ProcessDefinitionQuery processDefinitionQuery = this.createProcessDefinitionQuery((ProcessDefinitionFilter)context.getFilter(), context.getSort());
            List processDefinitions = context.getFirstResult() != null && context.getMaxResults() != null ? processDefinitionQuery.listPage(context.getFirstResult().intValue(), context.getMaxResults().intValue()) : processDefinitionQuery.list();
            return processDefinitions.stream().map(arg_0 -> ((ProcessDefinitionMapper)this.processDefinitionMapper).fromProcessDefinitionModel(arg_0)).toList();
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load process definitions because BPM engine not selected");
                return List.of();
            }
            if (rootCause instanceof ConnectException) {
                log.error("Unable to load process definitions because of connection error: ", (Throwable)e);
                return List.of();
            }
            throw e;
        }
    }

    public long getCount(@Nullable ProcessDefinitionFilter filter) {
        try {
            ProcessDefinitionQuery processDefinitionQuery = this.createProcessDefinitionQuery(filter, null);
            return processDefinitionQuery.count();
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load get count of process definitions because BPM engine not selected");
                return 0L;
            }
            if (rootCause instanceof ConnectException) {
                log.error("Unable to load get count of process definitions because of connection error: ", (Throwable)e);
                return 0L;
            }
            throw e;
        }
    }

    public ProcessDefinitionData getById(String processDefinitionId) {
        try {
            ProcessDefinition processDefinition = (ProcessDefinition)this.remoteRepositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
            return this.processDefinitionMapper.fromProcessDefinitionModel(processDefinition);
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load process definition by id '{}' because BPM engine not selected", (Object)processDefinitionId);
                return null;
            }
            if (rootCause instanceof ConnectException) {
                log.error("Unable load process definition by id '{}' because of connection error: ", (Object)processDefinitionId, (Object)e);
                return null;
            }
            throw e;
        }
    }

    public String getBpmnXml(String processDefinitionId) {
        try {
            ResponseEntity processDefinitionBpmn20Xml = this.processDefinitionApiClient.getProcessDefinitionBpmn20Xml(processDefinitionId);
            if (processDefinitionBpmn20Xml.getStatusCode().is2xxSuccessful()) {
                ProcessDefinitionDiagramDto diagramDto = (ProcessDefinitionDiagramDto)processDefinitionBpmn20Xml.getBody();
                return diagramDto != null ? diagramDto.getBpmn20Xml() : null;
            }
            return null;
        }
        catch (Exception e) {
            FeignException feignException;
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load process definition XML by id '{}' because BPM engine not selected", (Object)processDefinitionId);
                return null;
            }
            if (rootCause instanceof ConnectException) {
                log.error("Unable load process definition XML by id '{}' because of connection error: ", (Object)processDefinitionId, (Object)e);
                return null;
            }
            if (rootCause instanceof FeignException && (feignException = (FeignException)rootCause).status() == 404) {
                log.warn("Unable to load process definition XML by id '{}' because process does not exist", (Object)processDefinitionId);
                return null;
            }
            throw e;
        }
    }

    public void activateById(String processDefinitionId, boolean activateBelongsInstances) {
        this.suspendOrActivateProcessDefinitionById(processDefinitionId, activateBelongsInstances, false);
    }

    public void activateAllVersionsByKey(String processDefinitionKey, boolean activateBelongsInstances) {
        this.suspendOrActivateProcessDefinitionsByKey(processDefinitionKey, activateBelongsInstances, false);
    }

    public void suspendById(String processDefinitionId, boolean suspendBelongsInstances) {
        this.suspendOrActivateProcessDefinitionById(processDefinitionId, suspendBelongsInstances, true);
    }

    public void suspendAllVersionsByKey(String processDefinitionKey, boolean suspendBelongsInstances) {
        this.suspendOrActivateProcessDefinitionsByKey(processDefinitionKey, suspendBelongsInstances, true);
    }

    public void deleteAllVersionsByKey(String processDefinitionKey, boolean deleteAllRelatedInstances) {
        boolean hasNextVersion = this.deleteProcessVersionByKey(processDefinitionKey, deleteAllRelatedInstances);
        if (hasNextVersion) {
            while (hasNextVersion = this.deleteProcessVersionByKey(processDefinitionKey, deleteAllRelatedInstances)) {
            }
        }
    }

    protected boolean deleteProcessVersionByKey(String processDefinitionKey, boolean deleteAllRelatedInstances) {
        try {
            this.processDefinitionApiClient.deleteProcessDefinitionsByKey(processDefinitionKey, Boolean.valueOf(deleteAllRelatedInstances), null, null);
            return true;
        }
        catch (Exception e) {
            FeignException feignException;
            if (e instanceof FeignException && (feignException = (FeignException)e).status() == 404) {
                return false;
            }
            throw e;
        }
    }

    public void deleteById(String processDefinitionId, boolean deleteAllRelatedInstances) {
        this.remoteRepositoryService.deleteProcessDefinition(processDefinitionId, deleteAllRelatedInstances);
    }

    protected void suspendOrActivateProcessDefinitionById(String processDefinitionId, boolean cascadeOperationToBelongsInstances, boolean suspended) {
        ProcessDefinitionSuspensionStateDto suspendedCommand = new ProcessDefinitionSuspensionStateDto().suspended(Boolean.valueOf(suspended));
        if (cascadeOperationToBelongsInstances) {
            suspendedCommand.includeProcessInstances(Boolean.valueOf(cascadeOperationToBelongsInstances));
        }
        this.processDefinitionApiClient.updateProcessDefinitionSuspensionStateById(processDefinitionId, suspendedCommand);
    }

    protected void suspendOrActivateProcessDefinitionsByKey(String processDefinitionKey, boolean cascadeOperationToBelongsInstances, boolean suspended) {
        ProcessDefinitionSuspensionStateDto suspendedCommand = new ProcessDefinitionSuspensionStateDto().processDefinitionKey(processDefinitionKey).suspended(Boolean.valueOf(suspended));
        if (cascadeOperationToBelongsInstances) {
            suspendedCommand.includeProcessInstances(Boolean.valueOf(cascadeOperationToBelongsInstances));
        }
        this.processDefinitionApiClient.updateProcessDefinitionSuspensionState(suspendedCommand);
    }

    protected ProcessDefinitionQuery createProcessDefinitionQuery(@Nullable ProcessDefinitionFilter filter, @Nullable Sort sort) {
        ProcessDefinitionQuery processDefinitionQuery = this.remoteRepositoryService.createProcessDefinitionQuery();
        QueryUtils.addDefinitionFilters((ProcessDefinitionQuery)processDefinitionQuery, (ProcessDefinitionFilter)filter);
        QueryUtils.addDefinitionSort((ProcessDefinitionQuery)processDefinitionQuery, (Sort)sort);
        return processDefinitionQuery;
    }
}

