/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.service.usertask.impl;

import feign.utils.ExceptionUtils;
import io.jmix.core.Sort;
import io.openbpm.control.entity.UserTaskData;
import io.openbpm.control.entity.filter.UserTaskFilter;
import io.openbpm.control.entity.variable.VariableInstanceData;
import io.openbpm.control.exception.EngineNotSelectedException;
import io.openbpm.control.mapper.TaskMapper;
import io.openbpm.control.service.usertask.UserTaskLoadContext;
import io.openbpm.control.service.usertask.UserTaskService;
import io.openbpm.control.service.variable.VariableUtils;
import io.openbpm.control.util.EngineRestUtils;
import io.openbpm.control.util.QueryUtils;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.community.rest.client.api.HistoryApiClient;
import org.camunda.community.rest.client.api.TaskApiClient;
import org.camunda.community.rest.client.model.CountResultDto;
import org.camunda.community.rest.client.model.HistoricTaskInstanceDto;
import org.camunda.community.rest.client.model.HistoricTaskInstanceQueryDto;
import org.camunda.community.rest.client.model.HistoricTaskInstanceQueryDtoSortingInner;
import org.camunda.community.rest.client.model.TaskQueryDto;
import org.camunda.community.rest.client.model.TaskQueryDtoSortingInner;
import org.camunda.community.rest.impl.RemoteTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

@Service(value="control_UserTaskService")
public class UserTaskServiceImpl
implements UserTaskService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserTaskServiceImpl.class);
    protected final RemoteTaskService remoteTaskService;
    protected final TaskMapper taskMapper;
    protected final HistoryApiClient historyApiClient;
    protected final TaskApiClient taskApiClient;

    public UserTaskServiceImpl(RemoteTaskService remoteTaskService, TaskMapper taskMapper, HistoryApiClient historyApiClient, TaskApiClient taskApiClient) {
        this.remoteTaskService = remoteTaskService;
        this.taskMapper = taskMapper;
        this.historyApiClient = historyApiClient;
        this.taskApiClient = taskApiClient;
    }

    public List<UserTaskData> findRuntimeTasks(UserTaskLoadContext loadContext) {
        try {
            TaskQueryDto taskQueryDto = this.createTaskQueryDto((UserTaskFilter)loadContext.getFilter());
            taskQueryDto.setSorting(this.createTaskQuerySort(loadContext.getSort()));
            ResponseEntity tasksResponse = this.taskApiClient.queryTasks(loadContext.getFirstResult(), loadContext.getMaxResults(), taskQueryDto);
            if (tasksResponse.getStatusCode().is2xxSuccessful()) {
                return CollectionUtils.emptyIfNull((Collection)((Collection)tasksResponse.getBody())).stream().map(arg_0 -> ((TaskMapper)this.taskMapper).fromRuntimeTaskDto(arg_0)).toList();
            }
            log.error("Error on user tasks loading, query: {}, status code: {}", (Object)taskQueryDto, (Object)tasksResponse.getStatusCode());
            return List.of();
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load user tasks because BPM engine not selected");
                return List.of();
            }
            if (rootCause instanceof ConnectException) {
                log.error("Unable to load user tasks because of connection error: ", (Throwable)e);
                return List.of();
            }
            throw e;
        }
    }

    public long getRuntimeTasksCount(@Nullable UserTaskFilter filter) {
        TaskQueryDto taskQueryDto = this.createTaskQueryDto(filter);
        ResponseEntity tasksResponse = this.taskApiClient.queryTasksCount(taskQueryDto);
        if (tasksResponse.getStatusCode().is2xxSuccessful()) {
            return EngineRestUtils.getCountResult((CountResultDto)((CountResultDto)tasksResponse.getBody()));
        }
        log.error("Error on user task count loading, query: {}, status code: {}", (Object)taskQueryDto, (Object)tasksResponse.getStatusCode());
        return 0L;
    }

    public void completeTaskById(String taskId, Collection<VariableInstanceData> variableInstances) {
        VariableMap variables = VariableUtils.createVariableMap(variableInstances);
        this.remoteTaskService.complete(taskId, (Map)variables);
    }

    @Nullable
    public UserTaskData findTaskById(String taskId) {
        ResponseEntity taskResponse = this.historyApiClient.queryHistoricTaskInstances(Integer.valueOf(0), Integer.valueOf(1), new HistoricTaskInstanceQueryDto().taskId(taskId));
        if (taskResponse.getStatusCode().is2xxSuccessful()) {
            List taskInstanceDtoList = (List)taskResponse.getBody();
            if (CollectionUtils.isNotEmpty((Collection)taskInstanceDtoList)) {
                HistoricTaskInstanceDto task = (HistoricTaskInstanceDto)taskInstanceDtoList.get(0);
                return this.taskMapper.fromTaskDto(task);
            }
            return null;
        }
        log.error("Error on user task loading, task id: {}, status code: {}", (Object)taskId, (Object)taskResponse.getStatusCode());
        return null;
    }

    public List<UserTaskData> findHistoricTasks(UserTaskLoadContext loadContext) {
        HistoricTaskInstanceQueryDto queryDto = this.createHistoryTaskQueryDto((UserTaskFilter)loadContext.getFilter());
        queryDto.setSorting(this.createHistoryTaskSortOptions(loadContext.getSort()));
        ResponseEntity response = this.historyApiClient.queryHistoricTaskInstances(loadContext.getFirstResult(), loadContext.getMaxResults(), queryDto);
        if (response.getStatusCode().is2xxSuccessful()) {
            List taskInstanceDtoList = (List)response.getBody();
            return CollectionUtils.emptyIfNull((Collection)taskInstanceDtoList).stream().map(arg_0 -> ((TaskMapper)this.taskMapper).fromTaskDto(arg_0)).toList();
        }
        log.error("Error on historic user task loading, query: {}, status code: {}", (Object)queryDto, (Object)response.getStatusCode());
        return List.of();
    }

    public long getHistoryTasksCount(@Nullable UserTaskFilter filter) {
        HistoricTaskInstanceQueryDto queryDto = this.createHistoryTaskQueryDto(filter);
        ResponseEntity response = this.historyApiClient.queryHistoricTaskInstancesCount(queryDto);
        if (response.getStatusCode().is2xxSuccessful()) {
            return EngineRestUtils.getCountResult((CountResultDto)((CountResultDto)response.getBody()));
        }
        log.error("Error on historic user task count loading, query: {}, status code: {}", (Object)queryDto, (Object)response.getStatusCode());
        return 0L;
    }

    public void setAssignee(String taskId, String newAssignee) {
        this.remoteTaskService.setAssignee(taskId, newAssignee);
    }

    protected TaskQueryDto createTaskQueryDto(@Nullable UserTaskFilter filter) {
        TaskQueryDto taskQueryDto = new TaskQueryDto();
        if (filter != null) {
            QueryUtils.addIfStringNotEmpty((String)filter.getProcessInstanceId(), arg_0 -> ((TaskQueryDto)taskQueryDto).setProcessInstanceId(arg_0));
            QueryUtils.addIfStringNotEmpty((String)filter.getActivityInstanceId(), value -> taskQueryDto.setActivityInstanceIdIn(List.of(value)));
            QueryUtils.addIfStringNotEmpty((String)filter.getProcessDefinitionKey(), arg_0 -> ((TaskQueryDto)taskQueryDto).setProcessDefinitionKey(arg_0));
            QueryUtils.wrapAndAddStringIfNotEmpty((String)filter.getAssigneeLike(), arg_0 -> ((TaskQueryDto)taskQueryDto).setAssigneeLike(arg_0));
            QueryUtils.wrapAndAddStringIfNotEmpty((String)filter.getTaskKeyLike(), arg_0 -> ((TaskQueryDto)taskQueryDto).setTaskDefinitionKeyLike(arg_0));
            QueryUtils.wrapAndAddStringIfNotEmpty((String)filter.getTaskNameLike(), arg_0 -> ((TaskQueryDto)taskQueryDto).setNameLike(arg_0));
            QueryUtils.addIfNotNull((Object)filter.getCreatedAfter(), arg_0 -> ((TaskQueryDto)taskQueryDto).createdAfter(arg_0));
            QueryUtils.addIfNotNull((Object)filter.getCreatedBefore(), arg_0 -> ((TaskQueryDto)taskQueryDto).createdBefore(arg_0));
            taskQueryDto.setAssigned(filter.getAssigned());
            taskQueryDto.setUnassigned(filter.getUnassigned());
            taskQueryDto.setActive(filter.getActive());
            taskQueryDto.setSuspended(filter.getSuspended());
        }
        return taskQueryDto;
    }

    protected List<TaskQueryDtoSortingInner> createTaskQuerySort(@Nullable Sort sort) {
        if (sort == null) {
            return null;
        }
        ArrayList<TaskQueryDtoSortingInner> taskSortOptions = new ArrayList<TaskQueryDtoSortingInner>();
        TaskQueryDtoSortingInner sortOption = new TaskQueryDtoSortingInner();
        for (Sort.Order order : sort.getOrders()) {
            switch (order.getProperty()) {
                case "id": {
                    sortOption.setSortBy(TaskQueryDtoSortingInner.SortByEnum.ID);
                    break;
                }
                case "name": {
                    sortOption.setSortBy(TaskQueryDtoSortingInner.SortByEnum.NAME_CASE_INSENSITIVE);
                    break;
                }
                case "createTime": {
                    sortOption.setSortBy(TaskQueryDtoSortingInner.SortByEnum.CREATED);
                    break;
                }
                case "dueDate": {
                    sortOption.setSortBy(TaskQueryDtoSortingInner.SortByEnum.DUE_DATE);
                    break;
                }
                case "assignee": {
                    sortOption.setSortBy(TaskQueryDtoSortingInner.SortByEnum.ASSIGNEE);
                    break;
                }
            }
            if (order.getDirection() == Sort.Direction.ASC) {
                sortOption.setSortOrder(TaskQueryDtoSortingInner.SortOrderEnum.ASC);
                continue;
            }
            if (order.getDirection() != Sort.Direction.DESC) continue;
            sortOption.setSortOrder(TaskQueryDtoSortingInner.SortOrderEnum.DESC);
        }
        if (sortOption.getSortBy() != null && sortOption.getSortOrder() != null) {
            taskSortOptions.add(sortOption);
        }
        return taskSortOptions;
    }

    protected HistoricTaskInstanceQueryDto createHistoryTaskQueryDto(@Nullable UserTaskFilter filter) {
        HistoricTaskInstanceQueryDto taskQueryDto = new HistoricTaskInstanceQueryDto();
        if (filter != null) {
            QueryUtils.addIfStringNotEmpty((String)filter.getProcessInstanceId(), arg_0 -> ((HistoricTaskInstanceQueryDto)taskQueryDto).setProcessInstanceId(arg_0));
            QueryUtils.addIfStringNotEmpty((String)filter.getActivityInstanceId(), value -> taskQueryDto.setActivityInstanceIdIn(List.of(value)));
        }
        return taskQueryDto;
    }

    protected List<HistoricTaskInstanceQueryDtoSortingInner> createHistoryTaskSortOptions(Sort sort) {
        ArrayList<HistoricTaskInstanceQueryDtoSortingInner> taskSortOptions = new ArrayList<HistoricTaskInstanceQueryDtoSortingInner>();
        if (sort != null) {
            HistoricTaskInstanceQueryDtoSortingInner sortOption = new HistoricTaskInstanceQueryDtoSortingInner();
            for (Sort.Order order : sort.getOrders()) {
                switch (order.getProperty()) {
                    case "id": {
                        sortOption.setSortBy(HistoricTaskInstanceQueryDtoSortingInner.SortByEnum.TASK_ID);
                        break;
                    }
                    case "taskDefinitionKey": {
                        sortOption.setSortBy(HistoricTaskInstanceQueryDtoSortingInner.SortByEnum.TASK_DEFINITION_KEY);
                        break;
                    }
                    case "name": {
                        sortOption.setSortBy(HistoricTaskInstanceQueryDtoSortingInner.SortByEnum.TASK_NAME);
                        break;
                    }
                    case "startTime": {
                        sortOption.setSortBy(HistoricTaskInstanceQueryDtoSortingInner.SortByEnum.START_TIME);
                        break;
                    }
                    case "endTime": {
                        sortOption.setSortBy(HistoricTaskInstanceQueryDtoSortingInner.SortByEnum.END_TIME);
                        break;
                    }
                    case "dueDate": {
                        sortOption.setSortBy(HistoricTaskInstanceQueryDtoSortingInner.SortByEnum.DUE_DATE);
                        break;
                    }
                    case "assignee": {
                        sortOption.setSortBy(HistoricTaskInstanceQueryDtoSortingInner.SortByEnum.ASSIGNEE);
                        break;
                    }
                }
                if (order.getDirection() == Sort.Direction.ASC) {
                    sortOption.setSortOrder(HistoricTaskInstanceQueryDtoSortingInner.SortOrderEnum.ASC);
                    continue;
                }
                if (order.getDirection() != Sort.Direction.DESC) continue;
                sortOption.setSortOrder(HistoricTaskInstanceQueryDtoSortingInner.SortOrderEnum.DESC);
            }
            if (sortOption.getSortBy() != null && sortOption.getSortOrder() != null) {
                taskSortOptions.add(sortOption);
            }
        }
        return taskSortOptions;
    }
}

