/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.service.variable;

import io.openbpm.control.entity.variable.CamundaVariableType;
import io.openbpm.control.entity.variable.VariableInstanceData;
import io.openbpm.control.service.variable.VariableUtils;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Collection;
import java.util.Date;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.springframework.lang.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class VariableUtils {
    private static final DateTimeFormatter DATE_VALUE_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).parseLenient().appendOffset("+HHmm", "").parseStrict().toFormatter();

    public static VariableMap createVariableMap(Collection<VariableInstanceData> variableInstances) {
        VariableMap variables = Variables.createVariables();
        if (variableInstances != null) {
            for (VariableInstanceData variableInstanceData : variableInstances) {
                String variableName = variableInstanceData.getName();
                TypedValue typedValue = VariableUtils.createPrimitiveTypedValue((VariableInstanceData)variableInstanceData);
                if (variableName == null) continue;
                variables.put((Object)variableName, (Object)typedValue);
            }
        }
        return variables;
    }

    public static TypedValue createPrimitiveTypedValue(VariableInstanceData variableInstanceData) {
        Object value = variableInstanceData.getValue();
        CamundaVariableType camundaVariableType = CamundaVariableType.fromId((String)variableInstanceData.getType());
        if (camundaVariableType == null) {
            return Variables.untypedValue((Object)value);
        }
        return switch (1.$SwitchMap$io$openbpm$control$entity$variable$CamundaVariableType[camundaVariableType.ordinal()]) {
            case 1 -> Variables.stringValue((String)((String)value));
            case 2 -> Variables.longValue((Long)((Long)value));
            case 3 -> Variables.shortValue((Short)((Short)value));
            case 4 -> Variables.doubleValue((Double)((Double)value));
            case 5 -> Variables.booleanValue((Boolean)((Boolean)value));
            case 6 -> Variables.integerValue((Integer)((Integer)value));
            case 7 -> Variables.dateValue((Date)((Date)value));
            case 8 -> Variables.untypedNullValue();
            default -> Variables.untypedValue((Object)value);
        };
    }

    @Nullable
    public static Object parseDateValue(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String dateString = (String)value;
            OffsetDateTime dateTime = OffsetDateTime.parse(dateString, DATE_VALUE_FORMATTER);
            return Date.from(dateTime.toInstant());
        }
        return value;
    }
}

