/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.uicomponent;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import io.jmix.flowui.app.datagrid.HeaderPropertyFilterLayout;
import io.jmix.flowui.component.grid.DataGridColumn;
import io.jmix.flowui.component.grid.headerfilter.DataGridHeaderFilter;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.model.InstanceContainer;
import java.io.Serializable;

public abstract class ContainerDataGridHeaderFilter<T, V>
extends DataGridHeaderFilter {
    protected InstanceContainer<T> filterDc;

    public ContainerDataGridHeaderFilter(Grid<V> dataGrid, DataGridColumn<V> column, InstanceContainer<T> filterDc) {
        super(new DataGridHeaderFilter.HeaderFilterContext(dataGrid, column));
        this.filterDc = filterDc;
    }

    protected void initOverlay() {
        Component component = this.createFilterComponent();
        JmixButton resetButton = this.createResetButton();
        JmixButton applyButton = this.createApplyButton();
        JmixButton cancelButton = this.createCancelButton();
        this.initFilterDialog(component, new Component[]{resetButton, applyButton, cancelButton});
    }

    protected abstract Component createFilterComponent();

    protected void initFilterDialog(Component filterDialogContent, Component ... actionComponents) {
        HeaderPropertyFilterLayout headerPropertyFilterLayout = (HeaderPropertyFilterLayout)this.uiComponents.create(HeaderPropertyFilterLayout.class);
        headerPropertyFilterLayout.addClassNames(new String[]{"items-baseline", "w-full"});
        ((HorizontalLayout)headerPropertyFilterLayout.getContent()).add(new Component[]{filterDialogContent});
        this.overlay = new Dialog(new Component[]{headerPropertyFilterLayout});
        this.overlay.addClassName("column-filter-dialog");
        if (!this.isSmallDevice()) {
            this.overlay.addClassName("column-filter-popup");
        } else {
            this.overlay.addClassName("column-filter-footer-small");
        }
        this.overlay.getFooter().add(actionComponents);
        this.overlay.addOpenedChangeListener((ComponentEventListener & Serializable)x$0 -> this.onOpenOverlay(x$0));
        this.overlay.addDialogCloseActionListener((ComponentEventListener & Serializable)x$0 -> this.onOverlayClose(x$0));
    }

    protected JmixButton createResetButton() {
        JmixButton resetButton = (JmixButton)this.uiComponents.create(JmixButton.class);
        resetButton.setIcon((Component)VaadinIcon.ERASER.create());
        resetButton.setText(this.messages.getMessage("actions.Clear"));
        resetButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_ERROR});
        resetButton.addClassNames(new String[]{"mr-auto"});
        resetButton.addClickListener(arg_0 -> this.onResetButtonClick(arg_0));
        return resetButton;
    }

    protected void onResetButtonClick(ClickEvent<Button> buttonClickEvent) {
        this.resetFilterValues();
    }

    protected void resetFilterValues() {
    }
}

