/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.uicomponent.menu;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.ListItem;
import com.vaadin.flow.component.html.Span;
import io.jmix.flowui.component.main.JmixListMenu;
import io.jmix.flowui.kit.component.main.ListMenu;
import io.openbpm.control.uicomponent.menu.ControlListMenu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class ControlListMenu
extends JmixListMenu {
    public static final String MENU_GROUP_LABEL_CLASS = "menu-group-label";
    private static final Logger log = LoggerFactory.getLogger(ControlListMenu.class);

    public void addMenuItemBefore(ListMenu.MenuItem menuItem, String beforeMenuItemId) {
        ListMenu.MenuItem existingMenuItem = this.getExistingMenu(beforeMenuItemId);
        if (existingMenuItem != null) {
            int prevItemIdx = this.rootMenuItems.indexOf(existingMenuItem);
            if (prevItemIdx != -1) {
                this.addMenuItem(menuItem, prevItemIdx);
            } else {
                this.addMenuItem(menuItem);
            }
        }
    }

    public void addMenuItemAfter(ListMenu.MenuItem menuItem, String afterMenuItemId) {
        ListMenu.MenuItem existingMenuItem = this.getExistingMenu(afterMenuItemId);
        if (existingMenuItem != null) {
            int nextItemIdx = this.rootMenuItems.indexOf(existingMenuItem);
            if (nextItemIdx == this.rootMenuItems.size() - 1) {
                this.addMenuItem(menuItem);
            } else {
                this.addMenuItem(menuItem, nextItemIdx + 1);
            }
        }
    }

    protected ListItem createMenuRecursively(ListMenu.MenuItem menuItem) {
        if (menuItem instanceof GroupLabelMenuItem) {
            this.checkItemIdDuplicate(menuItem.getId());
            Span groupLabel = new Span(menuItem.getTitle());
            groupLabel.addClassNames(new String[]{MENU_GROUP_LABEL_CLASS});
            ListItem menuItemComponent = new ListItem(new Component[]{groupLabel});
            this.registerMenuItem(menuItem, menuItemComponent);
            return menuItemComponent;
        }
        return super.createMenuRecursively(menuItem);
    }

    @Nullable
    protected ListMenu.MenuItem getExistingMenu(String menuId) {
        ListMenu.MenuItem existingMenuItem = this.getMenuItem(menuId);
        if (existingMenuItem == null) {
            log.warn("Menu item  not found by id '{}'", (Object)menuId);
        }
        return existingMenuItem;
    }
}

