/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view;

import com.vaadin.flow.component.ComponentEventListener;
import io.jmix.core.DataManager;
import io.jmix.core.Messages;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.StandardView;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.openbpm.control.entity.deployment.ResourceDeploymentReport;
import io.openbpm.control.entity.deployment.ResourceValidationError;
import io.openbpm.control.entity.deployment.ValidationErrorType;
import io.openbpm.control.restsupport.camunda.ResourceReport;
import io.openbpm.control.view.deploymenterror.DeploymentErrorDialogView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractResourceDeploymentView
extends StandardView {
    @ViewComponent
    protected InstanceContainer<ResourceDeploymentReport> deploymentReportDc;
    @Autowired
    protected Messages messages;
    @Autowired
    protected DataManager dataManager;
    @Autowired
    protected DialogWindows dialogWindows;
    @ViewComponent
    protected JmixButton errorsBtn;

    protected void initDeploymentErrorsButton() {
        this.errorsBtn.addClickListener((ComponentEventListener & Serializable)event -> this.openValidationErrorDialogsView());
    }

    protected void handleResourceReport(ResourceReport resourceReport, String uploadedFileName) {
        if (resourceReport != null) {
            ResourceDeploymentReport deploymentReport = this.createResourceReport(resourceReport, uploadedFileName);
            this.deploymentReportDc.setItem((Object)deploymentReport);
        }
        this.openValidationErrorDialogsView();
        this.updateErrorButtonText();
    }

    protected void updateErrorButtonText() {
        ResourceDeploymentReport report = (ResourceDeploymentReport)this.deploymentReportDc.getItem();
        int size = CollectionUtils.size((Object)report.getValidationErrors());
        this.errorsBtn.setVisible(true);
        String sizeText = size > 99 ? "99+" : String.valueOf(size);
        String errorBtnText = this.messages.formatMessage(AbstractResourceDeploymentView.class, "deploymentErrorsBtn.text", new Object[]{sizeText});
        this.errorsBtn.setText(errorBtnText);
    }

    protected ResourceDeploymentReport createResourceReport(ResourceReport report, String uploadedFileName) {
        ResourceDeploymentReport deploymentReport = (ResourceDeploymentReport)this.dataManager.create(ResourceDeploymentReport.class);
        deploymentReport.setFilename(uploadedFileName);
        ArrayList errors = new ArrayList();
        this.addValidationErrors(report.getErrors(), ValidationErrorType.ERROR, errors);
        this.addValidationErrors(report.getWarnings(), ValidationErrorType.WARNING, errors);
        deploymentReport.setValidationErrors(errors);
        return deploymentReport;
    }

    protected void openValidationErrorDialogsView() {
        this.dialogWindows.view((View)this, DeploymentErrorDialogView.class).withViewConfigurer(deploymentErrorDialogView -> deploymentErrorDialogView.setResourceReport((ResourceDeploymentReport)this.deploymentReportDc.getItem())).open();
    }

    protected void addValidationErrors(List<ResourceReport.ProblemDetails> problemDetailsList, ValidationErrorType warning, List<ResourceValidationError> result) {
        if (problemDetailsList != null) {
            problemDetailsList.forEach(problemDetails -> {
                ResourceValidationError resourceValidationError = this.createValidationError(warning, problemDetails);
                result.add(resourceValidationError);
            });
        }
    }

    protected ResourceValidationError createValidationError(ValidationErrorType error, ResourceReport.ProblemDetails problemDetails) {
        ResourceValidationError resourceValidationError = (ResourceValidationError)this.dataManager.create(ResourceValidationError.class);
        resourceValidationError.setType(error);
        resourceValidationError.setMessage(problemDetails.getMessage());
        resourceValidationError.setColumn(problemDetails.getColumn());
        resourceValidationError.setMainElementId(problemDetails.getMainElementId());
        resourceValidationError.setLine(problemDetails.getLine());
        return resourceValidationError;
    }
}

