/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.about;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.html.Hr;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.router.Route;
import io.jmix.core.Messages;
import io.jmix.core.Resources;
import io.jmix.core.security.CurrentAuthentication;
import io.jmix.flowui.Fragments;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.UiComponents;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.fragment.FragmentOwner;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.view.StandardView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.openbpm.control.action.CopyComponentValueToClipboardAction;
import io.openbpm.control.view.about.AboutProductMetadata;
import io.openbpm.control.view.about.ExternalLinkFragment;
import io.openbpm.control.view.about.ProductInfoFragment;
import io.openbpm.control.view.main.MainView;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.info.BuildProperties;

@Route(value="about", layout=MainView.class)
@ViewController(id="AboutProductView")
@ViewDescriptor(path="about-product-view.xml")
public class AboutProductView
extends StandardView {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AboutProductView.class);
    protected static final String APPLICATION_NAME = "OpenBPM Control";
    protected static final String RESOURCES_PATH = "/META-INF/resources/etc/";
    protected static final String DEFAULT_METADATA_FILE_PATH = "/META-INF/resources/etc/about-product-metadata.json";
    protected static final String METADATA_FILE_PATH_TEMPLATE = "/META-INF/resources/etc/about-product-metadata-%s.json";
    @Autowired
    protected Resources resources;
    @Autowired
    protected CurrentAuthentication currentAuthentication;
    @Autowired
    protected ObjectMapper objectMapper;
    @Autowired
    protected Notifications notifications;
    @Autowired
    protected Messages messages;
    @Autowired
    protected BuildProperties buildProperties;
    @Autowired
    protected Fragments fragments;
    @ViewComponent
    protected Span productText;
    @ViewComponent
    protected Span versionText;
    @ViewComponent
    protected Span buildText;
    @ViewComponent
    protected VerticalLayout externalLinksBox;
    @ViewComponent
    protected VerticalLayout productsBox;
    @Autowired
    private UiComponents uiComponents;

    @Subscribe
    protected void onBeforeShow(View.BeforeShowEvent event) {
        this.productText.setText(APPLICATION_NAME);
        this.versionText.setText(this.buildProperties.getVersion());
        this.buildText.setText(this.buildProperties.get("buildType"));
        AboutProductMetadata contentMetadata = this.loadContentMetadata();
        if (contentMetadata != null) {
            this.initExternalLinks(contentMetadata.getExternalLinks());
            this.initProducts(contentMetadata.getProducts());
        }
    }

    protected void initProducts(List<AboutProductMetadata.Product> products) {
        this.productsBox.removeAll();
        H3 productsHeader = (H3)this.uiComponents.create(H3.class);
        productsHeader.setText(this.messages.getMessage(this.getClass(), "ourProductsHeader.text"));
        this.productsBox.add(new Component[]{productsHeader});
        if (CollectionUtils.isNotEmpty(products)) {
            for (int i = 0; i < products.size(); ++i) {
                AboutProductMetadata.Product product = products.get(i);
                ProductInfoFragment productInfoFragment = (ProductInfoFragment)this.fragments.create((FragmentOwner)this, ProductInfoFragment.class);
                productInfoFragment.setProduct(product);
                this.productsBox.add(new Component[]{productInfoFragment});
                if (i >= products.size() - 1) continue;
                this.productsBox.add(new Component[]{new Hr()});
            }
        }
    }

    protected void initExternalLinks(List<AboutProductMetadata.ExternalLink> externalLinksList) {
        this.externalLinksBox.removeAll();
        H3 externalLinkHeader = (H3)this.uiComponents.create(H3.class);
        externalLinkHeader.setText(this.messages.getMessage(this.getClass(), "externalLinksHeader.text"));
        this.externalLinksBox.add(new Component[]{externalLinkHeader});
        if (CollectionUtils.isNotEmpty(externalLinksList)) {
            externalLinksList.forEach(externalLink -> {
                ExternalLinkFragment externalLinkFragment = (ExternalLinkFragment)this.fragments.create((FragmentOwner)this, ExternalLinkFragment.class);
                externalLinkFragment.setLink(externalLink.getLabel(), externalLink.getUrl());
                this.externalLinksBox.add(new Component[]{externalLinkFragment});
            });
        }
    }

    @Nullable
    protected AboutProductMetadata loadContentMetadata() {
        Locale locale = this.currentAuthentication.getLocale();
        String contentMetadata = this.resources.getResourceAsString(METADATA_FILE_PATH_TEMPLATE.formatted(locale.getLanguage()));
        if (contentMetadata == null) {
            contentMetadata = this.resources.getResourceAsString(DEFAULT_METADATA_FILE_PATH);
        }
        if (contentMetadata != null) {
            try {
                return (AboutProductMetadata)this.objectMapper.readValue(contentMetadata, AboutProductMetadata.class);
            }
            catch (JsonProcessingException e) {
                log.error("Unable to read content metadata with locale '{}'", (Object)locale, (Object)e);
            }
        }
        return null;
    }

    @Subscribe(id="copyProductBtn", subject="clickListener")
    protected void onCopyProductBtnClick(ClickEvent<JmixButton> event) {
        String productValue = "%s %s (%s)".formatted(this.productText.getText(), this.versionText.getText(), this.buildText.getText());
        UiComponentUtils.copyToClipboard((String)productValue).then((SerializableConsumer & Serializable)successResult -> this.notifications.create(this.messages.getMessage(CopyComponentValueToClipboardAction.class, "copyComponentValueAction.copied")).withPosition(Notification.Position.TOP_END).withThemeVariant(NotificationVariant.LUMO_SUCCESS).show(), (SerializableConsumer & Serializable)errorResult -> this.notifications.create(this.messages.getMessage(CopyComponentValueToClipboardAction.class, "copyComponentValueAction.copyFailed")).withPosition(Notification.Position.TOP_END).withThemeVariant(NotificationVariant.LUMO_ERROR).show());
    }
}

