/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.alltasks;

import com.google.common.collect.ImmutableMap;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.html.H5;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.Route;
import io.jmix.core.DataLoadContext;
import io.jmix.core.LoadContext;
import io.jmix.core.Messages;
import io.jmix.core.Metadata;
import io.jmix.core.entity.EntityValues;
import io.jmix.core.metamodel.model.MetaClass;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.UiComponents;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.component.combobox.JmixComboBox;
import io.jmix.flowui.component.datetimepicker.TypedDateTimePicker;
import io.jmix.flowui.component.details.JmixDetails;
import io.jmix.flowui.component.formlayout.JmixFormLayout;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.component.radiobuttongroup.JmixRadioButtonGroup;
import io.jmix.flowui.component.textfield.TypedTextField;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.kit.component.ComponentUtils;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.model.CollectionContainer;
import io.jmix.flowui.model.CollectionLoader;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.DefaultMainViewParent;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.LookupComponent;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardListView;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Supply;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.openbpm.control.entity.UserTaskData;
import io.openbpm.control.entity.filter.ProcessDefinitionFilter;
import io.openbpm.control.entity.filter.UserTaskFilter;
import io.openbpm.control.entity.processdefinition.ProcessDefinitionData;
import io.openbpm.control.service.processdefinition.ProcessDefinitionLoadContext;
import io.openbpm.control.service.processdefinition.ProcessDefinitionService;
import io.openbpm.control.service.usertask.UserTaskLoadContext;
import io.openbpm.control.service.usertask.UserTaskService;
import io.openbpm.control.view.alltasks.AllTasksView;
import io.openbpm.control.view.alltasks.UserTaskStateFilterOption;
import io.openbpm.control.view.bulktaskcomplete.BulkTaskCompleteView;
import io.openbpm.control.view.taskreassign.TaskReassignView;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="bpm/user-tasks", layout=DefaultMainViewParent.class)
@ViewController(value="bpm_AllTasksView")
@ViewDescriptor(value="all-tasks-view.xml")
@LookupComponent(value="tasksDataGrid")
public class AllTasksView
extends StandardListView<UserTaskData> {
    protected static final String ASSIGNED_OPTION = "assigned";
    protected static final String UNASSIGNED_OPTION = "unassigned";
    @Autowired
    protected Metadata metadata;
    @ViewComponent
    protected MessageBundle messageBundle;
    @Autowired
    protected UserTaskService userTaskService;
    @Autowired
    protected ViewNavigators viewNavigators;
    @Autowired
    protected DialogWindows dialogWindows;
    @ViewComponent
    protected CollectionContainer<UserTaskData> tasksDc;
    @ViewComponent
    protected CollectionLoader<UserTaskData> tasksDl;
    @ViewComponent
    protected InstanceContainer<UserTaskFilter> userTaskFilterDc;
    @Autowired
    protected ProcessDefinitionService processDefinitionService;
    @ViewComponent
    protected JmixFormLayout filterFormLayout;
    @ViewComponent
    protected JmixComboBox<ProcessDefinitionData> processDefinitionLookup;
    @ViewComponent
    protected DataGrid<UserTaskData> tasksDataGrid;
    @ViewComponent
    protected FlexLayout filterContainer;
    @ViewComponent
    protected JmixButton filterBtn;
    @ViewComponent
    protected Span appliedFiltersCount;
    @Autowired
    protected UiComponents uiComponents;
    @Autowired
    protected Messages messages;
    @ViewComponent
    protected JmixDetails assignmentFilters;
    @ViewComponent
    protected JmixDetails creationDateFilters;
    @ViewComponent
    protected JmixDetails generalFilters;
    @ViewComponent
    protected JmixRadioButtonGroup<Object> assignmentTypeGroup;
    @ViewComponent
    protected TypedDateTimePicker<OffsetDateTime> createdBeforeField;
    @ViewComponent
    protected TypedDateTimePicker<OffsetDateTime> createdAfterField;
    @ViewComponent
    protected TypedTextField<String> assigneeField;
    protected Map<String, ProcessDefinitionData> processDefinitionsMap = new HashMap();
    @ViewComponent
    protected JmixRadioButtonGroup<UserTaskStateFilterOption> stateTypeGroup;

    @Subscribe
    protected void onInit(View.InitEvent initEvent) {
        this.addClassNames(new String[]{"pt-s"});
        this.initFilterFormStyles();
        this.initFilter();
        this.setDefaultSort();
        this.createdBeforeField.getElement().executeJs("this.__datePicker.addEventListener('change', function(){this.__timePicker.value='00:00';}.bind(this));", new Serializable[0]);
        this.createdAfterField.getElement().executeJs("this.__datePicker.addEventListener('change', function(){this.__timePicker.value='00:00';}.bind(this));", new Serializable[0]);
        this.addDetailsSummary(this.generalFilters, "generalFilterGroup");
        this.addDetailsSummary(this.assignmentFilters, "assignmentFilterGroup");
        this.addDetailsSummary(this.creationDateFilters, "createDateFilterGroup");
    }

    @Subscribe
    public void onBeforeShow(View.BeforeShowEvent event) {
        ImmutableMap assignmentTypesMap = ImmutableMap.of((Object)ASSIGNED_OPTION, (Object)this.messages.getMessage(UserTaskFilter.class, "UserTaskFilter.assigned"), (Object)UNASSIGNED_OPTION, (Object)this.messages.getMessage(UserTaskFilter.class, "UserTaskFilter.unassigned"));
        ComponentUtils.setItemsMap((RadioButtonGroup)this.assignmentTypeGroup, (Map)assignmentTypesMap);
        this.stateTypeGroup.setItems(UserTaskStateFilterOption.class);
        this.stateTypeGroup.setValue((Object)UserTaskStateFilterOption.ALL);
    }

    @Install(to="processDefinitionLookup", subject="itemsFetchCallback")
    protected Stream<ProcessDefinitionData> processDefinitionLookupItemsFetchCallback(Query<ProcessDefinitionData, String> query) {
        ProcessDefinitionFilter filter = (ProcessDefinitionFilter)this.metadata.create(ProcessDefinitionFilter.class);
        filter.setKeyLike((String)query.getFilter().orElse(null));
        filter.setLatestVersionOnly(Boolean.valueOf(true));
        ProcessDefinitionLoadContext context = new ProcessDefinitionLoadContext().setFilter(filter).setMaxResults(Integer.valueOf(query.getLimit())).setFirstResult(Integer.valueOf(query.getOffset()));
        return this.processDefinitionService.findAll(context).stream();
    }

    @Install(to="processDefinitionLookup", subject="itemLabelGenerator")
    protected String processDefinitionLookupItemLabelGenerator(ProcessDefinitionData item) {
        return item.getKey();
    }

    @Subscribe(value="processDefinitionLookup")
    public void onProcessDefinitionLookupComponentValueChange(AbstractField.ComponentValueChangeEvent<JmixComboBox<ProcessDefinitionData>, ProcessDefinitionData> event) {
        ProcessDefinitionData value = (ProcessDefinitionData)event.getValue();
        String key = value != null ? value.getKey() : null;
        ((UserTaskFilter)this.userTaskFilterDc.getItem()).setProcessDefinitionKey(key);
        this.tasksDl.load();
    }

    @Subscribe(id="userTaskFilterDc", target=Target.DATA_CONTAINER)
    public void onUserTaskFilterDcItemPropertyChange(InstanceContainer.ItemPropertyChangeEvent<UserTaskFilter> event) {
        boolean notStateFilter;
        String property = event.getProperty();
        boolean notAssignmentFilter = !property.equals(ASSIGNED_OPTION) && !property.equals(UNASSIGNED_OPTION);
        boolean bl = notStateFilter = !property.equals("active") && !property.equals("suspended");
        if (notAssignmentFilter && notStateFilter) {
            this.tasksDl.load();
        }
    }

    @Install(to="tasksDataGrid.completeTask", subject="enabledRule")
    protected boolean tasksDataGridCompleteTaskEnabledRule() {
        Set selectedItems = this.tasksDataGrid.getSelectedItems();
        boolean suspendedTaskSelected = selectedItems.stream().anyMatch(userTaskData -> BooleanUtils.isTrue((Boolean)userTaskData.getSuspended()));
        return !selectedItems.isEmpty() && !suspendedTaskSelected;
    }

    @Install(to="tasksDataGrid.reassignTask", subject="enabledRule")
    protected boolean tasksDataGridReassignTaskEnabledRule() {
        Set selectedItems = this.tasksDataGrid.getSelectedItems();
        boolean suspendedTaskSelected = selectedItems.stream().anyMatch(userTaskData -> BooleanUtils.isTrue((Boolean)userTaskData.getSuspended()));
        return !selectedItems.isEmpty() && !suspendedTaskSelected;
    }

    @Subscribe(value="tasksDataGrid.reassignTask")
    protected void onTasksDataGridReassignTaskActionPerformed(ActionPerformedEvent event) {
        this.dialogWindows.view((View)this, TaskReassignView.class).withAfterCloseListener(closeEvent -> {
            if (closeEvent.closedWith(StandardOutcome.SAVE)) {
                this.tasksDl.load();
            }
        }).withViewConfigurer(taskReassignView -> taskReassignView.setTaskDataList((Collection)this.tasksDataGrid.getSelectedItems())).build().open();
    }

    @Subscribe(value="tasksDataGrid.completeTask")
    public void onTasksDataGridCompleteTask(ActionPerformedEvent event) {
        this.dialogWindows.view((View)this, BulkTaskCompleteView.class).withViewConfigurer(bulkTaskCompleteView -> bulkTaskCompleteView.setUserTasks((Collection)this.tasksDataGrid.getSelectedItems())).withAfterCloseListener(closeEvent -> {
            if (closeEvent.closedWith(StandardOutcome.SAVE)) {
                this.tasksDl.load();
            }
        }).build().open();
    }

    @Subscribe(value="applyFilter")
    protected void onApplyFilterActionPerformed(ActionPerformedEvent event) {
        this.tasksDl.load();
    }

    @Subscribe(id="tasksDl", target=Target.DATA_LOADER)
    public void onTasksDlPostLoad(CollectionLoader.PostLoadEvent<UserTaskData> event) {
        this.updateAppliedFiltersCount();
    }

    @Install(to="tasksDl", target=Target.DATA_LOADER)
    protected List<UserTaskData> tasksDlLoadDelegate(LoadContext<UserTaskData> loadContext) {
        LoadContext.Query query = loadContext.getQuery();
        UserTaskLoadContext context = new UserTaskLoadContext().setFilter((UserTaskFilter)this.userTaskFilterDc.getItem());
        if (query != null) {
            context.setFirstResult(Integer.valueOf(query.getFirstResult())).setMaxResults(Integer.valueOf(query.getMaxResults())).setSort(query.getSort());
        }
        List runtimeTasks = this.userTaskService.findRuntimeTasks(context);
        this.loadProcessDefinitions(runtimeTasks);
        return runtimeTasks;
    }

    @Install(to="tasksPagination", subject="totalCountDelegate")
    protected Integer tasksPaginationTotalCountDelegate(DataLoadContext loadContext) {
        return (int)this.userTaskService.getRuntimeTasksCount((UserTaskFilter)this.userTaskFilterDc.getItem());
    }

    @Subscribe(id="filterBtn", subject="clickListener")
    public void onFilterBtnClick(ClickEvent<JmixButton> event) {
        this.filterContainer.setVisible(!this.filterContainer.isVisible());
        if (this.filterContainer.isVisible()) {
            this.filterBtn.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        } else {
            this.filterBtn.removeThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        }
    }

    @Subscribe(id="clearBtn", subject="clickListener")
    public void onClearBtnClick(ClickEvent<JmixButton> event) {
        this.processDefinitionLookup.setValue(null);
        this.assignmentTypeGroup.setValue(null);
        this.assignmentTypeGroup.setEnabled(true);
        this.stateTypeGroup.setValue(null);
        UserTaskFilter userTaskFilter = (UserTaskFilter)this.metadata.create(UserTaskFilter.class);
        this.userTaskFilterDc.setItem((Object)userTaskFilter);
        this.tasksDl.load();
    }

    @Install(to="tasksDataGrid.name", subject="tooltipGenerator")
    protected String tasksDataGridNameTooltipGenerator(UserTaskData userTaskData) {
        return userTaskData.getName();
    }

    @Install(to="tasksDataGrid.taskDefinitionKey", subject="tooltipGenerator")
    protected String tasksDataGridTaskDefinitionKeyTooltipGenerator(UserTaskData userTaskData) {
        return userTaskData.getTaskDefinitionKey();
    }

    @Subscribe(value="assignmentTypeGroup")
    public void onAssignmentTypeGroupComponentValueChange(AbstractField.ComponentValueChangeEvent<JmixRadioButtonGroup<String>, String> event) {
        String value = (String)event.getValue();
        if (value == null) {
            this.assigneeField.setEnabled(true);
            ((UserTaskFilter)this.userTaskFilterDc.getItem()).setUnassigned(null);
            ((UserTaskFilter)this.userTaskFilterDc.getItem()).setAssigned(null);
        } else if (ASSIGNED_OPTION.equals(value)) {
            this.assigneeField.setEnabled(true);
            ((UserTaskFilter)this.userTaskFilterDc.getItem()).setUnassigned(null);
            ((UserTaskFilter)this.userTaskFilterDc.getItem()).setAssigned(Boolean.valueOf(true));
        } else if (UNASSIGNED_OPTION.equals(value)) {
            ((UserTaskFilter)this.userTaskFilterDc.getItem()).setUnassigned(Boolean.valueOf(true));
            ((UserTaskFilter)this.userTaskFilterDc.getItem()).setAssigned(null);
            ((UserTaskFilter)this.userTaskFilterDc.getItem()).setAssigneeLike(null);
            this.assigneeField.setEnabled(false);
        }
        this.tasksDl.load();
    }

    @Subscribe(value="stateTypeGroup")
    protected void onStateTypeGroupComponentValueChange(AbstractField.ComponentValueChangeEvent<JmixRadioButtonGroup<UserTaskStateFilterOption>, UserTaskStateFilterOption> event) {
        UserTaskStateFilterOption option = (UserTaskStateFilterOption)event.getValue();
        if (option == null) {
            this.setAllStatesFilter();
        }
        switch (1.$SwitchMap$io$openbpm$control$view$alltasks$UserTaskStateFilterOption[option.ordinal()]) {
            case 1: {
                this.setAllStatesFilter();
                break;
            }
            case 2: {
                this.setActiveTasksFilter();
                break;
            }
            case 3: {
                this.setSuspendedTasksFilter();
            }
        }
        if (event.isFromClient()) {
            this.tasksDl.load();
        }
    }

    @Supply(to="tasksDataGrid.processDefinitionId", subject="renderer")
    protected Renderer<UserTaskData> tasksDataGridProcessDefinitionIdRenderer() {
        return new TextRenderer(arg_0 -> this.getFormattedProcess(arg_0));
    }

    @Install(to="tasksDataGrid.processDefinitionId", subject="tooltipGenerator")
    protected String tasksDataGridProcessDefinitionIdTooltipGenerator(UserTaskData userTaskData) {
        return this.getFormattedProcess(userTaskData);
    }

    @Supply(to="tasksDataGrid.actions", subject="renderer")
    protected Renderer<UserTaskData> tasksDataGridActionsRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)userTaskData -> {
            JmixButton viewButton = (JmixButton)this.uiComponents.create(JmixButton.class);
            viewButton.setText(this.messages.getMessage("actions.View"));
            viewButton.setIcon((Component)VaadinIcon.EYE.create());
            viewButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE});
            viewButton.addClassNames(new String[]{"pt-xs", "pb-xs"});
            viewButton.addClickListener((ComponentEventListener & Serializable)event -> this.dialogWindows.detail((View)this, UserTaskData.class).editEntity(userTaskData).build().open());
            return viewButton;
        });
    }

    protected void setSuspendedTasksFilter() {
        ((UserTaskFilter)this.userTaskFilterDc.getItem()).setSuspended(Boolean.valueOf(true));
        ((UserTaskFilter)this.userTaskFilterDc.getItem()).setActive(null);
    }

    protected void setActiveTasksFilter() {
        ((UserTaskFilter)this.userTaskFilterDc.getItem()).setSuspended(null);
        ((UserTaskFilter)this.userTaskFilterDc.getItem()).setActive(Boolean.valueOf(true));
    }

    protected void setAllStatesFilter() {
        ((UserTaskFilter)this.userTaskFilterDc.getItem()).setSuspended(null);
        ((UserTaskFilter)this.userTaskFilterDc.getItem()).setActive(null);
    }

    protected void loadProcessDefinitions(List<UserTaskData> runtimeTasks) {
        List<String> idsToLoad = runtimeTasks.stream().map(UserTaskData::getProcessDefinitionId).filter(processDefinitionId -> !this.processDefinitionsMap.containsKey(processDefinitionId)).distinct().toList();
        ProcessDefinitionFilter filter = (ProcessDefinitionFilter)this.metadata.create(ProcessDefinitionFilter.class);
        filter.setIdIn(idsToLoad);
        List definitions = this.processDefinitionService.findAll(new ProcessDefinitionLoadContext().setFilter(filter));
        definitions.forEach(processDefinitionData -> this.processDefinitionsMap.put(processDefinitionData.getProcessDefinitionId(), processDefinitionData));
    }

    protected void addDetailsSummary(JmixDetails details, String messageKey) {
        H5 summary = (H5)this.uiComponents.create(H5.class);
        summary.setText(this.messageBundle.getMessage(messageKey));
        details.setSummary((Component)summary);
    }

    protected void initFilter() {
        UserTaskFilter userTaskFilter = (UserTaskFilter)this.metadata.create(UserTaskFilter.class);
        this.userTaskFilterDc.setItem((Object)userTaskFilter);
    }

    protected void initFilterFormStyles() {
        this.filterFormLayout.getOwnComponents().forEach(component -> component.addClassName("pt-xs"));
        this.filterFormLayout.addClassNames(new String[]{"flex-grow"});
    }

    protected void updateAppliedFiltersCount() {
        MetaClass metaClass = this.metadata.getClass(UserTaskFilter.class);
        long filtersCount = metaClass.getOwnProperties().stream().filter(metaProperty -> {
            boolean notEmptyValue;
            Object value = EntityValues.getValue((Object)this.userTaskFilterDc.getItem(), (String)metaProperty.getName());
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                notEmptyValue = CollectionUtils.isNotEmpty((Collection)collection);
            } else if (value instanceof String) {
                String s = (String)value;
                notEmptyValue = StringUtils.isNotEmpty((CharSequence)s);
            } else {
                notEmptyValue = value != null;
            }
            return notEmptyValue && !metaProperty.getName().equals("id");
        }).count();
        if (filtersCount > 0L) {
            this.appliedFiltersCount.setVisible(true);
            this.appliedFiltersCount.setText(String.valueOf(filtersCount));
        } else {
            this.appliedFiltersCount.setVisible(false);
        }
    }

    protected String getFormattedProcess(UserTaskData userTaskData) {
        ProcessDefinitionData processDefinitionData = this.processDefinitionsMap.computeIfAbsent(userTaskData.getProcessDefinitionId(), processDefinitionId -> this.processDefinitionService.getById(processDefinitionId));
        return this.messages.formatMessage("", "common.processDefinitionKeyAndVersion", new Object[]{processDefinitionData.getKey(), processDefinitionData.getVersion()});
    }

    protected void setDefaultSort() {
        List<GridSortOrder> gridSortOrders = Collections.singletonList(new GridSortOrder((Grid.Column)this.tasksDataGrid.getColumnByKey("createTime"), SortDirection.DESCENDING));
        this.tasksDataGrid.sort(gridSortOrders);
    }
}

