/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.dashboard;

import com.vaadin.flow.component.Component;
import io.jmix.core.Messages;
import io.jmix.core.security.CurrentAuthentication;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.fragment.Fragment;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.ViewComponent;
import io.openbpm.control.entity.engine.BpmEngine;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class DashboardCard<V extends Component>
extends Fragment<V> {
    public static final String SKELETON_BACKGROUND = "skeleton-background";
    @ViewComponent
    protected MessageBundle messageBundle;
    @Autowired
    protected CurrentAuthentication currentAuthentication;
    @Autowired
    protected Messages messages;
    @Autowired
    protected ViewNavigators viewNavigators;
    @ViewComponent
    protected InstanceContainer<BpmEngine> selectedEngineDc;

    public void setLoading() {
        this.updateComponents(true);
    }

    protected abstract void updateComponents(boolean var1);

    protected String formattedCount(long totalCount) {
        if (totalCount < 1000L) {
            return String.valueOf(totalCount);
        }
        double thousands = (double)totalCount / 1000.0;
        DecimalFormat decimalFormat = new DecimalFormat(this.messages.getMessage("thousandsFormat"));
        decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(this.currentAuthentication.getLocale()));
        return this.messageBundle.formatMessage("formattedTotalCount", new Object[]{decimalFormat.format(thousands)});
    }
}

