/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.decisiondefinition;

import com.google.common.base.Strings;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.Route;
import io.jmix.core.DataLoadContext;
import io.jmix.core.LoadContext;
import io.jmix.core.Metadata;
import io.jmix.flowui.Fragments;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.component.checkbox.JmixCheckbox;
import io.jmix.flowui.component.formlayout.JmixFormLayout;
import io.jmix.flowui.component.textfield.TypedTextField;
import io.jmix.flowui.fragment.FragmentOwner;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.model.CollectionLoader;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.StandardListView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Supply;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.openbpm.control.entity.decisiondefinition.DecisionDefinitionData;
import io.openbpm.control.entity.filter.DecisionDefinitionFilter;
import io.openbpm.control.service.decisiondefinition.DecisionDefinitionLoadContext;
import io.openbpm.control.service.decisiondefinition.DecisionDefinitionService;
import io.openbpm.control.view.decisiondefinition.DecisionDefinitionListItemActionsFragment;
import io.openbpm.control.view.decisiondeployment.DecisionDeploymentView;
import io.openbpm.control.view.main.MainView;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="bpmn/decision-definitions", layout=MainView.class)
@ViewController(id="bpm_DecisionDefinition.list")
@ViewDescriptor(value="decision-definition-list-view.xml")
public class DecisionDefinitionListView
extends StandardListView<DecisionDefinitionData> {
    @Autowired
    private Metadata metadata;
    @Autowired
    private DecisionDefinitionService decisionDefinitionService;
    @Autowired
    private ViewNavigators viewNavigators;
    @Autowired
    private Fragments fragments;
    @ViewComponent
    private InstanceContainer<DecisionDefinitionFilter> decisionDefinitionFilterDc;
    @ViewComponent
    private JmixFormLayout filterFormLayout;
    @ViewComponent
    private HorizontalLayout filterPanel;
    @ViewComponent
    private CollectionLoader<DecisionDefinitionData> decisionDefinitionsDl;
    @ViewComponent
    private TypedTextField<String> nameField;
    @ViewComponent
    private JmixCheckbox lastVersionOnlyCb;

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.addClassNames(new String[]{"pt-s"});
        this.initFilterFormStyles();
    }

    @Subscribe
    public void onBeforeShow(View.BeforeShowEvent event) {
        this.initFilter();
        this.decisionDefinitionsDl.load();
    }

    @Subscribe(id="clearBtn", subject="clickListener")
    public void onClearBtnClick(ClickEvent<JmixButton> event) {
        DecisionDefinitionFilter filter = (DecisionDefinitionFilter)this.decisionDefinitionFilterDc.getItem();
        filter.setKeyLike(null);
        filter.setNameLike(null);
        filter.setLatestVersionOnly(Boolean.valueOf(true));
    }

    @Subscribe(id="decisionDefinitionFilterDc", target=Target.DATA_CONTAINER)
    public void onDecisionDefinitionFilterDcItemPropertyChange(InstanceContainer.ItemPropertyChangeEvent<DecisionDefinitionFilter> event) {
        if (((Boolean)this.lastVersionOnlyCb.getValue()).booleanValue() && !Strings.isNullOrEmpty((String)this.nameField.getValue())) {
            return;
        }
        this.decisionDefinitionsDl.load();
    }

    @Subscribe(value="nameField")
    public void onNameFieldComponentValueChange(AbstractField.ComponentValueChangeEvent<TypedTextField<String>, String> event) {
        boolean nameEmpty = Strings.isNullOrEmpty((String)this.nameField.getValue());
        if (!nameEmpty) {
            this.lastVersionOnlyCb.setValue(Boolean.valueOf(false));
        }
        this.lastVersionOnlyCb.setReadOnly(!nameEmpty);
    }

    @Subscribe(value="decisionDefinitionsGrid.deploy")
    protected void onDecisionDefinitionsGridDeploy(ActionPerformedEvent event) {
        this.viewNavigators.view((View)this, DecisionDeploymentView.class).withBackwardNavigation(true).navigate();
    }

    protected void initFilter() {
        DecisionDefinitionFilter filter = (DecisionDefinitionFilter)this.metadata.create(DecisionDefinitionFilter.class);
        filter.setLatestVersionOnly(Boolean.valueOf(true));
        this.decisionDefinitionFilterDc.setItem((Object)filter);
    }

    protected void initFilterFormStyles() {
        this.filterFormLayout.getOwnComponents().forEach(c -> c.addClassName("pt-xs"));
        this.filterPanel.addClassNames(new String[]{"pt-xs", "pl-m", "pb-xs", "pr-m", "border", "rounded-l", "border-contrast-20"});
    }

    @Install(to="decisionDefinitionPagination", subject="totalCountDelegate")
    protected Integer decisionDefinitionPaginationTotalCountDelegate(DataLoadContext dataLoadContext) {
        return (int)this.decisionDefinitionService.getCount((DecisionDefinitionFilter)this.decisionDefinitionFilterDc.getItemOrNull());
    }

    @Install(to="decisionDefinitionsDl", target=Target.DATA_LOADER)
    protected List<DecisionDefinitionData> decisionDefinitionsDlLoadDelegate(LoadContext<DecisionDefinitionData> loadContext) {
        LoadContext.Query query = loadContext.getQuery();
        DecisionDefinitionFilter filter = (DecisionDefinitionFilter)this.decisionDefinitionFilterDc.getItemOrNull();
        DecisionDefinitionLoadContext context = new DecisionDefinitionLoadContext().setFilter(filter);
        if (query != null) {
            context = context.setFirstResult(Integer.valueOf(query.getFirstResult())).setMaxResults(Integer.valueOf(query.getMaxResults())).setSort(query.getSort());
        }
        return this.decisionDefinitionService.findAll(context);
    }

    @Supply(to="decisionDefinitionsGrid.actions", subject="renderer")
    private Renderer<DecisionDefinitionData> decisionDefinitionsGridActionsRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)decisiondefinitiondata -> {
            DecisionDefinitionListItemActionsFragment fragment = (DecisionDefinitionListItemActionsFragment)this.fragments.create((FragmentOwner)this, DecisionDefinitionListItemActionsFragment.class);
            fragment.setDecisionDefinition(decisiondefinitiondata);
            return fragment;
        });
    }
}

