/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.decisioninstance;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.RouteParameters;
import io.jmix.core.DataLoadContext;
import io.jmix.core.LoadContext;
import io.jmix.core.Messages;
import io.jmix.core.Metadata;
import io.jmix.flowui.Fragments;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.component.grid.DataGridColumn;
import io.jmix.flowui.component.pagination.SimplePagination;
import io.jmix.flowui.data.pagination.PaginationDataLoader;
import io.jmix.flowui.data.pagination.PaginationDataLoaderImpl;
import io.jmix.flowui.fragment.Fragment;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.model.BaseCollectionLoader;
import io.jmix.flowui.model.CollectionContainer;
import io.jmix.flowui.model.CollectionLoader;
import io.jmix.flowui.model.HasLoader;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.sys.BeanUtil;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Supply;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.openbpm.control.entity.decisiondefinition.DecisionDefinitionData;
import io.openbpm.control.entity.decisioninstance.HistoricDecisionInstanceShortData;
import io.openbpm.control.entity.filter.DecisionInstanceFilter;
import io.openbpm.control.entity.processdefinition.ProcessDefinitionData;
import io.openbpm.control.entity.processinstance.ProcessInstanceData;
import io.openbpm.control.service.decisioninstance.DecisionInstanceLoadContext;
import io.openbpm.control.service.decisioninstance.DecisionInstanceService;
import io.openbpm.control.uicomponent.ContainerDataGridHeaderFilter;
import io.openbpm.control.view.decisioninstance.filter.ActivityIdHeaderFilter;
import io.openbpm.control.view.decisioninstance.filter.EvaluationTimeHeaderFilter;
import io.openbpm.control.view.decisioninstance.filter.ProcessDefinitionKeyHeaderFilter;
import io.openbpm.control.view.decisioninstance.filter.ProcessInstanceIdHeaderFilter;
import io.openbpm.control.view.processdefinition.ProcessDefinitionDetailView;
import io.openbpm.control.view.processinstance.ProcessInstanceDetailView;
import io.openbpm.control.view.util.ComponentHelper;
import java.io.Serializable;
import java.util.List;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@FragmentDescriptor(value="decision-instances-fragment.xml")
public class DecisionInstancesFragment
extends Fragment<VerticalLayout> {
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected Notifications notifications;
    @Autowired
    protected Messages messages;
    @Autowired
    protected ViewNavigators viewNavigators;
    @Autowired
    protected DecisionInstanceService decisionInstanceService;
    @Autowired
    protected Fragments fragments;
    @Autowired
    protected Metadata metadata;
    @Autowired
    protected ComponentHelper componentHelper;
    @ViewComponent
    protected InstanceContainer<DecisionDefinitionData> decisionDefinitionDc;
    @ViewComponent
    protected CollectionContainer<HistoricDecisionInstanceShortData> decisionInstancesDc;
    @ViewComponent
    protected MessageBundle messageBundle;
    @ViewComponent
    protected VerticalLayout decisionInstanceVBox;
    @ViewComponent
    protected Span currentVersionsInstancesCountSpan;
    @ViewComponent
    protected Span allVersionsInstancesCountSpan;
    @ViewComponent
    protected DataGrid<HistoricDecisionInstanceShortData> decisionInstancesGrid;
    @ViewComponent
    protected SimplePagination decisionInstancesPagination;
    @ViewComponent
    protected CollectionLoader<HistoricDecisionInstanceShortData> decisionInstancesDl;
    @ViewComponent
    protected InstanceContainer<DecisionInstanceFilter> decisionInstanceFilterDc;

    @Subscribe(target=Target.HOST_CONTROLLER)
    public void onHostInit(View.InitEvent event) {
        this.addClassNames(new String[]{"p-0"});
        this.initFilter();
        this.initDataGridHeaderRow();
    }

    @Subscribe
    public void onReady(Fragment.ReadyEvent event) {
        HasLoader container;
        this.initDecisionInstanceGroupStyles();
        CollectionContainer collectionContainer = this.decisionInstancesDc;
        if (collectionContainer instanceof HasLoader && (container = (HasLoader)collectionContainer).getLoader() instanceof BaseCollectionLoader) {
            PaginationDataLoader paginationLoader = (PaginationDataLoader)this.applicationContext.getBean(PaginationDataLoaderImpl.class, new Object[]{container.getLoader()});
            this.decisionInstancesPagination.setPaginationLoader(paginationLoader);
        }
    }

    @Subscribe(target=Target.HOST_CONTROLLER)
    public void onHostBeforeShow(View.BeforeShowEvent event) {
        this.initInstancesCountLabels();
    }

    public void initInstancesCountLabels() {
        DecisionDefinitionData item = (DecisionDefinitionData)this.decisionDefinitionDc.getItem();
        long currentVersionInstancesCount = this.decisionInstanceService.getCountByDecisionDefinitionId(item.getDecisionDefinitionId());
        long allVersionsInstancesCount = this.decisionInstanceService.getCountByDecisionDefinitionKey(item.getKey());
        this.currentVersionsInstancesCountSpan.setText(": " + currentVersionInstancesCount);
        this.allVersionsInstancesCountSpan.setText(": " + allVersionsInstancesCount);
    }

    @Subscribe(id="decisionInstanceFilterDc", target=Target.DATA_CONTAINER)
    public void onDecisionInstanceFilterDcItemPropertyChange(InstanceContainer.ItemPropertyChangeEvent<DecisionInstanceFilter> event) {
        this.decisionInstancesDl.load();
    }

    @Subscribe(value="decisionInstancesGrid.edit")
    public void onDecisionDefinitionsGridViewDetails(ActionPerformedEvent event) {
        HistoricDecisionInstanceShortData selectedItem = (HistoricDecisionInstanceShortData)this.decisionInstancesGrid.getSingleSelectedItem();
        if (selectedItem == null) {
            return;
        }
        this.viewNavigators.detailView(UiComponentUtils.getCurrentView(), HistoricDecisionInstanceShortData.class).withRouteParameters(new RouteParameters("id", selectedItem.getDecisionInstanceId())).withBackwardNavigation(true).navigate();
    }

    @Subscribe(id="decisionDefinitionDc", target=Target.DATA_CONTAINER)
    public void onDecisionDefinitionDcItemChange(InstanceContainer.ItemChangeEvent<DecisionDefinitionData> event) {
        this.decisionInstancesDl.load();
    }

    @Install(to="decisionInstancesDl", target=Target.DATA_LOADER)
    protected List<HistoricDecisionInstanceShortData> decisionInstancesLoadDelegate(LoadContext<HistoricDecisionInstanceShortData> loadContext) {
        LoadContext.Query query = loadContext.getQuery();
        DecisionInstanceFilter filter = (DecisionInstanceFilter)this.decisionInstanceFilterDc.getItemOrNull();
        if (filter != null) {
            filter.setDecisionDefinitionId(((DecisionDefinitionData)this.decisionDefinitionDc.getItem()).getDecisionDefinitionId());
        }
        DecisionInstanceLoadContext context = new DecisionInstanceLoadContext().setFilter(filter);
        if (query != null) {
            context = context.setFirstResult(Integer.valueOf(query.getFirstResult())).setMaxResults(Integer.valueOf(query.getMaxResults())).setSort(query.getSort());
        }
        return this.decisionInstanceService.findAllHistoryDecisionInstances(context);
    }

    @Install(to="decisionInstancesPagination", subject="totalCountDelegate")
    protected Integer decisionInstancesPaginationTotalCountDelegate(DataLoadContext dataLoadContext) {
        DecisionDefinitionData decisionDefinition = (DecisionDefinitionData)this.decisionDefinitionDc.getItem();
        return (int)this.decisionInstanceService.getCountByDecisionDefinitionId(decisionDefinition.getDecisionDefinitionId());
    }

    protected void initDataGridHeaderRow() {
        HeaderRow headerRow = this.decisionInstancesGrid.getDefaultHeaderRow();
        this.addColumnFilter(headerRow, "evaluationTime", arg_0 -> this.createEvaluationTimeColumnFilter(arg_0));
        this.addColumnFilter(headerRow, "processDefinitionKey", arg_0 -> this.createProcessDefinitionKeyColumnFilter(arg_0));
        this.addColumnFilter(headerRow, "processInstanceId", arg_0 -> this.createProcessInstanceIdColumnFilter(arg_0));
        this.addColumnFilter(headerRow, "activityId", arg_0 -> this.createActivityIdColumnFilter(arg_0));
    }

    protected EvaluationTimeHeaderFilter createEvaluationTimeColumnFilter(DataGridColumn<HistoricDecisionInstanceShortData> column) {
        return new EvaluationTimeHeaderFilter(this.decisionInstancesGrid, column, this.decisionInstanceFilterDc);
    }

    protected ProcessDefinitionKeyHeaderFilter createProcessDefinitionKeyColumnFilter(DataGridColumn<HistoricDecisionInstanceShortData> column) {
        return new ProcessDefinitionKeyHeaderFilter(this.decisionInstancesGrid, column, this.decisionInstanceFilterDc);
    }

    protected ProcessInstanceIdHeaderFilter createProcessInstanceIdColumnFilter(DataGridColumn<HistoricDecisionInstanceShortData> column) {
        return new ProcessInstanceIdHeaderFilter(this.decisionInstancesGrid, column, this.decisionInstanceFilterDc);
    }

    protected ActivityIdHeaderFilter createActivityIdColumnFilter(DataGridColumn<HistoricDecisionInstanceShortData> column) {
        return new ActivityIdHeaderFilter(this.decisionInstancesGrid, column, this.decisionInstanceFilterDc);
    }

    @Supply(to="decisionInstancesGrid.evaluationTime", subject="renderer")
    protected Renderer<HistoricDecisionInstanceShortData> decisionInstancesGridEvaluationTimeRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)instance -> {
            Span dateSpan = this.componentHelper.createDateSpan(instance.getEvaluationTime());
            dateSpan.addClassNames(new String[]{"overflow-hidden", "overflow-ellipsis"});
            return dateSpan;
        });
    }

    @Supply(to="decisionInstancesGrid.processDefinitionKey", subject="renderer")
    protected Renderer<HistoricDecisionInstanceShortData> decisionInstancesGridProcessDefinitionKeyRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)instance -> {
            JmixButton button = (JmixButton)this.uiComponents.create(JmixButton.class);
            button.setText(instance.getProcessDefinitionKey());
            button.addThemeName("tertiary-inline");
            button.addClickListener((ComponentEventListener & Serializable)event -> this.viewNavigators.detailView(UiComponentUtils.getCurrentView(), ProcessDefinitionData.class).withViewClass(ProcessDefinitionDetailView.class).withRouteParameters(new RouteParameters("id", instance.getProcessDefinitionId())).withBackwardNavigation(true).navigate());
            return button;
        });
    }

    @Supply(to="decisionInstancesGrid.processInstanceId", subject="renderer")
    protected Renderer<HistoricDecisionInstanceShortData> decisionInstancesGridProcessInstanceIdRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)instance -> {
            JmixButton button = (JmixButton)this.uiComponents.create(JmixButton.class);
            button.setText(instance.getProcessInstanceId());
            button.addThemeName("tertiary-inline");
            button.addClickListener((ComponentEventListener & Serializable)event -> this.viewNavigators.detailView(UiComponentUtils.getCurrentView(), ProcessInstanceData.class).withViewClass(ProcessInstanceDetailView.class).withRouteParameters(new RouteParameters("id", instance.getProcessInstanceId())).withBackwardNavigation(true).navigate());
            return button;
        });
    }

    protected void initFilter() {
        DecisionInstanceFilter filter = (DecisionInstanceFilter)this.metadata.create(DecisionInstanceFilter.class);
        this.decisionInstanceFilterDc.setItem((Object)filter);
    }

    protected void initDecisionInstanceGroupStyles() {
        this.decisionInstanceVBox.addClassNames(new String[]{"pt-s", "pl-xs"});
        this.allVersionsInstancesCountSpan.addClassNames(new String[]{"font-bold"});
        this.currentVersionsInstancesCountSpan.addClassNames(new String[]{"font-bold"});
    }

    protected <T extends ContainerDataGridHeaderFilter> void addColumnFilter(HeaderRow headerRow, String columnName, Function<DataGridColumn<HistoricDecisionInstanceShortData>, T> filterProvider) {
        DataGridColumn column = this.decisionInstancesGrid.getColumnByKey(columnName);
        ContainerDataGridHeaderFilter filterComponent = (ContainerDataGridHeaderFilter)filterProvider.apply((DataGridColumn<HistoricDecisionInstanceShortData>)column);
        BeanUtil.autowireContext((ApplicationContext)this.applicationContext, (Object)filterComponent);
        HeaderRow.HeaderCell headerCell = (HeaderRow.HeaderCell)headerRow.getCell((Grid.Column)column);
        headerCell.setComponent((Component)filterComponent);
    }
}

