/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.deploymentdata;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.router.Route;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.component.checkbox.JmixCheckbox;
import io.jmix.flowui.view.DefaultMainViewParent;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.StandardView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.openbpm.control.exception.RemoteProcessEngineException;
import io.openbpm.control.service.deployment.DeploymentService;
import io.openbpm.control.service.processinstance.ProcessInstanceService;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="bpm/deletedeployment", layout=DefaultMainViewParent.class)
@ViewController(value="bpm_DeleteDeployment")
@ViewDescriptor(value="delete-deployment-view.xml")
@DialogMode(width="35em")
public class DeleteDeploymentView
extends StandardView {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeleteDeploymentView.class);
    @Autowired
    protected Notifications notifications;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private DeploymentService deploymentService;
    @ViewComponent
    protected Icon allInstancesContextHelp;
    @ViewComponent
    protected JmixCheckbox deleteProcessInstancesCheckBox;
    @ViewComponent
    private MessageBundle messageBundle;
    @ViewComponent
    private JmixCheckbox skipCustomListenersCheckBox;
    @ViewComponent
    private JmixCheckbox skipIOMappingsCheckBox;
    protected String deploymentId;

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.addClassNames(new String[]{"pt-0", "pl-l"});
        this.allInstancesContextHelp.addClassNames(new String[]{"text-secondary"});
    }

    @Subscribe
    protected void onBeforeShow(View.BeforeShowEvent event) {
        this.deleteProcessInstancesCheckBox.setValue(Boolean.valueOf(false));
        long countByDeploymentId = this.processInstanceService.getCountByDeploymentId(this.deploymentId);
        if (countByDeploymentId > 0L) {
            this.deleteProcessInstancesCheckBox.setValue(Boolean.valueOf(true));
            this.allInstancesContextHelp.setTooltipText(this.messageBundle.getMessage("deleteAllRunningInstances.tooltip"));
        }
        this.deleteProcessInstancesCheckBox.setEnabled(countByDeploymentId == 0L);
    }

    @Subscribe(value="okBtn")
    protected void onActivateBtnClick(ClickEvent<Button> event) {
        boolean deleteAllRelatedInstances = BooleanUtils.isTrue((Boolean)((Boolean)this.deleteProcessInstancesCheckBox.getValue()));
        boolean skipCustomListeners = BooleanUtils.isTrue((Boolean)((Boolean)this.skipCustomListenersCheckBox.getValue()));
        boolean skipIOMappings = BooleanUtils.isTrue((Boolean)((Boolean)this.skipIOMappingsCheckBox.getValue()));
        try {
            this.deploymentService.deleteById(this.deploymentId, deleteAllRelatedInstances, skipCustomListeners, skipIOMappings);
        }
        catch (Exception e) {
            if (e instanceof RemoteProcessEngineException) {
                RemoteProcessEngineException processEngineException = (RemoteProcessEngineException)e;
                log.error("Unable to delete deployment", (Throwable)e);
                this.notifications.create((String)StringUtils.defaultIfEmpty((CharSequence)processEngineException.getResponseMessage(), (CharSequence)e.getMessage())).withType(Notifications.Type.ERROR).withDuration(10000).show();
                return;
            }
            throw e;
        }
        this.close(StandardOutcome.SAVE);
    }

    @Subscribe(value="cancelBtn")
    protected void onCancelBtnClick(ClickEvent<Button> event) {
        this.close(StandardOutcome.DISCARD);
    }
}

