/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.deploymentdata;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.Route;
import feign.RequestInterceptor;
import feign.auth.BasicAuthRequestInterceptor;
import io.jmix.core.LoadContext;
import io.jmix.core.Metadata;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.Fragments;
import io.jmix.flowui.component.formlayout.JmixFormLayout;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.fragment.FragmentOwner;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.model.CollectionLoader;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.StandardListView;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Supply;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.openbpm.control.entity.deployment.DeploymentData;
import io.openbpm.control.entity.engine.AuthType;
import io.openbpm.control.entity.engine.BpmEngine;
import io.openbpm.control.entity.filter.DeploymentFilter;
import io.openbpm.control.property.EngineConnectionCheckProperties;
import io.openbpm.control.restsupport.FeignClientProvider;
import io.openbpm.control.service.deployment.DeploymentLoadContext;
import io.openbpm.control.service.deployment.DeploymentService;
import io.openbpm.control.service.engine.EngineService;
import io.openbpm.control.view.deploymentdata.BulkDeleteDeploymentView;
import io.openbpm.control.view.deploymentdata.DeleteDeploymentView;
import io.openbpm.control.view.deploymentdata.DeploymentListItemActionsFragment;
import io.openbpm.control.view.main.MainView;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;

@Route(value="bpmn/deployments", layout=MainView.class)
@ViewController(id="bpm_Deployment.list")
@ViewDescriptor(path="deployment-list-view.xml")
public class DeploymentListView
extends StandardListView<DeploymentData> {
    @Autowired
    private DeploymentService deploymentService;
    @Autowired
    private Metadata metadata;
    @ViewComponent
    private InstanceContainer<DeploymentFilter> deploymentFilterDc;
    @ViewComponent
    private CollectionLoader<DeploymentData> deploymentDatasDl;
    @ViewComponent
    private JmixFormLayout filterFormLayout;
    @ViewComponent
    private HorizontalLayout filterPanel;
    @Autowired
    private Fragments fragments;
    @Autowired
    private FeignClientProvider feignClientProvider;
    @Autowired
    private EngineConnectionCheckProperties engineConnectionCheckProperties;
    @Autowired
    private EngineService engineService;
    @ViewComponent
    private DataGrid<DeploymentData> deploymentsDataGrid;
    @Autowired
    private DialogWindows dialogWindows;

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.addClassNames(new String[]{"pt-s"});
        this.initFilterFormStyles();
    }

    @Subscribe
    public void onBeforeShow(View.BeforeShowEvent event) {
        this.initFilter();
        this.deploymentDatasDl.load();
    }

    @Subscribe(value="applyFilter")
    public void onApplyFilter(ActionPerformedEvent event) {
        this.deploymentDatasDl.load();
    }

    @Subscribe(id="deploymentFilterDc", target=Target.DATA_CONTAINER)
    public void onDeploymentFilterDcItemPropertyChange(InstanceContainer.ItemPropertyChangeEvent<DeploymentFilter> event) {
        this.deploymentDatasDl.load();
    }

    @Subscribe(id="clearBtn", subject="clickListener")
    public void onClearBtnClick(ClickEvent<JmixButton> event) {
        DeploymentFilter filter = (DeploymentFilter)this.deploymentFilterDc.getItem();
        filter.setNameLike(null);
        filter.setDeploymentAfter(null);
        filter.setDeploymentBefore(null);
    }

    @Nullable
    protected RequestInterceptor createBpmEngineRequestInterceptor(BpmEngine engine) {
        RequestInterceptor requestInterceptor = null;
        if (BooleanUtils.isTrue((Boolean)engine.getAuthEnabled())) {
            if (engine.getAuthType() == AuthType.BASIC) {
                requestInterceptor = new BasicAuthRequestInterceptor(engine.getBasicAuthUsername(), engine.getBasicAuthPassword());
            } else if (engine.getAuthType() == AuthType.HTTP_HEADER) {
                requestInterceptor = requestTemplate -> requestTemplate.header(engine.getHttpHeaderName(), new String[]{engine.getHttpHeaderValue()});
            }
        }
        return requestInterceptor;
    }

    protected void initFilterFormStyles() {
        this.filterFormLayout.getOwnComponents().forEach(component -> component.addClassName("pt-xs"));
        this.filterPanel.addClassNames(new String[]{"pt-xs", "pl-m", "pb-xs", "pr-m", "border", "rounded-l", "border-contrast-20"});
    }

    protected void initFilter() {
        DeploymentFilter filter = (DeploymentFilter)this.metadata.create(DeploymentFilter.class);
        this.deploymentFilterDc.setItem((Object)filter);
    }

    @Install(to="deploymentDatasDl", target=Target.DATA_LOADER)
    protected List<DeploymentData> deploymentDatasDlLoadDelegate(LoadContext<DeploymentData> loadContext) {
        LoadContext.Query query = loadContext.getQuery();
        DeploymentFilter filter = (DeploymentFilter)this.deploymentFilterDc.getItemOrNull();
        DeploymentLoadContext context = new DeploymentLoadContext().setFilter(filter);
        if (query != null) {
            context = context.setFirstResult(Integer.valueOf(query.getFirstResult())).setMaxResults(Integer.valueOf(query.getMaxResults())).setSort(query.getSort());
        }
        return this.deploymentService.findAll(context);
    }

    @Supply(to="deploymentsDataGrid.actions", subject="renderer")
    protected Renderer<DeploymentData> deploymentsDataGridActionsRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)deploymentData -> {
            DeploymentListItemActionsFragment actionsFragment = (DeploymentListItemActionsFragment)this.fragments.create((FragmentOwner)this, DeploymentListItemActionsFragment.class);
            actionsFragment.setDeploymentData(deploymentData);
            return actionsFragment;
        });
    }

    @Subscribe(value="deploymentsDataGrid.bulkRemove")
    protected void onDeploymentsDataGridBulkRemove(ActionPerformedEvent event) {
        Set selectedItems = this.deploymentsDataGrid.getSelectedItems();
        if (selectedItems.isEmpty()) {
            return;
        }
        if (selectedItems.size() == 1) {
            this.dialogWindows.view((View)this, DeleteDeploymentView.class).withAfterCloseListener(closeEvent -> {
                if (closeEvent.closedWith(StandardOutcome.SAVE)) {
                    this.deploymentDatasDl.load();
                }
            }).withViewConfigurer(view -> view.setDeploymentId(((DeploymentData)this.deploymentsDataGrid.getSingleSelectedItem()).getId())).build().open();
            return;
        }
        this.dialogWindows.view((View)this, BulkDeleteDeploymentView.class).withAfterCloseListener(closeEvent -> {
            if (closeEvent.closedWith(StandardOutcome.SAVE)) {
                this.deploymentDatasDl.load();
            }
        }).withViewConfigurer(view -> view.setDeployments((Collection)selectedItems)).build().open();
    }
}

