/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.engineconnectionsettings;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.Route;
import io.jmix.core.Messages;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.UiComponents;
import io.jmix.flowui.UiEventPublisher;
import io.jmix.flowui.component.combobox.EntityComboBox;
import io.jmix.flowui.component.formlayout.JmixFormLayout;
import io.jmix.flowui.component.textfield.JmixPasswordField;
import io.jmix.flowui.component.textfield.TypedTextField;
import io.jmix.flowui.exception.ValidationException;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.StandardView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Supply;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.openbpm.control.action.TestEngineConnectionAction;
import io.openbpm.control.entity.engine.AuthType;
import io.openbpm.control.entity.engine.BpmEngine;
import io.openbpm.control.service.engine.EngineService;
import io.openbpm.control.service.engine.EngineUiService;
import io.openbpm.control.view.main.MainView;
import java.io.Serializable;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="engine-connection-settings", layout=MainView.class)
@ViewController(value="EngineConnectionSettingsView")
@ViewDescriptor(value="engine-connection-settings-view.xml")
@DialogMode(minWidth="30em", maxWidth="40em")
public class EngineConnectionSettingsView
extends StandardView {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EngineConnectionSettingsView.class);
    public static final String ENGINE_WITH_TYPE_LABEL_FORMAT = "%s (%s)";
    @ViewComponent
    protected TypedTextField<String> baseUrlField;
    @ViewComponent
    protected TypedTextField<Object> basicAuthUsername;
    @ViewComponent
    protected JmixPasswordField basicAuthPassword;
    @ViewComponent
    protected TypedTextField<Object> engineNameField;
    @ViewComponent
    protected JmixFormLayout form;
    @Autowired
    protected EngineService engineService;
    @Autowired
    protected Notifications notifications;
    @ViewComponent
    protected MessageBundle messageBundle;
    @ViewComponent
    protected TypedTextField<String> authenticationTypeField;
    @Autowired
    protected Messages messages;
    @ViewComponent
    protected HorizontalLayout basicAuthSettingsHBox;
    @ViewComponent
    protected VerticalLayout customHttpHeaderSettingsVBox;
    @ViewComponent
    protected TypedTextField<String> customHeaderName;
    @ViewComponent
    protected JmixPasswordField customHeaderValue;
    @ViewComponent
    protected EntityComboBox<BpmEngine> bpmEnginesComboBox;
    @Autowired
    protected UiComponents uiComponents;
    @ViewComponent
    protected TestEngineConnectionAction testConnectionAction;
    @Autowired
    protected UiEventPublisher uiEventPublisher;
    @Autowired
    protected EngineUiService engineUiService;
    @ViewComponent
    protected InstanceContainer<BpmEngine> engineDc;

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.addClassNames(new String[]{"pt-xs"});
        this.form.getOwnComponents().forEach(component -> component.addClassNames(new String[]{"pt-s"}));
        BpmEngine selectedEngine = this.engineService.getSelectedEngine();
        this.bpmEnginesComboBox.setValue((Object)selectedEngine);
    }

    protected void initEngineFields(BpmEngine bpmEngine) {
        this.testConnectionAction.setEngine(bpmEngine);
        this.testConnectionAction.refreshState();
        if (bpmEngine != null) {
            if (BooleanUtils.isTrue((Boolean)bpmEngine.getAuthEnabled())) {
                this.authenticationTypeField.setTypedValue((Object)this.messages.getMessage((Enum)bpmEngine.getAuthType()));
                if (bpmEngine.getAuthType() == AuthType.HTTP_HEADER) {
                    this.customHttpHeaderSettingsVBox.setVisible(true);
                    this.basicAuthSettingsHBox.setVisible(false);
                } else if (bpmEngine.getAuthType() == AuthType.BASIC) {
                    this.customHttpHeaderSettingsVBox.setVisible(false);
                    this.basicAuthSettingsHBox.setVisible(true);
                }
            } else {
                this.authenticationTypeField.setTypedValue((Object)this.messageBundle.getMessage("noAuth"));
                this.customHttpHeaderSettingsVBox.setVisible(false);
                this.basicAuthSettingsHBox.setVisible(false);
            }
        } else {
            this.basicAuthSettingsHBox.setVisible(false);
            this.customHttpHeaderSettingsVBox.setVisible(false);
            this.authenticationTypeField.setTypedValue(null);
        }
    }

    @Subscribe(value="bpmEnginesComboBox")
    protected void onBpmEnginesComboBoxComponentValueChange(AbstractField.ComponentValueChangeEvent<EntityComboBox<BpmEngine>, BpmEngine> event) {
        this.engineDc.setItem((Object)((BpmEngine)event.getValue()));
        this.initEngineFields((BpmEngine)this.engineDc.getItemOrNull());
    }

    @Subscribe(id="copyBaseUrlBtn", subject="clickListener")
    public void onCopyBaseUrlBtnClick(ClickEvent<JmixButton> event) {
        String valueToCopy = this.baseUrlField.getValue();
        this.copyValue(event, valueToCopy, "baseUrlCopied", "baseUrlCopyFailed");
    }

    @Subscribe(id="copyCustomHeaderNameBtn", subject="clickListener")
    public void onCopyCustomHeaderNameBtnClick(ClickEvent<JmixButton> event) {
        String valueToCopy = this.customHeaderName.getValue();
        this.copyValue(event, valueToCopy, "headerNameCopied", "headerNameCopyFailed");
    }

    @Subscribe(id="copyCustomHeaderValueBtn", subject="clickListener")
    public void onCopyCustomHeaderValueBtnClick(ClickEvent<JmixButton> event) {
        String valueToCopy = this.customHeaderValue.getValue();
        this.copyValue(event, valueToCopy, "headerValueCopied", "headerValueCopyFailed");
    }

    @Subscribe(id="copyBasicAuthUsernameBtn", subject="clickListener")
    public void onCopyBasicAuthUsernameBtnClick(ClickEvent<JmixButton> event) {
        String valueToCopy = this.basicAuthUsername.getValue();
        this.copyValue(event, valueToCopy, "basicAuthUsernameCopied", "basicAuthUsernameCopyFailed");
    }

    @Subscribe(id="copyBasicAuthPasswordBtn", subject="clickListener")
    public void onCopyBasicAuthPasswordBtnClick(ClickEvent<JmixButton> event) {
        String valueToCopy = this.basicAuthPassword.getValue();
        this.copyValue(event, valueToCopy, "basicAuthPasswordCopied", "basicAuthPasswordCopyFailed");
    }

    protected void copyValue(ClickEvent<JmixButton> event, String valueToCopy, String valueCopiedMessageKey, String copyFailedMessageKey) {
        Element buttonElement = ((JmixButton)event.getSource()).getElement();
        buttonElement.executeJs("  const textarea = document.createElement(\"textarea\");\n  textarea.value = $0;\n\n  textarea.style.position = \"absolute\";\n  textarea.style.opacity = \"0\";\n\n  document.body.appendChild(textarea);\n  textarea.select();\n  document.execCommand(\"copy\");\n  document.body.removeChild(textarea);\n", new Serializable[]{valueToCopy}).then((SerializableConsumer & Serializable)successResult -> this.notifications.create(this.messageBundle.getMessage(valueCopiedMessageKey)).withPosition(Notification.Position.TOP_END).withThemeVariant(NotificationVariant.LUMO_SUCCESS).show(), (SerializableConsumer & Serializable)errorResult -> this.notifications.create(this.messageBundle.getMessage(copyFailedMessageKey)).withPosition(Notification.Position.TOP_END).withThemeVariant(NotificationVariant.LUMO_ERROR).show());
    }

    @Subscribe(id="updateEngineBtn", subject="clickListener")
    protected void onUpdateEngineBtnClick(ClickEvent<JmixButton> event) {
        try {
            this.bpmEnginesComboBox.executeValidators();
        }
        catch (ValidationException e) {
            return;
        }
        BpmEngine value = (BpmEngine)this.bpmEnginesComboBox.getValue();
        this.engineUiService.selectEngine(value);
        this.close(StandardOutcome.CLOSE);
    }

    @Install(to="bpmEnginesComboBox", subject="itemLabelGenerator")
    protected String bpmEnginesComboBoxItemLabelGenerator(BpmEngine engine) {
        return ENGINE_WITH_TYPE_LABEL_FORMAT.formatted(engine.getName(), this.messages.getMessage((Enum)engine.getType()));
    }

    @Supply(to="bpmEnginesComboBox", subject="renderer")
    protected Renderer<BpmEngine> bpmEnginesComboBoxRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)bpmEngine -> {
            HorizontalLayout horizontalLayout = (HorizontalLayout)this.uiComponents.create(HorizontalLayout.class);
            horizontalLayout.setPadding(false);
            horizontalLayout.addClassNames(new String[]{"gap-s"});
            Span name = new Span(ENGINE_WITH_TYPE_LABEL_FORMAT.formatted(bpmEngine.getName(), this.messages.getMessage((Enum)bpmEngine.getType())));
            Span url = new Span(bpmEngine.getBaseUrl());
            url.addClassNames(new String[]{"text-tertiary"});
            horizontalLayout.add(new Component[]{name, url});
            return horizontalLayout;
        });
    }
}

