/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.historicincidentdata;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.router.Route;
import io.jmix.core.LoadContext;
import io.jmix.core.Messages;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.component.textfield.TypedTextField;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.view.EditedEntityContainer;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.StandardDetailView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.openbpm.control.entity.incident.HistoricIncidentData;
import io.openbpm.control.service.incident.IncidentService;
import io.openbpm.control.service.job.impl.JobServiceImpl;
import io.openbpm.control.view.externaltask.ExternalTaskErrorDetailsView;
import io.openbpm.control.view.job.JobErrorDetailsView;
import io.openbpm.control.view.main.MainView;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="historic-incidents/:id", layout=MainView.class)
@ViewController(value="HistoricIncidentData.detail")
@ViewDescriptor(value="historic-incident-data-detail-view.xml")
@EditedEntityContainer(value="historicIncidentDataDc")
public class HistoricIncidentDataDetailView
extends StandardDetailView<HistoricIncidentData> {
    @Autowired
    protected IncidentService incidentService;
    @ViewComponent
    protected JmixButton viewStacktraceBtn;
    @ViewComponent
    protected TypedTextField<Object> configurationField;
    @Autowired
    protected Messages messages;
    @ViewComponent
    protected TypedTextField<Object> causeIncidentIdField;
    @ViewComponent
    protected TypedTextField<Object> rootCauseIncidentIdField;
    @Autowired
    protected DialogWindows dialogWindows;
    @Autowired
    protected JobServiceImpl jobService;

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.addClassNames(new String[]{"pt-xs"});
    }

    @Subscribe
    public void onBeforeShow(View.BeforeShowEvent event) {
        this.initIncidentTypeRelatedFields();
        this.initCauseIncidentFields();
        this.initRootCauseIncidentFields();
    }

    @Install(to="historicIncidentDataDl", target=Target.DATA_LOADER)
    protected HistoricIncidentData historicIncidentDataDlLoadDelegate(LoadContext<HistoricIncidentData> loadContext) {
        Object id = loadContext.getId();
        if (id != null) {
            return this.incidentService.findHistoricIncidentById(id.toString());
        }
        return null;
    }

    protected void initIncidentTypeRelatedFields() {
        boolean notEmptyPayload = ((HistoricIncidentData)this.getEditedEntity()).getConfiguration() != null;
        boolean historyJobLogPresent = this.jobService.isHistoryJobLogPresent(((HistoricIncidentData)this.getEditedEntity()).getConfiguration());
        if (((HistoricIncidentData)this.getEditedEntity()).isExternalTaskFailed()) {
            this.viewStacktraceBtn.setVisible(notEmptyPayload && historyJobLogPresent);
            this.configurationField.setLabel(this.messages.getMessage("io.openbpm.control.view.incidentdata/externalTaskIdLabel"));
        } else if (((HistoricIncidentData)this.getEditedEntity()).isJobFailed()) {
            this.configurationField.setLabel(this.messages.getMessage("io.openbpm.control.view.incidentdata/jobIdLabel"));
            this.viewStacktraceBtn.setVisible(notEmptyPayload && historyJobLogPresent);
        } else {
            this.viewStacktraceBtn.setVisible(false);
        }
    }

    @Subscribe(id="viewStacktraceBtn", subject="clickListener")
    public void onViewStacktraceBtnClick(ClickEvent<JmixButton> event) {
        if (((HistoricIncidentData)this.getEditedEntity()).isJobFailed()) {
            this.dialogWindows.view((View)this, JobErrorDetailsView.class).withViewConfigurer(view -> {
                view.setJobId(((HistoricIncidentData)this.getEditedEntity()).getConfiguration());
                view.fromHistory();
            }).build().open();
        } else if (((HistoricIncidentData)this.getEditedEntity()).isExternalTaskFailed()) {
            this.dialogWindows.view((View)this, ExternalTaskErrorDetailsView.class).withViewConfigurer(view -> {
                view.setExternalTaskId(((HistoricIncidentData)this.getEditedEntity()).getConfiguration());
                view.fromHistory();
            }).build().open();
        }
    }

    protected void initCauseIncidentFields() {
        String causeIncidentId = ((HistoricIncidentData)this.getEditedEntity()).getCauseIncidentId();
        String causeIncidentLabel = StringUtils.equals((CharSequence)((HistoricIncidentData)this.getEditedEntity()).getIncidentId(), (CharSequence)causeIncidentId) ? this.messages.formatMessage("io.openbpm.control.view.incidentdata", "incidentWithProcess", new Object[]{causeIncidentId, ((HistoricIncidentData)this.getEditedEntity()).getProcessDefinitionKey()}) : this.getRelatedIncidentFieldLabel(causeIncidentId);
        this.causeIncidentIdField.setValue(causeIncidentLabel);
    }

    protected String getRelatedIncidentFieldLabel(String relatedIncidentId) {
        HistoricIncidentData relatedIncident = this.incidentService.findHistoricIncidentById(relatedIncidentId);
        String relatedIncidentLabel = relatedIncident != null ? this.messages.formatMessage("io.openbpm.control.view.incidentdata", "incidentWithProcess", new Object[]{relatedIncidentId, relatedIncident.getProcessDefinitionKey()}) : relatedIncidentId;
        return relatedIncidentLabel;
    }

    protected void initRootCauseIncidentFields() {
        String rootCauseIncidentId = ((HistoricIncidentData)this.getEditedEntity()).getRootCauseIncidentId();
        boolean sameIncident = StringUtils.equals((CharSequence)((HistoricIncidentData)this.getEditedEntity()).getIncidentId(), (CharSequence)((HistoricIncidentData)this.getEditedEntity()).getRootCauseIncidentId());
        String rootCauseIncidentLabel = sameIncident ? this.messages.formatMessage("io.openbpm.control.view.incidentdata", "incidentWithProcess", new Object[]{rootCauseIncidentId, ((HistoricIncidentData)this.getEditedEntity()).getProcessDefinitionKey()}) : this.getRelatedIncidentFieldLabel(rootCauseIncidentId);
        this.rootCauseIncidentIdField.setValue(rootCauseIncidentLabel);
    }
}

