/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.login;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.login.AbstractLogin;
import com.vaadin.flow.component.login.LoginI18n;
import com.vaadin.flow.i18n.LocaleChangeEvent;
import com.vaadin.flow.i18n.LocaleChangeObserver;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.VaadinSession;
import io.jmix.core.CoreProperties;
import io.jmix.core.MessageTools;
import io.jmix.core.security.AccessDeniedException;
import io.jmix.flowui.component.loginform.JmixLoginForm;
import io.jmix.flowui.kit.component.ComponentUtils;
import io.jmix.flowui.kit.component.loginform.EnhancedLoginForm;
import io.jmix.flowui.kit.component.loginform.JmixLoginI18n;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.jmix.securityflowui.authentication.AuthDetails;
import io.jmix.securityflowui.authentication.LoginViewSupport;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;

@Route(value="login")
@ViewController(value="LoginView")
@ViewDescriptor(value="login-view.xml")
public class LoginView
extends StandardView
implements LocaleChangeObserver {
    protected static final Logger log = LoggerFactory.getLogger(LoginView.class);
    @Autowired
    protected CoreProperties coreProperties;
    @Autowired
    protected LoginViewSupport loginViewSupport;
    @ViewComponent
    protected MessageBundle messageBundle;
    @Autowired
    protected MessageTools messageTools;
    @ViewComponent
    protected JmixLoginForm login;
    @Value(value="${ui.login.defaultUsername:}")
    protected String defaultUsername;
    @Value(value="${ui.login.defaultPassword:}")
    protected String defaultPassword;

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.initLocales();
        this.initDefaultCredentials();
    }

    protected void initLocales() {
        LinkedHashMap locales = this.coreProperties.getAvailableLocales().stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((MessageTools)this.messageTools).getLocaleDisplayName(arg_0), (s1, s2) -> s1, LinkedHashMap::new));
        ComponentUtils.setItemsMap((EnhancedLoginForm)this.login, (Map)locales);
        this.login.setSelectedLocale(VaadinSession.getCurrent().getLocale());
    }

    protected void initDefaultCredentials() {
        if (StringUtils.isNotBlank((CharSequence)this.defaultUsername)) {
            this.login.setUsername(this.defaultUsername);
        }
        if (StringUtils.isNotBlank((CharSequence)this.defaultPassword)) {
            this.login.setPassword(this.defaultPassword);
        }
    }

    @Subscribe(value="login")
    public void onLogin(AbstractLogin.LoginEvent event) {
        try {
            this.loginViewSupport.authenticate(AuthDetails.of((String)event.getUsername(), (String)event.getPassword()).withLocale(this.login.getSelectedLocale()).withRememberMe(this.login.isRememberMe()));
        }
        catch (AccessDeniedException | BadCredentialsException | DisabledException | LockedException e) {
            log.warn("Login failed for user '{}': {}", (Object)event.getUsername(), (Object)e.toString());
            ((AbstractLogin)event.getSource()).setError(true);
        }
    }

    public void localeChange(LocaleChangeEvent event) {
        UI.getCurrent().getPage().setTitle(this.messageBundle.getMessage("LoginView.title"));
        JmixLoginI18n loginI18n = JmixLoginI18n.createDefault();
        JmixLoginI18n.JmixForm form = new JmixLoginI18n.JmixForm();
        form.setTitle(this.messageBundle.getMessage("loginForm.headerTitle"));
        form.setUsername(this.messageBundle.getMessage("loginForm.username"));
        form.setPassword(this.messageBundle.getMessage("loginForm.password"));
        form.setSubmit(this.messageBundle.getMessage("loginForm.submit"));
        form.setForgotPassword(this.messageBundle.getMessage("loginForm.forgotPassword"));
        form.setRememberMe(this.messageBundle.getMessage("loginForm.rememberMe"));
        loginI18n.setForm((LoginI18n.Form)form);
        LoginI18n.ErrorMessage errorMessage = new LoginI18n.ErrorMessage();
        errorMessage.setTitle(this.messageBundle.getMessage("loginForm.errorTitle"));
        errorMessage.setMessage(this.messageBundle.getMessage("loginForm.badCredentials"));
        errorMessage.setUsername(this.messageBundle.getMessage("loginForm.errorUsername"));
        errorMessage.setPassword(this.messageBundle.getMessage("loginForm.errorPassword"));
        loginI18n.setErrorMessage(errorMessage);
        this.login.setI18n((LoginI18n)loginI18n);
    }
}

