/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.newprocessdeployment;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.H4;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.Tooltip;
import com.vaadin.flow.router.Route;
import io.jmix.core.Metadata;
import io.jmix.flowui.Dialogs;
import io.jmix.flowui.Fragments;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.UiComponents;
import io.jmix.flowui.action.DialogAction;
import io.jmix.flowui.component.upload.FileUploadField;
import io.jmix.flowui.fragment.FragmentOwner;
import io.jmix.flowui.kit.action.Action;
import io.jmix.flowui.kit.action.ActionVariant;
import io.jmix.flowui.kit.component.ComponentUtils;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.kit.component.upload.event.FileUploadSucceededEvent;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.openbpm.control.dto.BpmProcessDefinition;
import io.openbpm.control.entity.filter.ProcessDefinitionFilter;
import io.openbpm.control.entity.processdefinition.ProcessDefinitionData;
import io.openbpm.control.exception.RemoteEngineParseException;
import io.openbpm.control.exception.RemoteProcessEngineException;
import io.openbpm.control.restsupport.camunda.ResourceReport;
import io.openbpm.control.service.deployment.DeploymentContext;
import io.openbpm.control.service.deployment.DeploymentService;
import io.openbpm.control.service.processdefinition.ProcessDefinitionLoadContext;
import io.openbpm.control.service.processdefinition.ProcessDefinitionService;
import io.openbpm.control.util.BpmParseUtil;
import io.openbpm.control.view.AbstractResourceDeploymentView;
import io.openbpm.control.view.main.MainView;
import io.openbpm.control.view.newprocessdeployment.DeploymentConfirmContentFragment;
import io.openbpm.uikit.component.bpmnviewer.event.XmlImportCompleteEvent;
import io.openbpm.uikit.fragment.bpmnviewer.BpmnViewerFragment;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.camunda.bpm.engine.repository.DeploymentWithDefinitions;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="bpm/new-process-deployment", layout=MainView.class)
@ViewController(value="bpm_NewProcessDeploymentView")
@ViewDescriptor(value="new-process-deployment-view.xml")
public class NewProcessDeploymentView
extends AbstractResourceDeploymentView {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewProcessDeploymentView.class);
    @ViewComponent
    protected FileUploadField bpmnXmlUploadField;
    @Autowired
    protected DeploymentService deploymentService;
    @Autowired
    protected ProcessDefinitionService processDefinitionService;
    @Autowired
    protected Metadata metadata;
    @ViewComponent
    protected MessageBundle messageBundle;
    @Autowired
    protected Notifications notifications;
    @Autowired
    protected UiComponents uiComponents;
    @Autowired
    protected Dialogs dialogs;
    @Autowired
    protected Fragments fragments;
    @ViewComponent
    protected VerticalLayout previewVBox;
    @ViewComponent
    protected Span emptyPreviewText;
    @ViewComponent
    protected HorizontalLayout emptyPreviewHBox;
    @ViewComponent
    protected JmixButton okBtn;
    @ViewComponent
    protected HorizontalLayout processInfoHBox;
    @ViewComponent
    protected Icon processCountInfoIcon;
    @ViewComponent
    protected H4 collaborationLabel;
    @ViewComponent
    protected Span processCountLabel;
    @ViewComponent
    protected H4 processLabel;
    @ViewComponent
    protected Span processIdLabel;
    @ViewComponent
    protected BpmnViewerFragment viewerFragment;
    protected List<BpmProcessDefinition> processDefinitions = new ArrayList();

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.bpmnXmlUploadField.addClassNames(new String[]{"pt-0"});
        this.initEmptyPreviewStyles();
        this.initProcessInfoHBoxStyles();
        this.initDeploymentErrorsButton();
    }

    @Subscribe(id="okBtn", subject="clickListener")
    public void onOkBtnClick(ClickEvent<JmixButton> event) {
        byte[] uploadedXml = (byte[])this.bpmnXmlUploadField.getValue();
        if (uploadedXml == null) {
            this.notifications.create(this.messageBundle.getMessage("bpmnFileNotSelected")).withType(Notifications.Type.ERROR).show();
            return;
        }
        List existingProcesses = this.findExistingProcessesByKeys();
        ((Dialogs.OptionDialogBuilder)((Dialogs.OptionDialogBuilder)((Dialogs.OptionDialogBuilder)this.dialogs.createOptionDialog().withHeader(this.messageBundle.getMessage("createDeploymentConfirmDialog.header"))).withContent((Component)this.createConfirmDialogContent(existingProcesses))).withWidth("35em")).withActions(new Action[]{new DialogAction(DialogAction.Type.YES).withHandler(e -> this.deployBpmnXml(uploadedXml)).withText(this.messageBundle.getMessage("deploy")).withIcon(VaadinIcon.ROCKET).withVariant(ActionVariant.PRIMARY), new DialogAction(DialogAction.Type.CANCEL).withIcon(ComponentUtils.convertToIcon((VaadinIcon)VaadinIcon.BAN))}).open();
    }

    @Subscribe(value="bpmnXmlUploadField")
    public void onBpmnXmlUploadFieldComponentValueChange(AbstractField.ComponentValueChangeEvent<FileUploadField, ?> event) {
        boolean emptyValue = event.getValue() == null;
        this.viewerFragment.setVisible(!emptyValue);
        this.emptyPreviewHBox.setVisible(emptyValue);
        this.okBtn.setEnabled(!emptyValue);
        if (emptyValue) {
            this.processDefinitions = new ArrayList();
            this.processInfoHBox.setVisible(false);
        }
        this.errorsBtn.setVisible(false);
    }

    @Subscribe(value="bpmnXmlUploadField")
    public void onBpmnXmlUploadFieldFileUploadSucceeded(FileUploadSucceededEvent<FileUploadField> event) {
        if (this.bpmnXmlUploadField.getValue() != null) {
            String processDefinitionBpmnXml = new String((byte[])this.bpmnXmlUploadField.getValue(), StandardCharsets.UTF_8);
            this.viewerFragment.initViewer(processDefinitionBpmnXml);
            this.viewerFragment.addImportCompleteListener(arg_0 -> this.updateImportedProcesses(arg_0));
            this.viewerFragment.setVisible(true);
            this.emptyPreviewHBox.setVisible(false);
        }
        this.errorsBtn.setVisible(false);
    }

    @Subscribe(id="cancelBtn", subject="clickListener")
    public void onCancelBtnClick(ClickEvent<JmixButton> event) {
        this.close(StandardOutcome.CLOSE);
    }

    protected void initEmptyPreviewStyles() {
        this.previewVBox.addClassNames(new String[]{"border", "rounded-l", "border-contrast-20"});
        this.emptyPreviewText.addClassNames(new String[]{"text-secondary", "w-l", "h-l"});
    }

    protected void initProcessInfoHBoxStyles() {
        this.processInfoHBox.addClassNames(new String[]{"ml-auto"});
        this.processCountLabel.addClassNames(new String[]{"text-l", "text-secondary", "font-medium"});
        this.processIdLabel.addClassNames(new String[]{"text-l", "text-secondary", "font-medium"});
        this.processCountInfoIcon.addClassNames(new String[]{"text-s", "text-primary"});
        this.setProcessCountTooltipClassName();
    }

    protected void deployBpmnXml(byte[] uploadedXml) {
        this.deploymentReportDc.setItem(null);
        String uploadedFileName = this.bpmnXmlUploadField.getUploadedFileName();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(uploadedXml);){
            DeploymentWithDefinitions result = this.deploymentService.createDeployment(new DeploymentContext().withResource(uploadedFileName, (InputStream)inputStream));
            List deployedProcessDefinitions = result.getDeployedProcessDefinitions();
            int size = CollectionUtils.size((Object)deployedProcessDefinitions);
            this.notifications.create(this.messageBundle.formatMessage("processesDeployed", new Object[]{size})).withType(Notifications.Type.SUCCESS).withDuration(2000).show();
            this.close(StandardOutcome.SAVE);
        }
        catch (IOException ex) {
            log.error("Error on uploaded file reading ", (Throwable)ex);
            this.notifications.create(this.messageBundle.getMessage("errorOnUploadedFileReading")).withType(Notifications.Type.ERROR).withDuration(2000).show();
        }
        catch (Exception ex) {
            log.error("Error on process deployment", (Throwable)ex);
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)ex);
            if (rootCause instanceof RemoteEngineParseException) {
                RemoteEngineParseException parseException = (RemoteEngineParseException)rootCause;
                ResourceReport resourceReport = (ResourceReport)parseException.getDetails().get(uploadedFileName);
                this.handleResourceReport(resourceReport, uploadedFileName);
            }
            if (ex instanceof RemoteProcessEngineException) {
                this.notifications.create(this.messageBundle.getMessage("processesNotDeployed"), ex.getMessage()).withType(Notifications.Type.ERROR).withDuration(2000).show();
            }
            throw ex;
        }
    }

    @Nullable
    protected List<ProcessDefinitionData> findExistingProcessesByKeys() {
        List existingProcesses = null;
        if (CollectionUtils.isNotEmpty((Collection)this.processDefinitions)) {
            ProcessDefinitionFilter filter = (ProcessDefinitionFilter)this.metadata.create(ProcessDefinitionFilter.class);
            filter.setKeyIn(this.processDefinitions.stream().map(BpmProcessDefinition::getKey).toList());
            existingProcesses = this.processDefinitionService.findAll(new ProcessDefinitionLoadContext().setFilter(filter));
        }
        return existingProcesses;
    }

    protected void updateImportedProcesses(XmlImportCompleteEvent importCompleteEvent) {
        this.processDefinitions = BpmParseUtil.parseProcessDefinitionsJson((String)importCompleteEvent.getProcessDefinitionsJson());
        this.updateProcessCountComponents();
    }

    protected void updateProcessCountComponents() {
        boolean multipleProcessDefinitions;
        boolean hasProcessDefinitions;
        boolean bl = hasProcessDefinitions = !this.processDefinitions.isEmpty();
        if (!hasProcessDefinitions) {
            this.processInfoHBox.setVisible(false);
            return;
        }
        boolean bl2 = multipleProcessDefinitions = this.processDefinitions.size() > 1;
        if (multipleProcessDefinitions) {
            Tooltip tooltip = this.processCountInfoIcon.getTooltip();
            String processDefinitionsString = this.getProcessDefinitionsString();
            tooltip.setText(processDefinitionsString);
            this.processCountLabel.setText(this.messageBundle.formatMessage("collaborationProcessesLabel", new Object[]{String.valueOf(this.processDefinitions.size())}));
        } else {
            this.processIdLabel.setText(((BpmProcessDefinition)this.processDefinitions.get(0)).getKey());
        }
        this.processInfoHBox.setVisible(true);
        this.processCountInfoIcon.setVisible(multipleProcessDefinitions);
        this.processCountLabel.setVisible(multipleProcessDefinitions);
        this.collaborationLabel.setVisible(multipleProcessDefinitions);
        this.processIdLabel.setVisible(!multipleProcessDefinitions);
        this.processLabel.setVisible(!multipleProcessDefinitions);
    }

    protected String getProcessDefinitionsString() {
        return this.processDefinitions.stream().map(bpmProcessDefinition -> {
            int idx = this.processDefinitions.indexOf(bpmProcessDefinition) + 1;
            return this.messageBundle.formatMessage("importedProcessKeyAndName", new Object[]{idx, StringUtils.defaultIfEmpty((CharSequence)bpmProcessDefinition.getKey(), (CharSequence)"-"), StringUtils.defaultIfEmpty((CharSequence)bpmProcessDefinition.getName(), (CharSequence)"-")});
        }).collect(Collectors.joining("\n"));
    }

    protected void setProcessCountTooltipClassName() {
        this.processCountInfoIcon.getElement().executeJs("   if ($0.getElementsByTagName('vaadin-tooltip').length == 1) {\n       $0.getElementsByTagName('vaadin-tooltip')[0]._overlayElement.setAttribute('class','process-tooltip');\n   } else {\n       const tooltips = document.getElementsByTagName('vaadin-tooltip');\n       for (let i=0; i<tooltips.length; i++ ) {\n           const tooltip = tooltips[i];\n           if (tooltip._overlayElement.id === $0.getAttribute('aria-describedBy')) {\n               tooltip._overlayElement.setAttribute('class','process-tooltip')\n           }\n       }\n   }\n", new Serializable[]{this.processCountInfoIcon});
    }

    protected VerticalLayout createConfirmDialogContent(List<ProcessDefinitionData> existingProcesses) {
        DeploymentConfirmContentFragment fragment = (DeploymentConfirmContentFragment)this.fragments.create((FragmentOwner)this, DeploymentConfirmContentFragment.class);
        fragment.setExistingProcesses(existingProcesses);
        fragment.setDeployingProcesses(this.processDefinitions);
        return (VerticalLayout)fragment.getContent();
    }
}

