/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.processdefinition;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.router.RouteParameters;
import io.jmix.core.Messages;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.fragment.Fragment;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.kit.component.dropdownbutton.DropdownButton;
import io.jmix.flowui.kit.component.dropdownbutton.DropdownButtonItem;
import io.jmix.flowui.model.CollectionContainer;
import io.jmix.flowui.model.DataLoader;
import io.jmix.flowui.model.HasLoader;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.openbpm.control.entity.processdefinition.ProcessDefinitionData;
import io.openbpm.control.view.processdefinition.ActivateProcessDefinitionView;
import io.openbpm.control.view.processdefinition.DeleteProcessDefinitionView;
import io.openbpm.control.view.processdefinition.ProcessDefinitionDetailView;
import io.openbpm.control.view.processdefinition.SuspendProcessDefinitionView;
import io.openbpm.control.view.processinstancemigration.ProcessInstanceMigrationView;
import io.openbpm.control.view.startprocess.StartProcessWithVariableView;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@FragmentDescriptor(value="process-definition-list-item-actions-fragment.xml")
public class ProcessDefinitionListItemActionsFragment
extends Fragment<HorizontalLayout> {
    @ViewComponent
    protected CollectionContainer<ProcessDefinitionData> processDefinitionsDc;
    @Autowired
    protected ViewNavigators viewNavigators;
    @Autowired
    protected DialogWindows dialogWindows;
    @Autowired
    protected Notifications notifications;
    @Autowired
    protected Messages messages;
    @ViewComponent
    protected MessageBundle messageBundle;
    @ViewComponent
    protected JmixButton startProcessBtn;
    @ViewComponent
    protected JmixButton viewDetailsBtn;
    @ViewComponent
    protected Button activateBtn;
    @ViewComponent
    protected DropdownButton suspendedProcessActions;
    @ViewComponent
    protected DropdownButton activeProcessActions;
    protected ProcessDefinitionData processDefinition;

    public void setProcessDefinition(ProcessDefinitionData processDefinition) {
        this.processDefinition = processDefinition;
        this.updateButtonsVisibility();
    }

    @Subscribe
    public void onReady(Fragment.ReadyEvent event) {
        this.activeProcessActions.addClassName("me-auto");
        this.suspendedProcessActions.addClassName("me-auto");
        this.startProcessBtn.addClassNames(new String[]{"h-m"});
        this.viewDetailsBtn.addClassNames(new String[]{"h-m"});
        this.activateBtn.addClassNames(new String[]{"h-m"});
        this.activeProcessActions.addClassNames(new String[]{"h-m"});
        this.suspendedProcessActions.addClassNames(new String[]{"h-m"});
    }

    public void updateButtonsVisibility() {
        boolean suspended = Boolean.TRUE.equals(this.processDefinition.getSuspended());
        this.activateBtn.setVisible(suspended);
        this.startProcessBtn.setVisible(!suspended);
        this.suspendedProcessActions.setVisible(suspended);
        this.activeProcessActions.setVisible(!suspended);
    }

    @Subscribe(id="startProcessBtn", subject="clickListener")
    public void onStartProcessBtnClick(ClickEvent<JmixButton> event) {
        this.dialogWindows.detail(this.getView(), ProcessDefinitionData.class).withViewClass(StartProcessWithVariableView.class).editEntity((Object)this.processDefinition).withAfterCloseListener(e -> {
            if (e.closedWith(StandardOutcome.SAVE)) {
                this.notifications.create(this.messages.formatMessage(this.getClass(), "startProcess.success", new Object[]{StringUtils.defaultIfEmpty((CharSequence)this.processDefinition.getName(), (CharSequence)this.processDefinition.getKey())})).withType(Notifications.Type.SUCCESS).build().open();
            }
        }).open();
    }

    @Subscribe(value="activateBtn")
    protected void onActivateBtnClick(ClickEvent<Button> event) {
        this.dialogWindows.view(this.getView(), ActivateProcessDefinitionView.class).withAfterCloseListener(closeEvent -> {
            if (closeEvent.closedWith(StandardOutcome.SAVE)) {
                this.reloadProcessDefinitions();
            }
        }).withViewConfigurer(view -> view.setProcessDefinitionId(this.processDefinition.getId())).build().open();
    }

    @Subscribe(value="viewDetailsBtn")
    public void onViewDetailsBtnClick(ClickEvent<Button> event) {
        this.viewNavigators.detailView(this.getView(), ProcessDefinitionData.class).withViewClass(ProcessDefinitionDetailView.class).withRouteParameters(new RouteParameters("id", this.processDefinition.getId())).withBackwardNavigation(true).navigate();
    }

    @Subscribe(value="activeProcessActions.delete")
    public void onActiveProcessActionsRemoveClick(DropdownButtonItem.ClickEvent event) {
        this.openDeleteConfirmDialog();
    }

    @Subscribe(value="activeProcessActions.suspend")
    public void onActiveProcessActionsSuspendClick(DropdownButtonItem.ClickEvent event) {
        this.openSuspendConfirmDialog();
    }

    @Subscribe(value="activeProcessActions.migrate")
    public void onActiveProcessActionsMigrateClick(DropdownButtonItem.ClickEvent event) {
        this.openProcessInstanceMigrationDialog();
    }

    @Subscribe(value="suspendedProcessActions.delete")
    public void onSuspendedProcessActionsRemoveClick(DropdownButtonItem.ClickEvent event) {
        this.openDeleteConfirmDialog();
    }

    @Subscribe(value="suspendedProcessActions.migrate")
    public void onSuspendedProcessActionsMigrateClick(DropdownButtonItem.ClickEvent event) {
        this.openProcessInstanceMigrationDialog();
    }

    protected void openDeleteConfirmDialog() {
        this.dialogWindows.view(this.getView(), DeleteProcessDefinitionView.class).withAfterCloseListener(closeEvent -> {
            if (closeEvent.closedWith(StandardOutcome.SAVE)) {
                this.reloadProcessDefinitions();
            }
        }).withViewConfigurer(view -> view.setProcessDefinitionId(this.processDefinition.getId())).build().open();
    }

    protected void openSuspendConfirmDialog() {
        this.dialogWindows.view(this.getView(), SuspendProcessDefinitionView.class).withAfterCloseListener(closeEvent -> {
            if (closeEvent.closedWith(StandardOutcome.SAVE)) {
                this.reloadProcessDefinitions();
            }
        }).withViewConfigurer(view -> view.setProcessDefinitionId(this.processDefinition.getId())).build().open();
    }

    protected void openProcessInstanceMigrationDialog() {
        this.dialogWindows.view(this.getView(), ProcessInstanceMigrationView.class).withAfterCloseListener(afterCloseEvent -> {
            if (afterCloseEvent.closedWith(StandardOutcome.SAVE)) {
                this.notifications.create(this.messageBundle.getMessage("processInstancesMigrationStarted")).withType(Notifications.Type.SUCCESS).show();
            }
        }).withViewConfigurer(view -> view.setProcessDefinitionData(this.processDefinition)).build().open();
    }

    protected void reloadProcessDefinitions() {
        HasLoader container;
        DataLoader loader;
        CollectionContainer collectionContainer = this.processDefinitionsDc;
        if (collectionContainer instanceof HasLoader && (loader = (container = (HasLoader)collectionContainer).getLoader()) != null) {
            loader.load();
        }
    }

    protected View<?> getView() {
        return (View)this.getParentController();
    }
}

