/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.processinstance;

import com.google.common.collect.ImmutableMap;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.router.QueryParameters;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.facet.UrlQueryParametersFacet;
import io.jmix.flowui.facet.urlqueryparameters.AbstractUrlQueryParametersBinder;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.model.CollectionLoader;
import io.jmix.flowui.model.InstanceContainer;
import io.openbpm.control.entity.filter.ProcessInstanceFilter;
import io.openbpm.control.entity.processinstance.ProcessInstanceData;
import io.openbpm.control.entity.processinstance.ProcessInstanceState;
import io.openbpm.control.view.processinstance.ProcessInstanceListParamBinder;
import io.openbpm.control.view.processinstance.ProcessInstanceViewMode;
import io.openbpm.control.view.processinstance.filter.ProcessInstanceStateHeaderFilter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;

public class ProcessInstanceListParamBinder
extends AbstractUrlQueryParametersBinder {
    private static final String MODE_URL_PARAM = "mode";
    private final InstanceContainer<ProcessInstanceFilter> filterDc;
    private final CollectionLoader<ProcessInstanceData> processInstanceDl;
    private final ProcessInstanceStateHeaderFilter stateHeaderFilter;
    private final List<JmixButton> modeButtons;

    public ProcessInstanceListParamBinder(HorizontalLayout buttonsPanel, InstanceContainer<ProcessInstanceFilter> filterDc, CollectionLoader<ProcessInstanceData> processInstanceDl, DataGrid<ProcessInstanceData> dataGrid) {
        this.filterDc = filterDc;
        this.processInstanceDl = processInstanceDl;
        this.stateHeaderFilter = Optional.ofNullable(dataGrid.getColumnByKey("state")).map(column -> (ProcessInstanceStateHeaderFilter)column.getHeaderComponent()).orElse(null);
        this.modeButtons = IntStream.range(0, buttonsPanel.getComponentCount()).mapToObj(buttonIdx -> {
            JmixButton modeBtn = (JmixButton)buttonsPanel.getComponentAt(buttonIdx);
            modeBtn.addClickListener((ComponentEventListener & Serializable)clickEvent -> {
                boolean active = modeBtn.hasThemeName("primary");
                if (!active) {
                    this.activateModeButton(buttonIdx);
                }
            });
            return modeBtn;
        }).toList();
    }

    public Component getComponent() {
        return null;
    }

    public void updateState(QueryParameters queryParameters) {
        List modeStrings = (List)queryParameters.getParameters().get(MODE_URL_PARAM);
        if (CollectionUtils.isNotEmpty((Collection)modeStrings)) {
            ProcessInstanceViewMode mode = ProcessInstanceViewMode.fromId((String)((String)modeStrings.get(0)));
            this.loadInstances(mode);
        }
    }

    private void activateModeButton(int activeButtonIdx) {
        this.updateButtons(activeButtonIdx);
        ProcessInstanceViewMode mode = ProcessInstanceViewMode.values()[activeButtonIdx];
        this.loadInstances(mode);
        QueryParameters qp = new QueryParameters((Map)ImmutableMap.of((Object)MODE_URL_PARAM, Collections.singletonList(mode.getId())));
        this.fireQueryParametersChanged(new UrlQueryParametersFacet.UrlQueryParametersChangeEvent((UrlQueryParametersFacet.Binder)this, qp));
        if (this.stateHeaderFilter != null) {
            this.stateHeaderFilter.update(mode);
        }
    }

    private void updateButtons(int activeIdx) {
        IntStream.range(0, this.modeButtons.size()).forEach(idx -> {
            JmixButton modeBtn = (JmixButton)this.modeButtons.get(idx);
            if (activeIdx == idx) {
                modeBtn.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
            } else {
                modeBtn.removeThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
            }
        });
    }

    private void loadInstances(ProcessInstanceViewMode mode) {
        if (mode == null) {
            ((ProcessInstanceFilter)this.filterDc.getItem()).setState(null);
            ((ProcessInstanceFilter)this.filterDc.getItem()).setUnfinished(Boolean.valueOf(true));
            this.processInstanceDl.load();
            return;
        }
        switch (1.$SwitchMap$io$openbpm$control$view$processinstance$ProcessInstanceViewMode[mode.ordinal()]) {
            case 1: {
                ((ProcessInstanceFilter)this.filterDc.getItem()).setState(null);
                ((ProcessInstanceFilter)this.filterDc.getItem()).setUnfinished(null);
                this.processInstanceDl.load();
                break;
            }
            case 2: {
                ((ProcessInstanceFilter)this.filterDc.getItem()).setState(ProcessInstanceState.COMPLETED);
                ((ProcessInstanceFilter)this.filterDc.getItem()).setUnfinished(null);
                this.processInstanceDl.load();
                break;
            }
            default: {
                ((ProcessInstanceFilter)this.filterDc.getItem()).setState(null);
                ((ProcessInstanceFilter)this.filterDc.getItem()).setUnfinished(Boolean.valueOf(true));
                this.processInstanceDl.load();
            }
        }
    }
}

