/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.processinstance.filter;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import io.jmix.flowui.component.datetimepicker.TypedDateTimePicker;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.component.grid.DataGridColumn;
import io.jmix.flowui.model.InstanceContainer;
import io.openbpm.control.entity.filter.ProcessInstanceFilter;
import io.openbpm.control.entity.processinstance.ProcessInstanceData;
import io.openbpm.control.view.processinstance.filter.ProcessInstanceDataGridHeaderFilter;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class StartTimeHeaderFilter
extends ProcessInstanceDataGridHeaderFilter {
    private TypedDateTimePicker<LocalDateTime> startTimeAfter;
    private TypedDateTimePicker<LocalDateTime> startTimeBefore;

    public StartTimeHeaderFilter(DataGrid<ProcessInstanceData> dataGrid, DataGridColumn<ProcessInstanceData> column, InstanceContainer<ProcessInstanceFilter> filterDc) {
        super(dataGrid, column, filterDc);
    }

    protected Component createFilterComponent() {
        Component startTimeAfterFilter = this.createStartTimeAfterFilter();
        Component startTimeBeforeFilter = this.createStartTimeBeforeFilter();
        VerticalLayout rootLayout = (VerticalLayout)this.uiComponents.create(VerticalLayout.class);
        rootLayout.setPadding(false);
        rootLayout.setSpacing(false);
        rootLayout.add(new Component[]{startTimeAfterFilter, startTimeBeforeFilter});
        return rootLayout;
    }

    public void apply() {
        LocalDateTime startTimeBefore = (LocalDateTime)this.startTimeBefore.getValue();
        if (startTimeBefore != null) {
            ZoneId zoneId = this.startTimeBefore.getZoneId();
            ZoneId zone = zoneId != null ? zoneId : ZoneId.systemDefault();
            ((ProcessInstanceFilter)this.filterDc.getItem()).setStartTimeBefore(startTimeBefore.atZone(zone).toOffsetDateTime());
        } else {
            ((ProcessInstanceFilter)this.filterDc.getItem()).setStartTimeBefore(null);
        }
        LocalDateTime startTimeAfter = (LocalDateTime)this.startTimeAfter.getValue();
        if (startTimeAfter != null) {
            ZoneId zoneId = this.startTimeAfter.getZoneId();
            ZoneId zone = zoneId != null ? zoneId : ZoneId.systemDefault();
            ((ProcessInstanceFilter)this.filterDc.getItem()).setStartTimeAfter(startTimeAfter.atZone(zone).toOffsetDateTime());
        } else {
            ((ProcessInstanceFilter)this.filterDc.getItem()).setStartTimeAfter(null);
        }
        this.filterButton.getElement().setAttribute("activated", startTimeAfter != null || startTimeBefore != null);
    }

    protected void resetFilterValues() {
        this.startTimeAfter.clear();
        this.startTimeBefore.clear();
    }

    private Component createStartTimeBeforeFilter() {
        this.startTimeBefore = (TypedDateTimePicker)this.uiComponents.create(TypedDateTimePicker.class);
        this.startTimeBefore.setMax(LocalDateTime.now());
        this.startTimeBefore.setDatePlaceholder(this.messages.getMessage(this.getClass(), "selectDate"));
        this.startTimeBefore.setTimePlaceholder(this.messages.getMessage(this.getClass(), "selectTime"));
        this.startTimeBefore.setLabel(this.messages.getMessage(ProcessInstanceFilter.class, "ProcessInstanceFilter.startTimeBefore"));
        this.setDefaultTime(this.startTimeBefore);
        return this.startTimeBefore;
    }

    private Component createStartTimeAfterFilter() {
        this.startTimeAfter = (TypedDateTimePicker)this.uiComponents.create(TypedDateTimePicker.class);
        this.startTimeAfter.setDatePlaceholder(this.messages.getMessage(this.getClass(), "selectDate"));
        this.startTimeAfter.setTimePlaceholder(this.messages.getMessage(this.getClass(), "selectTime"));
        this.startTimeAfter.setMax(LocalDateTime.now());
        this.startTimeAfter.setLabel(this.messages.getMessage(ProcessInstanceFilter.class, "ProcessInstanceFilter.startTimeAfter"));
        this.setDefaultTime(this.startTimeAfter);
        return this.startTimeAfter;
    }

    private void setDefaultTime(TypedDateTimePicker<LocalDateTime> dateTimePicker) {
        dateTimePicker.getElement().executeJs("this.__datePicker.addEventListener('change', function(){this.__timePicker.value='00:00';}.bind(this));", new Serializable[0]);
    }
}

