/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.control.view.processinstance.runtime;

import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.event.SortEvent;
import io.jmix.core.DataLoadContext;
import io.jmix.core.LoadContext;
import io.jmix.core.Metadata;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.UiEventPublisher;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.fragment.Fragment;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.model.CollectionLoader;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.ViewComponent;
import io.openbpm.control.entity.UserTaskData;
import io.openbpm.control.entity.filter.UserTaskFilter;
import io.openbpm.control.entity.processinstance.ProcessInstanceData;
import io.openbpm.control.service.usertask.UserTaskLoadContext;
import io.openbpm.control.service.usertask.UserTaskService;
import io.openbpm.control.view.processinstance.event.UserTaskCountUpdateEvent;
import io.openbpm.control.view.taskreassign.TaskReassignView;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;

@FragmentDescriptor(value="runtime-user-tasks-tab-fragment.xml")
public class RuntimeUserTasksTabFragment
extends Fragment<VerticalLayout> {
    @Autowired
    protected UserTaskService userTaskService;
    @Autowired
    protected Metadata metadata;
    @Autowired
    protected UiEventPublisher uiEventPublisher;
    @Autowired
    protected DialogWindows dialogWindows;
    @Autowired
    protected ViewNavigators viewNavigators;
    @ViewComponent
    protected CollectionLoader<UserTaskData> runtimeUserTasksDl;
    @ViewComponent
    protected DataGrid<UserTaskData> runtimeUserTasksGrid;
    @ViewComponent
    protected InstanceContainer<ProcessInstanceData> processInstanceDataDc;
    protected UserTaskFilter filter;
    protected String selectedActivityInstanceId;
    protected boolean initialized = false;

    public void setSelectedActivityInstanceId(String selectedActivityInstanceId) {
        this.selectedActivityInstanceId = selectedActivityInstanceId;
    }

    public void refreshIfChanged(String selectedActivityInstanceId) {
        if (!this.initialized) {
            this.filter = (UserTaskFilter)this.metadata.create(UserTaskFilter.class);
            this.filter.setProcessInstanceId(((ProcessInstanceData)this.processInstanceDataDc.getItem()).getId());
            this.runtimeUserTasksDl.load();
            this.initialized = true;
            return;
        }
        if (!StringUtils.equals((CharSequence)this.selectedActivityInstanceId, (CharSequence)selectedActivityInstanceId)) {
            this.selectedActivityInstanceId = selectedActivityInstanceId;
            this.filter.setActivityInstanceId(selectedActivityInstanceId);
            this.runtimeUserTasksDl.load();
        }
    }

    @Subscribe(value="runtimeUserTasksGrid.view")
    public void onViewAction(ActionPerformedEvent event) {
        UserTaskData userTaskData = (UserTaskData)this.runtimeUserTasksGrid.getSingleSelectedItem();
        if (userTaskData == null) {
            return;
        }
        this.dialogWindows.detail(UiComponentUtils.getCurrentView(), UserTaskData.class).editEntity((Object)userTaskData).build().open();
    }

    @Install(to="runtimeUserTasksGrid.reassign", subject="enabledRule")
    protected boolean runtimeUserTasksGridReassignEnabledRule() {
        UserTaskData selectedTask = (UserTaskData)this.runtimeUserTasksGrid.getSingleSelectedItem();
        return selectedTask != null && BooleanUtils.isNotTrue((Boolean)selectedTask.getSuspended());
    }

    @Subscribe(value="runtimeUserTasksGrid.reassign")
    public void onReassignAction(ActionPerformedEvent event) {
        Set userTasks = this.runtimeUserTasksGrid.getSelectedItems();
        if (userTasks.isEmpty()) {
            return;
        }
        this.dialogWindows.view(UiComponentUtils.getCurrentView(), TaskReassignView.class).withAfterCloseListener(closeEvent -> {
            if (closeEvent.closedWith(StandardOutcome.SAVE)) {
                this.runtimeUserTasksDl.load();
            }
        }).withViewConfigurer(taskReassignView -> taskReassignView.setTaskDataList((Collection)userTasks)).build().open();
    }

    @Install(to="runtimeUserTasksDl", target=Target.DATA_LOADER)
    protected List<UserTaskData> runtimeUserTasksDlLoadDelegate(LoadContext<UserTaskData> loadContext) {
        LoadContext.Query query = loadContext.getQuery();
        UserTaskLoadContext context = new UserTaskLoadContext().setFilter(this.filter);
        if (query != null) {
            context.setFirstResult(Integer.valueOf(query.getFirstResult())).setMaxResults(Integer.valueOf(query.getMaxResults())).setSort(query.getSort());
        }
        return this.userTaskService.findRuntimeTasks(context);
    }

    @Install(to="userTasksPagination", subject="totalCountDelegate")
    protected Integer userTasksPaginationTotalCountDelegate(DataLoadContext dataLoadContext) {
        long runtimeTasksCount = this.userTaskService.getRuntimeTasksCount(this.filter);
        this.uiEventPublisher.publishEventForCurrentUI((ApplicationEvent)new UserTaskCountUpdateEvent((Object)this, runtimeTasksCount));
        return (int)runtimeTasksCount;
    }

    @Subscribe(value="runtimeUserTasksGrid")
    public void onRuntimeUserTasksGridGridSort(SortEvent<DataGrid<UserTaskData>, GridSortOrder<DataGrid<UserTaskData>>> event) {
        this.runtimeUserTasksDl.load();
    }
}

